/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.bcel.classfile.Code;

public class OverridingEqualsNotSymmetrical
extends OpcodeStackDetector {
    private static final String EQUALS_NAME = "equals";
    private static final String EQUALS_SIGNATURE = "(Ljava/lang/Object;)Z";
    Map<ClassAnnotation, KindOfEquals> kindMap = new HashMap<ClassAnnotation, KindOfEquals>();
    Map<ClassDescriptor, Set<ClassDescriptor>> classesWithGetClassBasedEquals = new HashMap<ClassDescriptor, Set<ClassDescriptor>>();
    Map<ClassAnnotation, ClassAnnotation> parentMap = new TreeMap<ClassAnnotation, ClassAnnotation>();
    Map<ClassAnnotation, MethodAnnotation> equalsMethod = new TreeMap<ClassAnnotation, MethodAnnotation>();
    BugReporter bugReporter;
    boolean sawInstanceOf;
    boolean sawInstanceOfSupertype;
    boolean sawCheckedCast;
    boolean sawGetClass;
    boolean sawReturnSuper;
    boolean sawSuperEquals;
    boolean sawReturnNonSuper;
    boolean prevWasSuperEquals;
    boolean sawInitialIdentityCheck;
    boolean alwaysTrue;
    boolean alwaysFalse;
    int equalsCalls;
    boolean sawGoodEqualsClass;
    boolean sawBadEqualsClass;
    boolean sawCompare;
    boolean dangerDanger = false;
    private EnumMap<KindOfEquals, Integer> count = new EnumMap(KindOfEquals.class);

    public OverridingEqualsNotSymmetrical(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        if (this.getMethodName().equals(EQUALS_NAME) && !this.getMethod().isStatic() && this.getMethod().isPublic() && this.getMethodSig().equals(EQUALS_SIGNATURE)) {
            this.alwaysFalse = false;
            this.alwaysTrue = false;
            this.sawInstanceOfSupertype = false;
            this.dangerDanger = false;
            this.sawBadEqualsClass = false;
            this.sawGoodEqualsClass = false;
            this.prevWasSuperEquals = false;
            this.sawReturnNonSuper = false;
            this.sawCompare = false;
            this.sawReturnSuper = false;
            this.sawGetClass = false;
            this.sawInstanceOf = false;
            this.sawSuperEquals = false;
            this.sawCheckedCast = false;
            this.sawInitialIdentityCheck = obj.getCode().length == 11 || obj.getCode().length == 9;
            this.equalsCalls = 0;
            super.visit(obj);
            KindOfEquals kind = KindOfEquals.UNKNOWN;
            if (this.alwaysTrue) {
                kind = KindOfEquals.ALWAYS_TRUE;
            } else if (this.alwaysFalse) {
                kind = KindOfEquals.ALWAYS_FALSE;
            } else if (this.sawReturnSuper && !this.sawReturnNonSuper) {
                kind = KindOfEquals.RETURNS_SUPER;
            } else if (this.sawSuperEquals) {
                kind = KindOfEquals.INVOKES_SUPER;
            } else if (this.sawInstanceOf || this.sawInstanceOfSupertype) {
                kind = this.getThisClass().isAbstract() ? KindOfEquals.ABSTRACT_INSTANCE_OF : KindOfEquals.INSTANCE_OF_EQUALS;
            } else if (this.sawGetClass && this.sawGoodEqualsClass) {
                kind = this.getThisClass().isAbstract() ? KindOfEquals.ABSTRACT_GETCLASS_GOOD_EQUALS : KindOfEquals.GETCLASS_GOOD_EQUALS;
            } else if (this.sawGetClass && this.sawBadEqualsClass) {
                kind = KindOfEquals.GETCLASS_BAD_EQUALS;
            } else if (this.equalsCalls == 1) {
                kind = KindOfEquals.DELEGATE_EQUALS;
            } else if (this.sawInitialIdentityCheck) {
                kind = KindOfEquals.TRIVIAL_EQUALS;
            } else if (this.sawCheckedCast) {
                kind = KindOfEquals.CHECKED_CAST_EQUALS;
            } else if (this.sawCompare) {
                kind = KindOfEquals.COMPARE_EQUALS;
            } else {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "EQ_UNUSUAL", 2).addClassAndMethod((PreorderVisitor)this).addString("Strange equals method"));
            }
            this.count(kind);
            if (kind == KindOfEquals.GETCLASS_GOOD_EQUALS || kind == KindOfEquals.ABSTRACT_GETCLASS_GOOD_EQUALS || kind == KindOfEquals.GETCLASS_BAD_EQUALS) {
                ClassDescriptor classDescriptor = this.getClassDescriptor();
                try {
                    Set subtypes = AnalysisContext.currentAnalysisContext().getSubtypes2().getSubtypes(classDescriptor);
                    if (subtypes.size() > 1) {
                        this.classesWithGetClassBasedEquals.put(classDescriptor, subtypes);
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            ClassAnnotation classAnnotation = new ClassAnnotation(this.getDottedClassName());
            this.kindMap.put(classAnnotation, kind);
            String superClassName = this.getSuperclassName().replace('/', '.');
            if (!superClassName.equals("java.lang.Object")) {
                this.parentMap.put(classAnnotation, new ClassAnnotation(superClassName));
            }
            this.equalsMethod.put(classAnnotation, MethodAnnotation.fromVisitedMethod((PreorderVisitor)this));
        }
    }

    private void count(KindOfEquals k) {
        Integer v = this.count.get((Object)k);
        if (v == null) {
            this.count.put(k, 1);
        } else {
            this.count.put(k, v + 1);
        }
    }

    public void sawOpcode(int seen) {
        OpcodeStack.Item left;
        if (this.getPC() == 2 && seen != 165 && seen != 166) {
            this.sawInitialIdentityCheck = false;
        }
        if (seen == 172 && this.getPC() == 1 && this.getPrevOpcode(1) == 3) {
            this.alwaysFalse = true;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "EQ_ALWAYS_FALSE", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        if (seen == 172 && this.getPC() == 1 && this.getPrevOpcode(1) == 4) {
            this.alwaysTrue = true;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "EQ_ALWAYS_TRUE", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        if (seen == 165 || seen == 166) {
            this.checkForComparingClasses();
        }
        if (seen == 182 && this.getNameConstantOperand().equals(EQUALS_NAME) && this.getSigConstantOperand().equals(EQUALS_SIGNATURE)) {
            ++this.equalsCalls;
            this.checkForComparingClasses();
        }
        if (this.dangerDanger && seen == 182 && this.getNameConstantOperand().equals(EQUALS_NAME) && this.getSigConstantOperand().equals(EQUALS_SIGNATURE)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "EQ_COMPARING_CLASS_NAMES", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        if ((seen == 185 || seen == 182) && this.getNameConstantOperand().equals("comapre") && this.stack.getStackDepth() >= 2) {
            left = this.stack.getStackItem(1);
            OpcodeStack.Item right = this.stack.getStackItem(0);
            if (left.getRegisterNumber() + right.getRegisterNumber() == 1) {
                this.sawCompare = true;
            }
        }
        this.dangerDanger = false;
        if (seen == 182 && this.getClassConstantOperand().equals("java/lang/Class") && this.getNameConstantOperand().equals("getName") && this.getSigConstantOperand().equals("()Ljava/lang/String;") && this.stack.getStackDepth() >= 2) {
            left = this.stack.getStackItem(1);
            XMethod leftM = left.getReturnValueOf();
            OpcodeStack.Item right = this.stack.getStackItem(0);
            XMethod rightM = right.getReturnValueOf();
            if (leftM != null && rightM != null && leftM.getName().equals("getName") && rightM.getName().equals("getClass")) {
                this.dangerDanger = true;
            }
        }
        if (seen == 183 && this.getNameConstantOperand().equals(EQUALS_NAME) && this.getSigConstantOperand().equals(EQUALS_SIGNATURE)) {
            this.prevWasSuperEquals = true;
            this.sawSuperEquals = true;
        } else {
            if (seen == 172) {
                if (this.prevWasSuperEquals) {
                    this.sawReturnSuper = true;
                } else {
                    this.sawReturnNonSuper = true;
                }
            }
            this.prevWasSuperEquals = false;
        }
        if (seen == 193 && this.stack.getStackDepth() > 0 && this.stack.getStackItem(0).getRegisterNumber() == 1) {
            ClassDescriptor instanceOfCheck = this.getClassDescriptorOperand();
            if (instanceOfCheck.equals((Object)this.getClassDescriptor())) {
                this.sawInstanceOf = true;
            } else {
                try {
                    if (AnalysisContext.currentAnalysisContext().getSubtypes2().isSubtype(this.getClassDescriptor(), instanceOfCheck)) {
                        this.sawInstanceOfSupertype = true;
                    }
                }
                catch (ClassNotFoundException e) {
                    this.sawInstanceOfSupertype = true;
                }
            }
        }
        if (seen == 192 && this.stack.getStackDepth() > 0 && this.stack.getStackItem(0).getRegisterNumber() == 1) {
            ClassDescriptor castTo = this.getClassDescriptorOperand();
            if (castTo.equals((Object)this.getClassDescriptor())) {
                this.sawCheckedCast = true;
            }
            try {
                if (AnalysisContext.currentAnalysisContext().getSubtypes2().isSubtype(this.getClassDescriptor(), castTo)) {
                    this.sawCheckedCast = true;
                }
            }
            catch (ClassNotFoundException e) {
                this.sawCheckedCast = true;
            }
        }
        if (seen == 182 && this.getNameConstantOperand().equals("getClass") && this.getSigConstantOperand().equals("()Ljava/lang/Class;")) {
            this.sawGetClass = true;
        }
    }

    private void checkForComparingClasses() {
        if (this.stack.getStackDepth() >= 2) {
            OpcodeStack.Item left = this.stack.getStackItem(1);
            XMethod leftM = left.getReturnValueOf();
            OpcodeStack.Item right = this.stack.getStackItem(0);
            XMethod rightM = right.getReturnValueOf();
            if (left.getSignature().equals("Ljava/lang/Class;") && right.getSignature().equals("Ljava/lang/Class;")) {
                boolean rightMatch;
                boolean leftMatch = leftM != null && leftM.getName().equals("getClass");
                boolean bl = rightMatch = rightM != null && rightM.getName().equals("getClass");
                if (leftMatch && rightMatch) {
                    this.sawGoodEqualsClass = true;
                } else if (left.getConstant() != null && rightMatch || leftMatch && right.getConstant() != null) {
                    this.sawBadEqualsClass = true;
                    if (!this.getThisClass().isFinal()) {
                        int priority = 2;
                        try {
                            if (AnalysisContext.currentAnalysisContext().getSubtypes2().hasSubtypes(this.getClassDescriptor())) {
                                --priority;
                            }
                        }
                        catch (ClassNotFoundException e) {
                            this.bugReporter.reportMissingClass(e);
                        }
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "EQ_GETCLASS_AND_CLASS_CONSTANT", priority).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString("doesn't work for subtypes"));
                    }
                }
            }
        }
    }

    public void report() {
        for (Map.Entry<ClassAnnotation, ClassAnnotation> e : this.parentMap.entrySet()) {
            ClassAnnotation childClass = e.getKey();
            KindOfEquals childKind = this.kindMap.get(childClass);
            ClassAnnotation parentClass = e.getValue();
            KindOfEquals parentKind = this.kindMap.get(parentClass);
            if (parentKind == null || childKind != KindOfEquals.INSTANCE_OF_EQUALS || parentKind != KindOfEquals.INSTANCE_OF_EQUALS) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "EQ_OVERRIDING_EQUALS_NOT_SYMMETRIC", 2).add((BugAnnotation)childClass).add((BugAnnotation)this.equalsMethod.get(childClass)).add((BugAnnotation)this.equalsMethod.get(parentClass)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum KindOfEquals {
        OBJECT_EQUALS,
        ABSTRACT_INSTANCE_OF,
        INSTANCE_OF_EQUALS,
        COMPARE_EQUALS,
        CHECKED_CAST_EQUALS,
        RETURNS_SUPER,
        GETCLASS_GOOD_EQUALS,
        ABSTRACT_GETCLASS_GOOD_EQUALS,
        GETCLASS_BAD_EQUALS,
        DELEGATE_EQUALS,
        TRIVIAL_EQUALS,
        INVOKES_SUPER,
        ALWAYS_TRUE,
        ALWAYS_FALSE,
        UNKNOWN;

    }
}

