/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.FieldSummary;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class SynchronizationOnSharedBuiltinConstant
extends OpcodeStackDetector {
    BugReporter bugReporter;
    Set<String> badSignatures;
    private static final Pattern identified = Pattern.compile("\\p{Alnum}+");

    public SynchronizationOnSharedBuiltinConstant(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.badSignatures = new HashSet<String>();
        this.badSignatures.addAll(Arrays.asList("Ljava/lang/Boolean;", "Ljava/lang/Double;", "Ljava/lang/Float;", "Ljava/lang/Byte;", "Ljava/lang/Character;", "Ljava/lang/Short;", "Ljava/lang/Integer;", "Ljava/lang/Long;"));
    }

    private static boolean newlyConstructedObject(OpcodeStack.Item item) {
        XMethod method = item.getReturnValueOf();
        if (method == null) {
            return false;
        }
        return method.getName().equals("<init>");
    }

    public void sawOpcode(int seen) {
        if (seen == 194) {
            OpcodeStack.Item top = this.stack.getStackItem(0);
            String signature = top.getSignature();
            Object constant = top.getConstant();
            if (signature.equals("Ljava/lang/String;") && constant instanceof String) {
                BugInstance bug = new BugInstance((Detector)this, "DL_SYNCHRONIZATION_ON_SHARED_CONSTANT", 2).addClassAndMethod((PreorderVisitor)this);
                String value = (String)constant;
                if (identified.matcher(value).matches()) {
                    bug.addString(value).describe("STRING_CONSTANT");
                }
                this.bugReporter.reportBug(bug.addSourceLine((BytecodeScanningDetector)this));
            } else if (this.badSignatures.contains(signature)) {
                boolean isBoolean = signature.equals("Ljava/lang/Boolean;");
                XField field = top.getXField();
                FieldSummary fieldSummary = AnalysisContext.currentAnalysisContext().getFieldSummary();
                OpcodeStack.Item summary = fieldSummary.getSummary(field);
                int priority = 2;
                if (isBoolean) {
                    --priority;
                }
                if (SynchronizationOnSharedBuiltinConstant.newlyConstructedObject(summary)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "DL_SYNCHRONIZATION_ON_UNSHARED_BOXED_PRIMITIVE", 2).addClassAndMethod((PreorderVisitor)this).addType(signature).addOptionalField(field).addOptionalLocalVariable((DismantleBytecode)this, top).addSourceLine((BytecodeScanningDetector)this));
                } else if (isBoolean) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "DL_SYNCHRONIZATION_ON_BOOLEAN", priority).addClassAndMethod((PreorderVisitor)this).addOptionalField(field).addOptionalLocalVariable((DismantleBytecode)this, top).addSourceLine((BytecodeScanningDetector)this));
                } else {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "DL_SYNCHRONIZATION_ON_BOXED_PRIMITIVE", priority).addClassAndMethod((PreorderVisitor)this).addType(signature).addOptionalField(field).addOptionalLocalVariable((DismantleBytecode)this, top).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        }
    }
}

