/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.util;

import java.io.File;
import jp.sourceforge.mergedoc.pleiades.util.FastProperties;

public class UnMnemonicProperties
extends FastProperties {
    private static final long serialVersionUID = -4066795589235888438L;
    public static final String MNEMONIC_CHARS = "[\\w\\.@]";

    public UnMnemonicProperties() {
    }

    public UnMnemonicProperties(String path) {
        super(path);
    }

    public UnMnemonicProperties(File file) {
        super(file);
    }

    public String put(String key, String value) {
        return super.put(UnMnemonicProperties.removeEnMnemonic(key), this.removeJaMnemonic(value));
    }

    private String removeJaMnemonic(String value) {
        value = value.replaceFirst("\\(\\&[\\w\\.@]\\)", "");
        value = value.replaceFirst("\\(\\&\\)", "");
        return value;
    }

    public static String removeEnMnemonic(String enValue) {
        if (UnMnemonicProperties.hasEnMnemonic(enValue)) {
            return enValue.replaceFirst("\\&([\\w\\.@])", "$1");
        }
        return enValue;
    }

    public static boolean hasJaMnemonic(String value) {
        return value.matches("(?s)^.*?\\(\\&[\\w\\.@]\\).*$");
    }

    public static boolean hasEnMnemonic(String value) {
        return value.contains("&") && !value.contains("& ") && !value.contains("&&") && !value.contains("&lt;") && !value.contains("&gt;") && !value.contains("&amp;") && !value.contains("&quot;") && !value.contains("&nbsp;");
    }

    public static String toPropertyKey(String key) {
        return key.replaceAll("[ :=#!\t\\\\]", "\\\\$0").replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n");
    }

    public static String toPropertyValue(String value) {
        return value.replaceAll("#", "\\\\$0").replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n");
    }
}

