/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FastProperties;
import org.apache.commons.io.FileUtils;

public class PleiadesAllInOnePreference {
    private static Logger log = Logger.getLogger(PleiadesAllInOnePreference.class);

    public void setDefault() {
        if (!Pleiades.isWindows()) {
            return;
        }
        final File eclipseHomeParent = Pleiades.getEclipseHome().getParentFile();
        final File metadataDefault = new File(eclipseHomeParent, ".metadata.default");
        if (!metadataDefault.exists()) {
            return;
        }
        Pleiades.getExecutorService().execute(new Runnable(){

            public void run() {
                try {
                    PleiadesAllInOnePreference.this.setup(eclipseHomeParent, metadataDefault);
                }
                catch (Exception e) {
                    log.error("Pleiades All in One \u521d\u671f\u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
                }
            }
        });
    }

    private void setup(File eclipseHomeParent, File metadataDefault) throws URISyntaxException, IOException {
        File workspace = this.getWorkspace();
        File userMetadata = new File(workspace, ".metadata");
        String settingsDir = ".plugins/org.eclipse.core.runtime/.settings/";
        File templateDir = new File(metadataDefault, settingsDir);
        File[] fileArray = templateDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File templatePrefs = fileArray[n2];
            File userPrefs = new File(userMetadata, String.valueOf(settingsDir) + templatePrefs.getName());
            if (!userPrefs.exists()) {
                FileUtils.copyFile((File)templatePrefs, (File)userPrefs);
                String s = FileUtils.readFileToString((File)userPrefs);
                s = s.replace("%ECLIPSE_HOME_PARENT%", eclipseHomeParent.getPath().replace("\\", "/"));
                FileUtils.writeStringToFile((File)userPrefs, (String)s);
            }
            ++n2;
        }
    }

    private File getWorkspace() throws URISyntaxException {
        String workspacePath = System.getProperty("osgi.instance.area");
        if (workspacePath != null) {
            return new File(new URI(workspacePath));
        }
        File configuration = Pleiades.getConfigurationPath().getParentFile();
        File idePrefs = new File(configuration, ".settings/org.eclipse.ui.ide.prefs");
        String value = (String)new FastProperties(idePrefs).get("RECENT_WORKSPACES");
        workspacePath = value.replaceFirst("\n.*", "");
        return new File(workspacePath);
    }
}

