/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.commons.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

/**
 * blanco FrameworkɂAɊւ郆[eBeB̓܂܂܂B
 * 
 * ̃NX̓pbP[WOJƐݒ肵Ă܂B
 * 
 * @author IGA Tosiki
 */
class BlancoStringUtilReplace {
    /**
     * K\Ƃ͊֌WȂ̒us܂B
     * 
     * ̃\bhł java.lang.StringƂ͈قȂ萳K\͊֗^܂B<br>
     * K\@\ĂقȂu̍ۂɗp܂B
     * 
     * @param source
     *            ϊO̕B
     * @param replaceFrom
     *            uB
     * @param replaceTo
     *            u敶B
     * @return ϊ̕B
     */
    public static final String replaceAll(final String source,
            final char replaceFrom, final char replaceTo) {
        if (source == null) {
            throw new IllegalArgumentException(
                    "ũ\bhɁAϊƂnull^܂BnullȊO̒l^ĂB");
        }

        try {
            final StringReader reader = new StringReader(source);
            final StringWriter writer = new StringWriter();
            try {
                for (;;) {
                    int iRead = reader.read();
                    if (iRead < 0) {
                        break;
                    }
                    if (iRead == replaceFrom) {
                        iRead = replaceTo;
                    }
                    writer.write(iRead);
                }
                return writer.toString();
            } finally {
                reader.close();
                writer.close();
            }
        } catch (IOException ex) {
            throw new IllegalArgumentException(
                    "ũ\bh̏ɁAz肳ȂO܂Bf܂B" + ex.toString());
        }
    }

    /**
     * K\Ƃ͊֌WȂ̒us܂B
     * 
     * ̃\bhł java.lang.StringƂ͈قȂ萳K\͊֗^܂B<br>
     * K\@\ĂقȂu̍ۂɗp܂B
     * 
     * @param source
     *            ϊO̕B
     * @param replaceFrom
     *            uB
     * @param replaceTo
     *            u敶B
     * @param isReplaceAll
     *            SĒu邩ǂB
     * @return ϊ̕B
     */
    public static final String replace(final String source,
            final String replaceFrom, final String replaceTo,
            final boolean isReplaceAll) {
        if (source == null) {
            throw new IllegalArgumentException(
                    "ũ\bhɁAϊƂnull^܂BnullȊO̒l^ĂB");
        }
        if (replaceFrom == null) {
            throw new IllegalArgumentException(
                    "ũ\bhɁAuƂnull^܂B");
        }
        if (replaceFrom.length() == 0) {
            throw new IllegalArgumentException(
                    "ũ\bhɁAuƂĒ0̕񂪗^܂B");
        }
        if (replaceTo == null) {
            throw new IllegalArgumentException(
                    "ũ\bhɁAu敶Ƃnull^܂B");
        }

        final int indexFound = source.indexOf(replaceFrom);
        if (indexFound < 0) {
            return source;
        }
        final String pre = source.substring(0, indexFound);

        String suffix = source.substring(indexFound + replaceFrom.length());
        if (isReplaceAll) {
            final String suffixCheck = replace(suffix, replaceFrom, replaceTo,
                    false);
            if (suffix.equals(suffixCheck) == false) {
                suffix = replace(suffix, replaceFrom, replaceTo, true);
            }
        }

        return pre + replaceTo + suffix;
    }
}
