/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.nlpack.generator.task;

import java.io.IOException;

import blanco.nlpack.generator.task.valueobject.BlancoNLpackGeneratorTranslationFragmentToPleiadesProcessInput;

/**
 * ob`NX [BlancoNLpackGeneratorTranslationFragmentToPleiadesBatchProcess]B
 *
 *
 * ob`̌ĂяoB
 * <code>
 * java -classpath (NXpX) blanco.nlpack.generator.task.BlancoNLpackGeneratorTranslationFragmentToPleiadesBatchProcess -help
 * </code>
 */
public class BlancoNLpackGeneratorTranslationFragmentToPleiadesBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoNLpackGeneratorTranslationFragmentToPleiadesBatchProcess batchProcess = new BlancoNLpackGeneratorTranslationFragmentToPleiadesBatchProcess();

        // ob`̈B
        final BlancoNLpackGeneratorTranslationFragmentToPleiadesProcessInput input = new BlancoNLpackGeneratorTranslationFragmentToPleiadesProcessInput();

        boolean isNeedUsage = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-sourcefile=")) {
                input.setSourcefile(arg.substring(12));
            } else if (arg.startsWith("-targetfile=")) {
                input.setTargetfile(arg.substring(12));
            } else if (arg.startsWith("-sourcedir=")) {
                input.setSourcedir(arg.substring(11));
            } else if (arg.startsWith("-targetdir=")) {
                input.setTargetdir(arg.substring(11));
            } else if (arg.startsWith("-contributor=")) {
                input.setContributor(arg.substring(13));
            } else if (arg.startsWith("-isoutputdate=")) {
                input.setIsoutputdate(Boolean.valueOf(arg.substring(14)).booleanValue());
            } else if (arg.startsWith("-ischeckbundleuriasbabel=")) {
                input.setIscheckbundleuriasbabel(Boolean.valueOf(arg.substring(25)).booleanValue());
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoNLpackGeneratorTranslationFragmentToPleiadesBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoNLpackGeneratorTranslationFragmentToPleiadesProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoNLpackGeneratorTranslationFragmentToPleiadesProcessC^tF[X blanco.nlpack.generator.taskpbP[W BlancoNLpackGeneratorTranslationFragmentToPleiadesProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoNLpackGeneratorTranslationFragmentToPleiadesProcess process = new BlancoNLpackGeneratorTranslationFragmentToPleiadesProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoNLpackGeneratorTranslationFragmentToPleiadesProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoNLpackGeneratorTranslationFragmentToPleiadesBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoNLpackGeneratorTranslationFragmentToPleiadesBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoNLpackGeneratorTranslationFragmentToPleiadesBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoNLpackGeneratorTranslationFragmentToPleiadesBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoNLpackGeneratorTranslationFragmentToPleiadesBatchProcess: Usage:");
        System.out.println("  java blanco.nlpack.generator.task.BlancoNLpackGeneratorTranslationFragmentToPleiadesBatchProcess -verbose=l1 -sourcefile=l2 -targetfile=l3 -sourcedir=l4 -targetdir=l5 -contributor=l6 -isoutputdate=l7 -ischeckbundleuriasbabel=l8");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -sourcefile");
        System.out.println("      [̓t@CB]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[conf/BlancoNLpackGeneratorTranslationFragment.csv]");
        System.out.println("    -targetfile");
        System.out.println("      [o̓t@CB]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[tmp/BlancoNLpackGeneratorTranslationFragment.properties]");
        System.out.println("    -sourcedir");
        System.out.println("      [̓t@Ci[ꂽfBNgBsourcefileꂩwB]");
        System.out.println("      ^[]");
        System.out.println("    -targetdir");
        System.out.println("      [o̓t@Ci[ꂽfBNgBtargetfileꂩwB]");
        System.out.println("      ^[]");
        System.out.println("    -contributor");
        System.out.println("      [v҂̖OB]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[<contributor>]");
        System.out.println("    -isoutputdate");
        System.out.println("      [to͂邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[true]");
        System.out.println("    -ischeckbundleuriasbabel");
        System.out.println("      [BundleURI babel: n܂Ă邱ƂmF邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[true]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoNLpackGeneratorTranslationFragmentToPleiadesProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
    }
}
