package blanco.plugin.logmessage.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import blanco.doclisting.BlancoDocListingXml2CombinedXmlCsv;
import blanco.logmessage.BlancoLogMessageConstants;
import blanco.logmessage.BlancoLogMessageMeta2Xml;
import blanco.logmessage.BlancoLogMessageXml2SourceFile;
import blanco.logmessage.resourcebundle.BlancoLogMessageResourceBundle;
import blanco.plugin.logmessage.BlancoLogMessagePlugin;
import blanco.plugin.logmessage.BlancoLogMessagePluginConstants;
import blanco.plugin.logmessage.editors.BlancoLogMessagePluginUtil;

public class BlancoLogMessageGenerateAction {
    private static final BlancoLogMessageResourceBundle fBundle = new BlancoLogMessageResourceBundle();

    /**
     * \[XR[hs܂B
     * 
     * @param ifile
     *            Ώۂ̃t@CB
     * @param shell
     *            ẽVFB
     * @param workbenchMonitor
     *            [Nx`j^B
     * @param targetLang
     *            o͑ΏۃvO~OB
     * @param metaDir
     *            ^fBNgB
     * @throws InvocationTargetException
     *             s̗OB
     * @throws InterruptedException
     *             荞ݗOB
     */
    public static final void processBlancoMessageSource(final IFile ifile,
            final Shell shell, IProgressMonitor workbenchMonitor,
            final String targetLang, final String metaDir)
            throws InvocationTargetException, InterruptedException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        // Eclipse 3.3 ΍: begin
        // workbenchMonitor𗘗p邱Ƃ~܂B
        // org.eclipse.swt.SWTException: Invalid thread access Ă܂܂B
        // Eclipse 3.3 ΍: end

        try {
            // PlatformUI.getWorkbench().getProgressService()LvƔfB
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(final IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor.beginTask(
                                        BlancoLogMessageConstants.PRODUCT_NAME
                                                + "\[XR[h", 10);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("fBNg: e|tH_̒B");

                                // e|tH_U폜܂B
                                BlancoLogMessagePluginUtil
                                        .deleteFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoLogMessageConstants.TARGET_SUBDIRECTORY);
                                BlancoLogMessagePluginUtil
                                        .createFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoLogMessageConstants.TARGET_SUBDIRECTORY);
                                final IFolder tempFolder = BlancoLogMessagePluginUtil
                                        .findFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoLogMessageConstants.TARGET_SUBDIRECTORY);

                                // hLgꗗ̂߂̒ԃt@CpfBNgB
                                final File blancoTempDirectoryDocListing = ifile
                                        .getProject().getFolder(
                                                "tmp/doclisting").getLocation()
                                        .toFile();
                                blancoTempDirectoryDocListing.mkdirs();

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask(fBundle
                                        .getMetafileDisplayname()
                                        + " (*.xls)܂");
                                monitor.worked(1);

                                final IFolder findFolder = BlancoLogMessagePluginUtil
                                        .findFolder(ifile, monitor, metaDir);
                                findFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                new BlancoLogMessageMeta2Xml() {
                                    protected boolean progress(
                                            final int progressCurrent,
                                            final int progressTotal,
                                            final String progressItem) {
                                        if (monitor.isCanceled()) {
                                            // f܂B
                                            return false;
                                        }

                                        monitor.subTask("^t@C: t@C["
                                                + progressItem + "]܂ ("
                                                + progressCurrent + "/"
                                                + progressTotal + ")");

                                        if (BlancoLogMessagePluginConstants.IS_DEBUG) {
                                            try {
                                                Thread.sleep(10000);
                                            } catch (InterruptedException e) {
                                                e.printStackTrace();
                                            }
                                        }

                                        return true;
                                    }
                                }.processDirectory(findFolder.getLocation()
                                        .toFile(), tempFolder.getLocation()
                                        .toFile().getAbsolutePath());

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: tmptH_");
                                monitor.worked(1);

                                tempFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                String targetRootFolderName = "blanco";
                                if (targetLang.equals("java") == false) {
                                    targetRootFolderName += "." + targetLang;
                                }

                                monitor.subTask("tH_쐬: "
                                        + targetRootFolderName + "tH_");

                                IFolder folderTargetDirectory = ifile
                                        .getProject().getFolder(
                                                targetRootFolderName);
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectory.create(true, true,
                                            monitor);
                                }

                                monitor.subTask("tH_쐬: "
                                        + targetRootFolderName + "/maintH_");
                                final IFolder folderTargetDirectoryWithMain = folderTargetDirectory
                                        .getFolder("main");
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectoryWithMain.create(true,
                                            true, monitor);
                                }

                                File blancoTargetDirectory = folderTargetDirectory
                                        .getLocation().toFile();

                                monitor.subTask(targetLang + "\[XR[h쐬");
                                monitor.worked(1);

                                IResource[] resourcesXml2 = tempFolder
                                        .members();
                                for (int index = 0; index < resourcesXml2.length; index++) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    if (resourcesXml2[index] instanceof IFile) {
                                        IFile fileLook = (IFile) resourcesXml2[index];
                                        if (fileLook.getFileExtension().equals(
                                                "xml") == false) {
                                            // gqxmlȊÕt@C̓XLbv܂B
                                            continue;
                                        }

                                        monitor.subTask(targetLang
                                                + "\[XR[h쐬: t@C["
                                                + fileLook.getName()
                                                + "]܂ (" + (index + 1)
                                                + "/" + resourcesXml2.length
                                                + ")");

                                        try {
                                            new BlancoLogMessageXml2SourceFile()
                                                    .process(fileLook
                                                            .getLocation()
                                                            .toFile(),
                                                            targetLang,
                                                            blancoTargetDirectory);
                                        } catch (IllegalArgumentException ex) {
                                            throw new IllegalArgumentException(

                                                    "t@C["
                                                            + fileLook
                                                                    .getName()
                                                            + "]̏ɃG[܂B𒆒f܂B\n\n"
                                                            + ex.toString());
                                        }

                                        if (BlancoLogMessagePluginConstants.IS_DEBUG) {
                                            Thread.sleep(1000);
                                        }

                                    }
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("hLgꗗ̂߂̒ԃt@C쐬B");
                                monitor.worked(1);

                                // hLgꗗ̂߂̒ԃt@C쐬B
                                final BlancoDocListingXml2CombinedXmlCsv doclistingCsv = new BlancoDocListingXml2CombinedXmlCsv();
                                doclistingCsv.process(tempFolder.getLocation()
                                        .toFile(),
                                        blancoTempDirectoryDocListing);

                                monitor.subTask("tH_XV: "
                                        + targetRootFolderName + "tH_XV");
                                monitor.worked(1);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                folderTargetDirectory.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                if (BlancoLogMessagePluginConstants.IS_DEBUG) {
                                    Thread.sleep(1000);
                                }
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                // Ō̍Ōł doneƂ܂B
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoLogMessagePlugin.log(ex);
            // O̒{̌oƂ|CgłB
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n" + ex.getCause().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            BlancoLogMessagePlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            BlancoLogMessagePlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Error er) {
            BlancoLogMessagePlugin.log(er);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʃG[܂B𒆒f܂B\n" + er.toString());
            er.printStackTrace();
        }
    }
}