/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;

import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoFileUtil;
import blanco.commons.util.BlancoStringUtil;

/**
 * VB.NET X^C̒ۃgXtH[}[łB
 * 
 * @author IGA Tosiki
 */
public abstract class AbstractBlancoCgVbStyleTransformer extends
        AbstractBlancoCgTransformer {
    /**
     * fobO[hœ삳邩ǂB
     */
    private static final boolean IS_DEBUG = false;

    /**
     * \[Xt@CEo[IuWFNgJava\[XR[hɕϊďo͐fBNgɏo͂܂B
     * 
     * APIł̓pbP[W\fBNg\Ƃčl܂B
     * 
     * @param argSourceFile
     *            \[Xt@CEo[IuWFNgB
     * @param outputDirectory
     *            o͐惋[gfBNgB
     */
    public void transform(final BlancoCgSourceFile argSourceFile,
            final File outputDirectory) {
        if (argSourceFile == null) {
            throw new IllegalArgumentException("\[Xt@Cnull^܂Bf܂B");
        }
        if (outputDirectory == null) {
            throw new IllegalArgumentException(
                    "o͐惋[gfBNgnull^܂Bf܂B");
        }

        if (outputDirectory.exists() == false) {
            if (outputDirectory.mkdirs() == false) {
                throw new IllegalArgumentException("o͐惋[gfBNg["
                        + outputDirectory.getAbsolutePath()
                        + "]݂Ȃ̂ō쐬悤Ƃ܂fBNg쐬Ɏs܂Bf܂B");
            }
        }
        if (outputDirectory.isDirectory() == false) {
            throw new IllegalArgumentException("o͐惋[gfBNgɃfBNgł͂Ȃt@C["
                    + outputDirectory.getAbsolutePath() + "]^܂Bf܂B");
        }

        if (argSourceFile.getName() == null) {
            // t@Cm肵ĂȂ̂ŁANX܂̓C^tF[X瓱o܂B
            decideFilenameFromClassOrInterfaceName(argSourceFile);
        }

        try {
            // pbP[WfBNgւƕϊB
            String strSubdirectory = BlancoStringUtil.replaceAll(
                    BlancoStringUtil.null2Blank(argSourceFile.getPackage()),
                    '.', '/');
            if (strSubdirectory.length() > 0) {
                // TufBNg݂ꍇɂ̂݃XbVǉ܂B
                strSubdirectory = "/" + strSubdirectory;
            }

            final File targetPackageDirectory = new File(outputDirectory
                    .getAbsolutePath()
                    + strSubdirectory);
            if (targetPackageDirectory.exists() == false) {
                if (targetPackageDirectory.mkdirs() == false) {
                    throw new IllegalArgumentException("o͐̃pbP[WfBNg["
                            + targetPackageDirectory.getAbsolutePath()
                            + "]̐Ɏs܂B");
                }
            }

            // o͐̃t@Cm肵܂B
            final File fileTarget = new File(targetPackageDirectory
                    .getAbsolutePath()
                    + "/" + argSourceFile.getName() + getSourceFileExt());

            // ۂ̃\[XR[ho͏s܂B
            final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            // TODO \[XR[h̃GR[fBOw@\B
            final BufferedWriter writer = new BufferedWriter(
                    new OutputStreamWriter(outStream));
            try {
                transform(argSourceFile, writer);
                writer.flush();
                outStream.flush();

                switch (BlancoFileUtil.bytes2FileIfNecessary(outStream
                        .toByteArray(), fileTarget)) {
                case 0:
                    if (IS_DEBUG) {
                        // fobÔ݃XLbvWóB
                        System.out.println(CMDLINE_PREFIX + "skip  : "
                                + fileTarget.getAbsolutePath());
                    }
                    break;
                case 1:
                    System.out.println(CMDLINE_PREFIX + "create: "
                            + fileTarget.getAbsolutePath());
                    break;
                case 2:
                    System.out.println(CMDLINE_PREFIX + "update: "
                            + fileTarget.getAbsolutePath());
                    break;
                }
            } finally {
                // ByteArrayOutputStream̃CX^X writer̃N[Yɂ
                // Xg[`FC̎dgݏ IɃN[Y܂B

                if (writer != null) {
                    writer.close();
                }
            }
        } catch (IOException ex) {
            throw new IllegalArgumentException("\[XR[ho͂ߒŗO܂B"
                    + ex.toString());
        }
    }

    /**
     * \[XR[h̃Xg𐮌`܂B
     * 
     * Java  C#.NETp̐`s܂B
     * 
     * _ł̃\[X`[` Java/C#.NETʂƍl邱ƂłƔf܂B<br>
     * ȂȀ̂Ȃ {  } ͓ʂȈӖĂ܂BsRgȂǂƊ҂铮삪ł܂B<br>
     * TODO JbR𕶖ɕt^AȂǂ̃tH[}bgȂǂ͖łB
     * 
     * @param argSourceLines
     *            \[XR[hsXgB
     */
    protected void formatSource(final List<java.lang.String> argSourceLines) {
        int sourceIndent = 0;
        for (int index = 0; index < argSourceLines.size(); index++) {
            String strLine = argSourceLines.get(index);
            // Ő󔒂́A炩ߏ܂B
            strLine = strLine.trim();
            if (strLine.length() == 0) {
                // słB
            } else {
                boolean isBeginIndent = false;
                boolean isEndIndent = false;

                // ܂͊Jn̔s܂B
                // JnƏIƂ͕ʌɔ肷Kv܂B
                if (strLine.startsWith("If ")) {
                    // ubNJnƌȂĎ\񂵂܂B
                    isBeginIndent = true;
                } else if (strLine.startsWith("For ")) {
                    // ubNJnƌȂĎ\񂵂܂B
                    isBeginIndent = true;
                } else if (strLine.startsWith("End ")) {
                    // ubNIƌȂĎ܂B
                    isEndIndent = true;
                } else if (strLine.startsWith("Else ")) {
                    // ubNIƌȂĎ܂B
                    isEndIndent = true;
                } else if (strLine.equals("Next")
                        || strLine.startsWith("Next ")) {
                    // ubNIƌȂĎ܂B
                    isEndIndent = true;
                } else if (strLine.indexOf("Namespace ") >= 0
                        || strLine.indexOf("Class ") >= 0
                        || strLine.indexOf("Interface ") >= 0
                        || strLine.indexOf("Sub ") >= 0
                        || strLine.indexOf("Function ") >= 0) {
                    // EndŔ肵Ă̂|CgłB
                    // ubNJnƌȂĎ\񂵂܂B
                    isBeginIndent = true;
                }

                // rɋ܂ł낤If𔻒肵܂B
                if (strLine.indexOf(" If ") >= 0) {
                    // ubNJnƌȂĎ\񂵂܂B
                    isBeginIndent = true;
                }

                if (isEndIndent) {
                    // tOɂACfg𔽉f܂B
                    sourceIndent--;
                }

                // Cfg{܂B
                for (int indexIndent = 0; indexIndent < sourceIndent; indexIndent++) {
                    // 4^uŎ܂B
                    strLine = "    " + strLine;
                }
                if (isBeginIndent) {
                    sourceIndent++;
                }

                // XV̍sC[WŃXgXV܂B
                argSourceLines.set(index, strLine);
            }
        }
    }
}
