package blanco.xml.bind;

import java.util.List;

import org.xml.sax.Attributes;

import blanco.commons.util.BlancoStringUtil;
import blanco.xml.bind.valueobject.BlancoXmlAttribute;

/**
 * Agr[głB
 * 
 * ̃NX XML/o[IuWFNg}bsO (X/O}bsO) blancoXmlBinding ̈ꕔłB<br>
 * ̃NX̓pbP[Wł̂ݗp\łB
 * 
 * @author IGA Tosiki
 */
class BlancoXmlMarshallerAttributesImpl implements Attributes {
    /**
     * ۂ̃Agr[g̃XgB
     */
    private List<BlancoXmlAttribute> fAttrs = null;

    /**
     * Agr[g̃CX^X𐶐܂B
     * 
     * @param attrs
     *            Agr[g̃XgB
     */
    public BlancoXmlMarshallerAttributesImpl(
            final List<BlancoXmlAttribute> attrs) {
        if (attrs == null) {
            throw new IllegalArgumentException(
                    "BlancoXmlMarshallerAttributesImpl̃RXgN^null̈^܂B");
        }

        fAttrs = attrs;
    }

    /**
     * Xgɂ鑮̐Ԃ܂B
     * 
     * @return ̐B
     */
    public int getLength() {
        return fAttrs.size();
    }

    /**
     * ̖OURI ܂B
     * 
     * @param index
     *            CfBbNXB
     * @return OURIB
     */
    public String getURI(int index) {
        final BlancoXmlAttribute attribute = getAttr(index);
        if (attribute == null) {
            return null;
        }

        return attribute.getUri();
    }

    /**
     * ̃[J܂B
     * 
     * @param index
     *            CfBbNXB
     * @return [JB
     */
    public String getLocalName(int index) {
        final BlancoXmlAttribute attribute = getAttr(index);
        if (attribute == null) {
            return null;
        }

        return attribute.getLocalName();
    }

    /**
     *  XML 1.0 C܂B
     * 
     * @param index
     *            CfBbNXB
     * @return CB
     */
    public String getQName(int index) {
        final BlancoXmlAttribute attribute = getAttr(index);
        if (attribute == null) {
            return null;
        }

        final String qName = BlancoStringUtil.null2Blank(attribute.getQName());
        if (qName.length() == 0) {
            // qNameɒlw肳ĂȂꍇɂlocalName߂܂B
            return getLocalName(index);
        }

        return attribute.getQName();
    }

    /**
     * ̌^܂B
     * 
     * @param index
     *            CfBbNXB
     * @return ̌^B
     */
    public String getType(int index) {
        final BlancoXmlAttribute attribute = getAttr(index);
        if (attribute == null) {
            return null;
        }

        return attribute.getType();
    }

    /**
     * ̒l܂B
     * 
     * @param index
     *            CfBbNXB
     * @return ̒lB
     */
    public String getValue(int index) {
        final BlancoXmlAttribute attribute = getAttr(index);
        if (attribute == null) {
            return null;
        }

        return attribute.getValue();
    }

    /**
     * ̃CfbNX܂B
     * 
     * @param uri
     *            OURIB
     * @param localName
     *            [JB
     * @return CfbNXBXgɊY鑮݂Ȃꍇ -1B
     */
    public int getIndex(final String uri, final String localName) {
        final int attrSize = fAttrs.size();
        for (int index = 0; index < attrSize; index++) {
            final BlancoXmlAttribute attrLook = (BlancoXmlAttribute) fAttrs
                    .get(index);
            if (BlancoStringUtil.null2Blank(attrLook.getUri()).equals(uri)
                    && BlancoStringUtil.null2Blank(attrLook.getLocalName())
                            .equals(localName)) {
                return index;
            }
        }

        // ł܂łB
        return -1;
    }

    /**
     * ̃CfbNX܂B
     * 
     * @param qName
     *            CB
     * @return CfbNXBXgɊY鑮݂Ȃꍇ -1B
     */
    public int getIndex(final String qName) {
        final int attrSize = fAttrs.size();
        for (int index = 0; index < attrSize; index++) {
            final BlancoXmlAttribute attrLook = (BlancoXmlAttribute) fAttrs
                    .get(index);
            if (BlancoStringUtil.null2Blank(attrLook.getQName()).equals(qName)) {
                return index;
            }
        }

        // ł܂łB
        return -1;
    }

    /**
     * ̌^܂B
     * 
     * @param uri
     *            OURIB
     * @param localName
     *            [JB
     * @return ̌^B
     */
    public String getType(final String uri, final String localName) {
        final BlancoXmlAttribute attrFound = findByUriLocalName(uri, localName);
        if (attrFound == null) {
            // ł܂łB
            return null;
        }

        return attrFound.getType();
    }

    /**
     * ̌^܂B
     * 
     * @param qName
     *            CB
     * @return ̌^B
     */
    public String getType(final String qName) {
        final BlancoXmlAttribute attrFound = findByQName(qName);
        if (attrFound == null) {
            // ł܂łB
            return null;
        }

        return attrFound.getType();
    }

    /**
     * ̒l܂B
     * 
     * @param uri
     *            OURIB
     * @param localName
     *            [JB
     * @return ̒lB
     */
    public String getValue(final String uri, final String localName) {
        final BlancoXmlAttribute attrFound = findByUriLocalName(uri, localName);
        if (attrFound == null) {
            // ł܂łB
            return null;
        }

        return attrFound.getValue();
    }

    /**
     * ̒l܂B
     * 
     * @param qName
     *            CB
     * @return ̒lB
     */
    public String getValue(final String qName) {
        final BlancoXmlAttribute attrFound = findByQName(qName);
        if (attrFound == null) {
            // ł܂łB
            return null;
        }

        return attrFound.getValue();
    }

    /**
     * w̃CfBbNXɂ鑮擾܂B
     * 
     * @param index
     *            CfBbNXB
     * @return Bwindex͈͊ȌꍇnullB
     */
    private BlancoXmlAttribute getAttr(int index) {
        if (index >= fAttrs.size()) {
            return null;
        }

        return (BlancoXmlAttribute) fAttrs.get(index);
    }

    /**
     * OURIƃ[Jpđ܂B
     * 
     * @param uri
     *            OURIB
     * @param localName
     *            [JB
     * @return B
     */
    private BlancoXmlAttribute findByUriLocalName(final String uri,
            final String localName) {
        final int attrSize = fAttrs.size();
        for (int index = 0; index < attrSize; index++) {
            final BlancoXmlAttribute attrLook = (BlancoXmlAttribute) fAttrs
                    .get(index);
            if (BlancoStringUtil.null2Blank(attrLook.getUri()).equals(uri)
                    && BlancoStringUtil.null2Blank(attrLook.getLocalName())
                            .equals(localName)) {
                return attrLook;
            }
        }

        // ł܂łB
        return null;
    }

    /**
     * Cpđ܂B
     * 
     * @param qName
     *            CB
     * @return B
     */
    private BlancoXmlAttribute findByQName(final String qName) {
        final int attrSize = fAttrs.size();
        for (int index = 0; index < attrSize; index++) {
            final BlancoXmlAttribute attrLook = (BlancoXmlAttribute) fAttrs
                    .get(index);
            if (BlancoStringUtil.null2Blank(attrLook.getUri()).equals(qName)) {
                return attrLook;
            }
        }

        // ł܂łB
        return null;
    }
}
