/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg;

import java.io.File;

import junit.framework.TestCase;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgEnum;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgInterface;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;

/**
 * Javap̐B
 * 
 * @author IGA Tosiki
 */
public class BlancoCgTransformerTest extends TestCase {
    /**
     * NX̓WJB
     * 
     * @throws Exception
     */
    public void testTransformer() throws Exception {
        final BlancoCgObjectFactory cgFactory = BlancoCgObjectFactory
                .getInstance();

        // \[Xt@C𐶐܂B
        final BlancoCgSourceFile cgSourceFile = cgFactory.createSourceFile(
                "myprog", "eXgp̃NX");
        cgSourceFile.getImportList().add("java.text.NumberFormat");
        // pbP[W̃C|[gB
        cgSourceFile.getImportList().add("myprog.MyClass2");

        // NX𐶐܂B
        final BlancoCgClass cgClass = cgFactory.createClass("MyClass",
                "̃NX́AeXĝ߂̃NXłB");
        cgSourceFile.getClassList().add(cgClass);
        cgClass.getLangDoc().getTagList().add(
                cgFactory.createLangDocTag("author", null, "blanco Framework"));
        cgClass.getExtendClassList().add(
                cgFactory.createType("java.lang.Thread"));
        cgClass.getImplementInterfaceList().add(
                cgFactory.createType("java.lang.Runnable"));

        // 񋓑
        final BlancoCgEnum cgEnum = cgFactory.createEnum("FavorColor",
                "񋓑̂̎B");
        cgClass.getEnumList().add(cgEnum);
        cgEnum.getElementList().add(cgFactory.createEnumElement("Red", ""));
        cgEnum.getElementList().add(
                cgFactory.createEnumElement("Yerrow", ""));
        cgEnum.getElementList().add(cgFactory.createEnumElement("Blue", ""));

        // tB[h𐶐܂B
        final BlancoCgField cgField = cgFactory.createField("myField",
                "java.util.Date", "ttB[h̎łB");
        cgClass.getFieldList().add(cgField);
        cgField.setDefault("new Date()");

        final BlancoCgField cgField2 = cgFactory.createField("myField2",
                "java.util.Date", "ttB[h̎v2łB");
        cgClass.getFieldList().add(cgField2);
        cgField2.getType().setArray(true);
        cgField2.getType().setArrayDimension(2);

        // \bh𐶐܂B
        final BlancoCgMethod cgMethod = cgFactory.createMethod("myMethod",
                "\bh̎łB");
        cgClass.getMethodList().add(cgMethod);

        // p[^ǉ܂B
        cgMethod.getParameterList().add(
                cgFactory.createParameter("argString", "java.lang.String",
                        "B"));
        cgMethod.getParameterList()
                .add(
                        cgFactory.createParameter("argDate", "java.util.Date",
                                "tB"));
        // ߂lݒ肵܂B
        cgMethod.setReturn(cgFactory.createReturn("boolean", "ȂtrueB"));

        cgMethod.getThrowList().add(
                cgFactory.createException("java.io.IOException",
                        "o͗OꍇB"));

        // Ame[V̒ǉB
        cgMethod.getAnnotationList().add(
                "Copyright(value=\"blanco Framework\")");
        cgMethod.setOverride(true);

        // \bh̓eǉ܂B
        cgMethod.getLineList().add("// ̎łB");
        cgMethod.getLineList().add("int a = 0;");

        final BlancoCgTransformer cgTransformerJava = BlancoCgTransformerFactory
                .getJavaSourceTransformer();
        cgTransformerJava.transform(cgSourceFile, new File("./tmp/blanco"));
    }

    /**
     * C^tF[X̓WJB
     * 
     * @throws Exception
     */
    public void testTransformerInterface() throws Exception {
        final BlancoCgObjectFactory cgOf = BlancoCgObjectFactory.getInstance();

        // \[Xt@C𐶐܂B
        final BlancoCgSourceFile cgSourceFile = cgOf.createSourceFile("myprog",
                "eXgp̃C^tF[X");
        cgSourceFile.getImportList().add("java.text.NumberFormat");

        // NX𐶐܂B
        final BlancoCgInterface cgInterface = cgOf.createInterface(
                "MyInterface", "̃C^tF[X́AeXĝ߂̃C^tF[XłB");
        cgSourceFile.getInterfaceList().add(cgInterface);
        cgInterface.getLangDoc().getTagList().add(
                cgOf.createLangDocTag("author", null, "blanco Framework"));
        cgInterface.getExtendClassList().add(
                cgOf.createType("java.lang.Thread"));

        // tB[h𐶐܂B
        final BlancoCgField cgField = cgOf.createField("myField",
                "java.util.Date", "ttB[h̎łB");
        cgInterface.getFieldList().add(cgField);
        cgField.setDefault("new Date()");

        // \bh𐶐܂B
        final BlancoCgMethod cgMethod = cgOf.createMethod("myMethod",
                "\bh̎łB");
        cgInterface.getMethodList().add(cgMethod);

        // p[^ǉ܂B
        cgMethod.getParameterList()
                .add(
                        cgOf.createParameter("argString", "java.lang.String",
                                "B"));
        cgMethod.getParameterList().add(
                cgOf.createParameter("argDate", "java.util.Date", "tB"));
        // ߂lݒ肵܂B
        cgMethod.setReturn(cgOf.createReturn("boolean", "ȂtrueB"));

        cgMethod.getThrowList().add(
                cgOf.createException("java.io.IOException", "o͗OꍇB"));

        final BlancoCgTransformer cgTransformerJava = BlancoCgTransformerFactory
                .getJavaSourceTransformer();
        cgTransformerJava.transform(cgSourceFile, new File("./tmp/blanco"));
    }
}
