/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.myspell;

import java.util.HashMap;
import java.util.regex.Pattern;

public final class Conditions {
    private static HashMap<String, Conditions> readed = null;
    private static final Conditions EMPTY_CONDITIONS = new Conditions();
    private Pattern condition;

    private Conditions() {
    }

    private Conditions(String cs) {
        this.condition = Pattern.compile(cs);
    }

    public boolean match(String word) {
        if (this.condition != null) {
            return this.condition.matcher(word).matches();
        }
        return true;
    }

    public static void beginRead() {
        if (readed != null) {
            throw new IllegalStateException();
        }
        readed = new HashMap();
    }

    public static void endRead() {
        if (readed == null) {
            throw new IllegalStateException();
        }
        readed = null;
    }

    public static Conditions createFrom(String cs) {
        if (cs.equals(".")) {
            return EMPTY_CONDITIONS;
        }
        Conditions result = readed.get(cs);
        if (result == null) {
            result = new Conditions(cs);
            readed.put(cs, result);
        }
        return result;
    }
}

