/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.finder;

import org.dts.spell.finder.AbstractWordFinder;
import org.dts.spell.finder.Word;
import org.dts.spell.tokenizer.DefaultWordTokenizer;
import org.dts.spell.tokenizer.WordTokenizer;

public class CharSequenceWordFinder
extends AbstractWordFinder {
    private WordTokenizer tokenizer;

    public CharSequenceWordFinder(CharSequence text, WordTokenizer tokenizer) {
        tokenizer.setCharSequence(text);
        this.setTokenizer(tokenizer);
    }

    public CharSequenceWordFinder(CharSequence text) {
        this(text, new DefaultWordTokenizer());
    }

    protected Word next(Word currentWord) {
        Word word;
        if (currentWord == null) {
            boolean last = false;
            word = this.findFirstWord();
        } else {
            int last = currentWord.getEnd();
            word = this.getTokenizer().nextWord(last - 1);
        }
        return word;
    }

    protected void replace(String newWord, Word currentWord) {
        throw new UnsupportedOperationException();
    }

    public WordTokenizer getTokenizer() {
        return this.tokenizer;
    }

    protected void setTokenizer(WordTokenizer tokenizer) {
        if (this.getTokenizer() != tokenizer) {
            if (this.getTokenizer() != null) {
                tokenizer.setCharSequence(this.getTokenizer().getCharSequence());
            }
            this.tokenizer = tokenizer;
            this.init();
        }
    }

    protected void updateCharSequence(int start, int end, int cause) {
        this.getTokenizer().updateCharSequence(start, end, cause);
    }

    public CharSequence getCharSequence() {
        if (this.getTokenizer() != null) {
            return this.getTokenizer().getCharSequence();
        }
        return null;
    }

    protected Word findFirstWord() {
        Word result = this.getTokenizer().currentWord(0);
        if (result == null) {
            result = this.getTokenizer().nextWord(0);
        }
        return result;
    }
}

