/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.glossary;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.omegat.core.StringEntry;
import org.omegat.core.glossary.GlossaryEntry;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;

public class GlossaryManager {
    private final String EXT_DEF_ENC = ".tab";
    private final String EXT_UTF8_ENC = ".utf8";
    private List glossaryEntries = new ArrayList();

    public void loadGlossaryFiles(File file) throws IOException {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = file.getAbsolutePath() + File.separator + stringArray[i];
                String string2 = string.toLowerCase();
                if (!string2.endsWith(".tab") && !string2.endsWith(".utf8")) continue;
                Log.logRB("CT_LOADING_GLOSSARY", new Object[]{string});
                this.loadGlossaryFile(new File(string));
            }
        } else {
            throw new IOException(OStrings.getString("CT_ERROR_ACCESS_GLOSSARY_DIR"));
        }
    }

    private void loadGlossaryFile(File file) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        Closeable closeable;
        String string = file.getName().toLowerCase();
        InputStreamReader inputStreamReader = null;
        if (string.endsWith(".tab")) {
            inputStreamReader = new InputStreamReader(new FileInputStream(file));
        } else if (string.endsWith(".utf8")) {
            closeable = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)closeable, "UTF-8");
        }
        closeable = new BufferedReader(inputStreamReader);
        ((BufferedReader)closeable).mark(1);
        int n = ((BufferedReader)closeable).read();
        if (n != 65279) {
            ((BufferedReader)closeable).reset();
        }
        String string2 = ((BufferedReader)closeable).readLine();
        while (string2 != null) {
            String[] stringArray;
            if (!string2.startsWith("#") && (stringArray = string2.split("\t")).length >= 2 && stringArray[0].length() != 0) {
                String string3 = "";
                if (stringArray.length >= 3) {
                    string3 = stringArray[2];
                }
                GlossaryEntry glossaryEntry = new GlossaryEntry(stringArray[0], stringArray[1], string3);
                this.glossaryEntries.add(glossaryEntry);
            }
            string2 = ((BufferedReader)closeable).readLine();
        }
        ((BufferedReader)closeable).close();
    }

    public void buildGlossary(List list) {
        for (int i = 0; i < this.glossaryEntries.size(); ++i) {
            GlossaryEntry glossaryEntry = (GlossaryEntry)this.glossaryEntries.get(i);
            String string = glossaryEntry.getSrcText();
            List list2 = StaticUtils.tokenizeText(string);
            int n = list2.size();
            if (n == 0) continue;
            for (int j = 0; j < list.size(); ++j) {
                StringEntry stringEntry = (StringEntry)list.get(j);
                List list3 = stringEntry.getSrcTokenList();
                if (!list3.containsAll(list2)) continue;
                stringEntry.addGlossaryEntry(glossaryEntry);
            }
        }
    }
}

