/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching;

import java.util.List;
import org.omegat.core.StringEntry;
import org.omegat.core.matching.LevenshteinDistance;
import org.omegat.core.threads.CommandThread;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.messages.MessageRelay;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.Token;

public class FuzzyMatcher {
    private String statusTemplate;
    private MainWindow tf;
    private CommandThread core;

    private void updateStatus(int n, int n2) {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        MessageRelay.uiMessageSetMessageText(this.tf, StaticUtils.format(this.statusTemplate, objectArray));
        Thread.yield();
    }

    public FuzzyMatcher(MainWindow mainWindow, CommandThread commandThread) {
        this.tf = mainWindow;
        this.core = commandThread;
    }

    private byte[] buildSimilarityData(List list, List list2) {
        int n = list2.size();
        byte[] byArray = new byte[n];
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            byArray[i] = 0;
            Token token = null;
            if (i + 1 < n) {
                token = (Token)list2.get(i + 1);
            }
            boolean bl2 = i + 1 == n || list.contains(token);
            Token token2 = (Token)list2.get(i);
            boolean bl3 = list.contains(token2);
            if (!(!bl3 || bl && bl2)) {
                byArray[i] = 2;
            } else if (!bl3) {
                byArray[i] = 1;
            }
            bl = bl3;
        }
        return byArray;
    }

    public void match(List list) throws InterruptedException {
        int n = list.size();
        this.statusTemplate = OStrings.getString("CT_FUZZY_X_OF_Y");
        this.updateStatus(0, n);
        for (int i = 0; i < n; ++i) {
            StringEntry stringEntry;
            List list2;
            int n2;
            if (i % 20 == 0) {
                if (this.core.isInterrupted()) {
                    throw new InterruptedException("Stopping on demand");
                }
                this.updateStatus(i, n);
            }
            if ((n2 = (list2 = (stringEntry = (StringEntry)list.get(i)).getSrcTokenList()).size()) == 0) continue;
            List list3 = stringEntry.getSrcTokenListAll();
            for (int j = i + 1; j < n; ++j) {
                List list4;
                int n3;
                StringEntry stringEntry2 = (StringEntry)list.get(j);
                if (stringEntry2 == null || (n3 = (list4 = stringEntry2.getSrcTokenList()).size()) == 0) continue;
                int n4 = LevenshteinDistance.compute(list2, list4);
                int n5 = 100 * (Math.max(n2, n3) - n4) / Math.max(n2, n3);
                if (n5 < 30) continue;
                List list5 = stringEntry2.getSrcTokenListAll();
                int n6 = LevenshteinDistance.compute(list3, list5);
                int n7 = 100 * (Math.max(list3.size(), list5.size()) - n6) / Math.max(list3.size(), list5.size());
                byte[] byArray = this.buildSimilarityData(list3, list5);
                stringEntry.addNearString(stringEntry2, n5, n7, byArray, null);
                byArray = this.buildSimilarityData(list5, list3);
                stringEntry2.addNearString(stringEntry, n5, n7, byArray, null);
            }
        }
        this.updateStatus(n, n);
    }

    public void match(List list, String string, List list2) throws InterruptedException {
        int n = list2.size();
        int n2 = list.size();
        this.statusTemplate = OStrings.getString("CT_FUZZY_X_OF_Y") + " (" + string + ")";
        this.updateStatus(0, n);
        for (int i = 0; i < n; ++i) {
            StringEntry stringEntry;
            List list3;
            int n3;
            if (i % 20 == 0) {
                if (this.core.isInterrupted()) {
                    throw new InterruptedException("Stopping on demand");
                }
                this.updateStatus(i, n);
            }
            if ((n3 = (list3 = (stringEntry = (StringEntry)list2.get(i)).getSrcTokenList()).size()) == 0) continue;
            List list4 = stringEntry.getSrcTokenListAll();
            for (int j = 0; j < n2; ++j) {
                StringEntry stringEntry2 = (StringEntry)list.get(j);
                List list5 = stringEntry2.getSrcTokenList();
                int n4 = list5.size();
                if (n4 == 0) continue;
                int n5 = LevenshteinDistance.compute(list3, list5);
                int n6 = 100 * (Math.max(n3, n4) - n5) / Math.max(n3, n4);
                if (n6 < 30) continue;
                List list6 = stringEntry2.getSrcTokenListAll();
                int n7 = LevenshteinDistance.compute(list4, list6);
                int n8 = 100 * (Math.max(list4.size(), list6.size()) - n7) / Math.max(list4.size(), list6.size());
                byte[] byArray = this.buildSimilarityData(list6, list4);
                stringEntry2.addNearString(stringEntry, n6, n8, byArray, string);
            }
        }
        this.updateStatus(n, n);
    }
}

