/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.spellchecker;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import org.dts.spell.dictionary.OpenOfficeSpellDictionary;
import org.dts.spell.dictionary.SpellDictionary;
import org.omegat.core.spellchecker.Hunspell;
import org.omegat.core.threads.CommandThread;
import org.omegat.util.Log;
import org.omegat.util.Platform;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;

public class SpellChecker {
    private static SpellChecker INSTANCE = null;
    private Hunspell hunspell;
    private org.dts.spell.SpellChecker jmyspell;
    private ArrayList ignoreList = new ArrayList();
    private ArrayList learnedList = new ArrayList();
    private Pointer pHunspell = null;
    private String encoding;
    private String ignoreFileName;
    private String learnedFileName;

    public static SpellChecker getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new SpellChecker();
        return INSTANCE;
    }

    protected SpellChecker() {
        String string = StaticUtils.installDir() + File.separator + "native" + File.separator + SpellChecker.mapLibraryName("hunspell");
        try {
            this.hunspell = (Hunspell)Native.loadLibrary((String)string, (Class)Hunspell.class);
        }
        catch (Exception exception) {
            Log.log("Error loading hunspell: " + exception.getMessage());
        }
        catch (Error error) {
            Log.log("Error loading hunspell: " + error.getMessage());
        }
    }

    public void initialize() {
        String string = CommandThread.core.getProjectProperties().getTargetLanguage().getLocaleCode();
        String string2 = Preferences.getPreference("spellcheker_dir");
        if (string2 != null) {
            Object object;
            String string3 = string2 + File.separator + string + ".aff";
            String string4 = string2 + File.separator + string + ".dic";
            if (this.hunspell != null) {
                this.pHunspell = this.hunspell.Hunspell_create(string3, string4);
                this.encoding = this.hunspell.Hunspell_get_dic_encoding(this.pHunspell);
            } else {
                try {
                    object = new OpenOfficeSpellDictionary(new File(string4), new File(string3), false);
                    this.jmyspell = new org.dts.spell.SpellChecker((SpellDictionary)object);
                    this.jmyspell.setCaseSensitive(false);
                }
                catch (Exception exception) {
                    Log.log("Error loading jmyspell: " + exception.getMessage());
                    return;
                }
            }
            object = CommandThread.core.getProjectProperties().getProjectInternal();
            this.ignoreFileName = (String)object + "ignored_words.txt";
            this.fillWordList(this.ignoreFileName, this.ignoreList);
            this.learnedFileName = (String)object + "learned_words.txt";
            this.fillWordList(this.learnedFileName, this.learnedList);
            if (this.hunspell != null) {
                try {
                    for (int i = 0; i < this.learnedList.size(); ++i) {
                        this.hunspell.Hunspell_put_word(this.pHunspell, this.prepareString((String)this.learnedList.get(i)));
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Log.log("Unsupported encoding " + this.encoding);
                }
            }
        }
    }

    public void destroy() {
        if (this.pHunspell != null) {
            this.hunspell.Hunspell_destroy(this.pHunspell);
            this.dumpWordList(this.ignoreList, this.ignoreFileName);
            this.dumpWordList(this.learnedList, this.learnedFileName);
            this.pHunspell = null;
        }
        if (this.jmyspell != null) {
            this.jmyspell = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void fillWordList(String string, ArrayList arrayList) {
        block15: {
            String string2;
            arrayList = new ArrayList<String>();
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(string2);
            }
            Object var6_7 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block15;
            }
            catch (IOException iOException) {}
            break block15;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    Object var6_8 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
                catch (IOException iOException) {
                    Object var6_9 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dumpWordList(ArrayList arrayList, String string) {
        block12: {
            BufferedWriter bufferedWriter = null;
            bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
            Object var7_7 = null;
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                break block12;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block12;
            {
                catch (IOException iOException) {
                    Object var7_8 = null;
                    try {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                        break block12;
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public boolean isCorrect(String string) {
        if (this.learnedList.contains(string) || this.ignoreList.contains(string)) {
            return true;
        }
        if (this.hunspell != null) {
            try {
                if (0 != this.hunspell.Hunspell_spell(this.pHunspell, this.prepareString(string))) {
                    return true;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.log("Unsupported encoding " + this.encoding);
            }
            return false;
        }
        if (this.jmyspell != null) {
            return this.jmyspell.isCorrect((CharSequence)string);
        }
        return false;
    }

    public ArrayList suggest(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isCorrect(string)) {
            return arrayList;
        }
        if (this.hunspell != null) {
            PointerByReference pointerByReference = new PointerByReference();
            String[] stringArray = new String[100];
            int n = 0;
            try {
                n = this.hunspell.Hunspell_suggest(this.pHunspell, pointerByReference, this.prepareString(string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.log("Unsupported encoding " + this.encoding);
            }
            Pointer pointer = pointerByReference.getValue();
            Pointer[] pointerArray = pointer.getPointerArray(0, n);
            Charset charset = Charset.forName(this.encoding);
            CharsetDecoder charsetDecoder = charset.newDecoder();
            for (int i = 0; i < n; ++i) {
                try {
                    byte by;
                    byte[] byArray = new byte[100];
                    for (int j = 0; j < 100 && (by = pointerArray[i].getByte(j)) != 0; ++j) {
                        byArray[j] = by;
                    }
                    CharBuffer charBuffer = charsetDecoder.decode(ByteBuffer.wrap(byArray));
                    arrayList.add(charBuffer.toString().trim());
                    continue;
                }
                catch (CharacterCodingException characterCodingException) {
                    Log.log("Unsupported encoding " + this.encoding);
                }
            }
        } else if (this.jmyspell != null) {
            arrayList.addAll(this.jmyspell.getDictionary().getSuggestions(string, 20));
        }
        return arrayList;
    }

    public void ignoreWord(String string) {
        if (!this.ignoreList.contains(string)) {
            this.ignoreList.add(string);
        }
    }

    public void learnWord(String string) {
        if (!this.learnedList.contains(string)) {
            this.learnedList.add(string);
            if (this.hunspell != null) {
                try {
                    this.hunspell.Hunspell_put_word(this.pHunspell, this.prepareString(string));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Log.log("Unsupported encoding " + this.encoding);
                }
            }
        }
    }

    protected byte[] prepareString(String string) throws UnsupportedEncodingException {
        return (string + "\u0000").getBytes(this.encoding);
    }

    private static String mapLibraryName(String string) {
        if (Platform.isMac()) {
            if (string.matches("lib.*\\.(dylib|jnilib)$")) {
                return string;
            }
            String string2 = System.mapLibraryName(string);
            if (string2.endsWith(".jnilib")) {
                return string2.substring(0, string2.lastIndexOf(".jnilib")) + ".dylib";
            }
            return string2;
        }
        if (Platform.isLinux() && string.matches("lib.*\\.so\\.[0-9]+$")) {
            return string;
        }
        return System.mapLibraryName(string);
    }
}

