/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.html2;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import org.htmlparser.Node;
import org.htmlparser.Remark;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.visitors.NodeVisitor;
import org.omegat.filters2.html2.HTMLFilter2;
import org.omegat.filters2.html2.HTMLOptions;
import org.omegat.util.PatternConsts;
import org.omegat.util.StaticUtils;

public class FilterVisitor
extends NodeVisitor {
    private HTMLFilter2 filter;
    private BufferedWriter writer;
    private HTMLOptions options;
    boolean recurse = true;
    boolean text = false;
    boolean preformatting = false;
    ArrayList befors;
    ArrayList translatable;
    ArrayList afters;
    ArrayList s_tags;
    ArrayList s_tag_numbers;
    ArrayList s_shortcuts;
    int s_nshortcuts;
    boolean firstcall = true;
    private static final Object[][] ENTITIES = new Object[][]{{"quot", new Integer(34)}, {"amp", new Integer(38)}, {"lt", new Integer(60)}, {"gt", new Integer(62)}, {"OElig", new Integer(338)}, {"oelig", new Integer(339)}, {"Scaron", new Integer(352)}, {"scaron", new Integer(353)}, {"Yuml", new Integer(376)}, {"circ", new Integer(710)}, {"tilde", new Integer(732)}, {"ensp", new Integer(8194)}, {"emsp", new Integer(8195)}, {"thinsp", new Integer(8201)}, {"zwnj", new Integer(8204)}, {"zwj", new Integer(8205)}, {"lrm", new Integer(8206)}, {"rlm", new Integer(8207)}, {"ndash", new Integer(8211)}, {"mdash", new Integer(8212)}, {"lsquo", new Integer(8216)}, {"rsquo", new Integer(8217)}, {"sbquo", new Integer(8218)}, {"ldquo", new Integer(8220)}, {"rdquo", new Integer(8221)}, {"bdquo", new Integer(8222)}, {"dagger", new Integer(8224)}, {"Dagger", new Integer(8225)}, {"permil", new Integer(8240)}, {"lsaquo", new Integer(8249)}, {"rsaquo", new Integer(8250)}, {"euro", new Integer(8364)}, {"nbsp", new Integer(160)}, {"iexcl", new Integer(161)}, {"cent", new Integer(162)}, {"pound", new Integer(163)}, {"curren", new Integer(164)}, {"yen", new Integer(165)}, {"brvbar", new Integer(166)}, {"sect", new Integer(167)}, {"uml", new Integer(168)}, {"copy", new Integer(169)}, {"ordf", new Integer(170)}, {"laquo", new Integer(171)}, {"not", new Integer(172)}, {"shy", new Integer(173)}, {"reg", new Integer(174)}, {"macr", new Integer(175)}, {"deg", new Integer(176)}, {"plusmn", new Integer(177)}, {"sup2", new Integer(178)}, {"sup3", new Integer(179)}, {"acute", new Integer(180)}, {"micro", new Integer(181)}, {"para", new Integer(182)}, {"middot", new Integer(183)}, {"cedil", new Integer(184)}, {"sup1", new Integer(185)}, {"ordm", new Integer(186)}, {"raquo", new Integer(187)}, {"frac14", new Integer(188)}, {"frac12", new Integer(189)}, {"frac34", new Integer(190)}, {"iquest", new Integer(191)}, {"Agrave", new Integer(192)}, {"Aacute", new Integer(193)}, {"Acirc", new Integer(194)}, {"Atilde", new Integer(195)}, {"Auml", new Integer(196)}, {"Aring", new Integer(197)}, {"AElig", new Integer(198)}, {"Ccedil", new Integer(199)}, {"Egrave", new Integer(200)}, {"Eacute", new Integer(201)}, {"Ecirc", new Integer(202)}, {"Euml", new Integer(203)}, {"Igrave", new Integer(204)}, {"Iacute", new Integer(205)}, {"Icirc", new Integer(206)}, {"Iuml", new Integer(207)}, {"ETH", new Integer(208)}, {"Ntilde", new Integer(209)}, {"Ograve", new Integer(210)}, {"Oacute", new Integer(211)}, {"Ocirc", new Integer(212)}, {"Otilde", new Integer(213)}, {"Ouml", new Integer(214)}, {"times", new Integer(215)}, {"Oslash", new Integer(216)}, {"Ugrave", new Integer(217)}, {"Uacute", new Integer(218)}, {"Ucirc", new Integer(219)}, {"Uuml", new Integer(220)}, {"Yacute", new Integer(221)}, {"THORN", new Integer(222)}, {"szlig", new Integer(223)}, {"agrave", new Integer(224)}, {"aacute", new Integer(225)}, {"acirc", new Integer(226)}, {"atilde", new Integer(227)}, {"auml", new Integer(228)}, {"aring", new Integer(229)}, {"aelig", new Integer(230)}, {"ccedil", new Integer(231)}, {"egrave", new Integer(232)}, {"eacute", new Integer(233)}, {"ecirc", new Integer(234)}, {"euml", new Integer(235)}, {"igrave", new Integer(236)}, {"iacute", new Integer(237)}, {"icirc", new Integer(238)}, {"iuml", new Integer(239)}, {"eth", new Integer(240)}, {"ntilde", new Integer(241)}, {"ograve", new Integer(242)}, {"oacute", new Integer(243)}, {"ocirc", new Integer(244)}, {"otilde", new Integer(245)}, {"ouml", new Integer(246)}, {"divide", new Integer(247)}, {"oslash", new Integer(248)}, {"ugrave", new Integer(249)}, {"uacute", new Integer(250)}, {"ucirc", new Integer(251)}, {"uuml", new Integer(252)}, {"yacute", new Integer(253)}, {"thorn", new Integer(254)}, {"yuml", new Integer(255)}, {"fnof", new Integer(402)}, {"Alpha", new Integer(913)}, {"Beta", new Integer(914)}, {"Gamma", new Integer(915)}, {"Delta", new Integer(916)}, {"Epsilon", new Integer(917)}, {"Zeta", new Integer(918)}, {"Eta", new Integer(919)}, {"Theta", new Integer(920)}, {"Iota", new Integer(921)}, {"Kappa", new Integer(922)}, {"Lambda", new Integer(923)}, {"Mu", new Integer(924)}, {"Nu", new Integer(925)}, {"Xi", new Integer(926)}, {"Omicron", new Integer(927)}, {"Pi", new Integer(928)}, {"Rho", new Integer(929)}, {"Sigma", new Integer(931)}, {"Tau", new Integer(932)}, {"Upsilon", new Integer(933)}, {"Phi", new Integer(934)}, {"Chi", new Integer(935)}, {"Psi", new Integer(936)}, {"Omega", new Integer(937)}, {"alpha", new Integer(945)}, {"beta", new Integer(946)}, {"gamma", new Integer(947)}, {"delta", new Integer(948)}, {"epsilon", new Integer(949)}, {"zeta", new Integer(950)}, {"eta", new Integer(951)}, {"theta", new Integer(952)}, {"iota", new Integer(953)}, {"kappa", new Integer(954)}, {"lambda", new Integer(955)}, {"mu", new Integer(956)}, {"nu", new Integer(957)}, {"xi", new Integer(958)}, {"omicron", new Integer(959)}, {"pi", new Integer(960)}, {"rho", new Integer(961)}, {"sigmaf", new Integer(962)}, {"sigma", new Integer(963)}, {"tau", new Integer(964)}, {"upsilon", new Integer(965)}, {"phi", new Integer(966)}, {"chi", new Integer(967)}, {"psi", new Integer(968)}, {"omega", new Integer(969)}, {"thetasym", new Integer(977)}, {"upsih", new Integer(978)}, {"piv", new Integer(982)}, {"bull", new Integer(8226)}, {"hellip", new Integer(8230)}, {"prime", new Integer(8242)}, {"Prime", new Integer(8243)}, {"oline", new Integer(8254)}, {"frasl", new Integer(8260)}, {"weierp", new Integer(8472)}, {"image", new Integer(8465)}, {"real", new Integer(8476)}, {"trade", new Integer(8482)}, {"alefsym", new Integer(8501)}, {"larr", new Integer(8592)}, {"uarr", new Integer(8593)}, {"rarr", new Integer(8594)}, {"darr", new Integer(8595)}, {"harr", new Integer(8596)}, {"crarr", new Integer(8629)}, {"lArr", new Integer(8656)}, {"uArr", new Integer(8657)}, {"rArr", new Integer(8658)}, {"dArr", new Integer(8659)}, {"hArr", new Integer(8660)}, {"forall", new Integer(8704)}, {"part", new Integer(8706)}, {"exist", new Integer(8707)}, {"empty", new Integer(8709)}, {"nabla", new Integer(8711)}, {"isin", new Integer(8712)}, {"notin", new Integer(8713)}, {"ni", new Integer(8715)}, {"prod", new Integer(8719)}, {"sum", new Integer(8722)}, {"minus", new Integer(8722)}, {"lowast", new Integer(8727)}, {"radic", new Integer(8730)}, {"prop", new Integer(8733)}, {"infin", new Integer(8734)}, {"ang", new Integer(8736)}, {"and", new Integer(8869)}, {"or", new Integer(8870)}, {"cap", new Integer(8745)}, {"cup", new Integer(8746)}, {"int", new Integer(8747)}, {"there4", new Integer(8756)}, {"sim", new Integer(8764)}, {"cong", new Integer(8773)}, {"asymp", new Integer(8773)}, {"ne", new Integer(8800)}, {"equiv", new Integer(8801)}, {"le", new Integer(8804)}, {"ge", new Integer(8805)}, {"sub", new Integer(8834)}, {"sup", new Integer(8835)}, {"nsub", new Integer(8836)}, {"sube", new Integer(8838)}, {"supe", new Integer(8839)}, {"oplus", new Integer(8853)}, {"otimes", new Integer(8855)}, {"perp", new Integer(8869)}, {"sdot", new Integer(8901)}, {"lceil", new Integer(8968)}, {"rceil", new Integer(8969)}, {"lfloor", new Integer(8970)}, {"rfloor", new Integer(8971)}, {"lang", new Integer(9001)}, {"rang", new Integer(9002)}, {"loz", new Integer(9674)}, {"spades", new Integer(9824)}, {"clubs", new Integer(9827)}, {"hearts", new Integer(9829)}, {"diams", new Integer(9830)}};

    public FilterVisitor(HTMLFilter2 hTMLFilter2, BufferedWriter bufferedWriter) {
        this.filter = hTMLFilter2;
        if (this.filter.hasOptions()) {
            this.options = (HTMLOptions)this.filter.getOptions();
            if (this.options == null) {
                this.options = new HTMLOptions();
            }
        }
        this.writer = bufferedWriter;
    }

    public boolean shouldRecurseSelf() {
        return this.recurse;
    }

    public boolean shouldRecurseChildren() {
        return this.recurse;
    }

    public void visitTag(Tag tag) {
        if (this.isIntactTag(tag)) {
            if (this.text) {
                this.endup();
            } else {
                this.flushbefors();
            }
            this.writeout(tag.toHtml());
            if (tag.getEndTag() != null) {
                this.recurse = false;
            }
        } else {
            if (this.isParagraphTag(tag) && this.text) {
                this.endup();
            }
            if (this.isPreformattingTag(tag)) {
                this.preformatting = true;
            }
            this.maybeTranslateAttribute(tag, "abbr");
            this.maybeTranslateAttribute(tag, "alt");
            this.maybeTranslateAttribute(tag, "content");
            if (this.options.getTranslateHref()) {
                this.maybeTranslateAttribute(tag, "href");
            }
            if (this.options.getTranslateHreflang()) {
                this.maybeTranslateAttribute(tag, "hreflang");
            }
            if (this.options.getTranslateLang()) {
                this.maybeTranslateAttribute(tag, "lang");
            }
            if ("IMG".equals(tag.getTagName()) && this.options.getTranslateSrc()) {
                this.maybeTranslateAttribute(tag, "src");
            }
            this.maybeTranslateAttribute(tag, "summary");
            this.maybeTranslateAttribute(tag, "title");
            if ("INPUT".equals(tag.getTagName()) && (this.options.getTranslateValue() || "submit".equalsIgnoreCase(tag.getAttribute("type")) || "button".equalsIgnoreCase(tag.getAttribute("type")) || "reset".equalsIgnoreCase(tag.getAttribute("type")) && this.options.getTranslateButtonValue())) {
                this.maybeTranslateAttribute(tag, "value");
            }
            this.queuePrefix(tag);
        }
    }

    protected void maybeTranslateAttribute(Tag tag, String string) {
        String string2 = tag.getAttribute(string);
        if (string2 != null) {
            String string3 = this.filter.privateProcessEntry(string2);
            tag.setAttribute(string, string3);
        }
    }

    public void visitStringNode(Text text) {
        this.recurse = true;
        String string = text.getText().trim();
        if (string.length() > 0) {
            if (this.firstcall && PatternConsts.XML_HEADER.matcher(string).matches()) {
                this.writeout(text.toHtml());
                return;
            }
            this.text = true;
            this.firstcall = false;
        }
        if (this.text) {
            this.queueTranslatable(text);
        } else {
            this.queuePrefix(text);
        }
    }

    public void visitRemarkNode(Remark remark) {
        this.recurse = true;
        if (this.text) {
            this.endup();
        }
        this.writeout(remark.toHtml());
    }

    public void visitEndTag(Tag tag) {
        this.recurse = true;
        if (this.isParagraphTag(tag) && this.text) {
            this.endup();
        }
        if (this.isPreformattingTag(tag)) {
            this.preformatting = false;
        }
        this.queuePrefix(tag);
    }

    public void beginParsing() {
        this.cleanup();
    }

    public void finishedParsing() {
        if (this.text) {
            this.endup();
        } else {
            this.flushbefors();
        }
    }

    private boolean isParagraphTag(Tag tag) {
        String string = tag.getTagName();
        return string.equals("ADDRESS") || string.equals("BLOCKQUOTE") || string.equals("BODY") || string.equals("CENTER") || string.equals("DIV") || string.equals("H1") || string.equals("H2") || string.equals("H3") || string.equals("H4") || string.equals("H5") || string.equals("H6") || string.equals("HTML") || string.equals("HEAD") || string.equals("TITLE") || string.equals("TABLE") || string.equals("TR") || string.equals("TD") || string.equals("TH") || string.equals("P") || string.equals("PRE") || string.equals("OL") || string.equals("UL") || string.equals("LI") || string.equals("DL") || string.equals("DT") || string.equals("DD") || string.equals("FORM") || string.equals("TEXTAREA") || string.equals("FIELDSET") || string.equals("LEGEND") || string.equals("LABEL") || string.equals("SELECT") || string.equals("OPTION") || string.equals("HR") || string.equals("BR") && this.options.getParagraphOnBr();
    }

    private boolean isIntactTag(Tag tag) {
        String string = tag.getTagName();
        return string.equals("!DOCTYPE") || string.equals("STYLE") || string.equals("SCRIPT") || string.equals("OBJECT") || string.equals("EMBED") || string.equals("META") && "content-type".equalsIgnoreCase(tag.getAttribute("http-equiv"));
    }

    private boolean isPreformattingTag(Tag tag) {
        String string = tag.getTagName();
        return string.equals("PRE") || string.equals("TEXTAREA");
    }

    private void writeout(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    protected void endup() {
        String string;
        Node node;
        int n;
        Object object;
        int n2;
        Node node2;
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.befors);
        arrayList.addAll(this.translatable);
        int n3 = this.befors.size();
        int n4 = 0;
        while (n4 < n3) {
            Node node3 = (Node)arrayList.get(n4);
            if (!(node3 instanceof Tag)) {
                ++n4;
                continue;
            }
            node2 = (Tag)node3;
            int n5 = 1;
            boolean bl = false;
            for (n2 = n4 + 1; n2 < arrayList.size(); ++n2) {
                Tag tag;
                object = (Node)arrayList.get(n2);
                if (!(object instanceof Tag) || !(tag = (Tag)object).getTagName().equals(node2.getTagName())) continue;
                if (!tag.isEndTag()) {
                    ++n5;
                    continue;
                }
                if (--n5 != 0) continue;
                if (n2 < n3) break;
                bl = true;
                break;
            }
            if (bl) break;
            ++n4;
        }
        for (n = 0; n < n4; ++n) {
            node2 = (Node)arrayList.get(n);
            if (node2 instanceof Tag) {
                this.writeout("<" + node2.getText() + ">");
                continue;
            }
            this.writeout(node2.getText());
        }
        n = arrayList.size() - 1;
        arrayList.addAll(this.afters);
        int n6 = arrayList.size() - 1;
        while (n6 > n) {
            Node node4 = (Node)arrayList.get(n6);
            if (!(node4 instanceof Tag)) {
                --n6;
                continue;
            }
            Tag tag = (Tag)node4;
            n2 = 1;
            boolean bl = false;
            for (int i = n6 - 1; i >= n3; --i) {
                Tag tag2;
                node = (Node)arrayList.get(i);
                if (!(node instanceof Tag) || !(tag2 = (Tag)node).getTagName().equals(tag.getTagName())) continue;
                if (tag2.isEndTag()) {
                    ++n2;
                    continue;
                }
                if (--n2 != 0) continue;
                if (i > n) break;
                bl = true;
                break;
            }
            if (bl) break;
            --n6;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n4; i <= n6; ++i) {
            Node node5 = (Node)arrayList.get(i);
            if (node5 instanceof Tag) {
                this.shortcut((Tag)node5, stringBuffer);
                continue;
            }
            stringBuffer.append(this.entitiesToChars(node5.toHtml()));
        }
        String string2 = string = stringBuffer.toString();
        if (!this.preformatting) {
            string2 = StaticUtils.compressSpaces(string);
        }
        if (string2.equals(object = this.filter.privateProcessEntry(string2))) {
            object = string;
        }
        object = this.charsToEntities((String)object);
        object = this.unshorcutize((String)object);
        this.writeout((String)object);
        for (int i = n6 + 1; i < arrayList.size(); ++i) {
            node = (Node)arrayList.get(i);
            if (node instanceof Tag) {
                this.writeout("<" + node.getText() + ">");
                continue;
            }
            this.writeout(node.getText());
        }
        this.cleanup();
    }

    private void cleanup() {
        this.text = false;
        this.recurse = true;
        this.befors = new ArrayList();
        this.translatable = new ArrayList();
        this.afters = new ArrayList();
        this.s_tags = new ArrayList();
        this.s_tag_numbers = new ArrayList();
        this.s_shortcuts = new ArrayList();
        this.s_nshortcuts = 0;
    }

    private void shortcut(Tag tag, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append('<');
        int n = -1;
        if (tag.isEndTag()) {
            stringBuffer2.append('/');
            int n2 = 1;
            for (int i = this.s_tags.size() - 1; i >= 0; --i) {
                Tag tag2 = (Tag)this.s_tags.get(i);
                if (!tag2.getTagName().equals(tag.getTagName())) continue;
                if (tag2.isEndTag()) {
                    ++n2;
                    continue;
                }
                if (--n2 != 0) continue;
                n = (Integer)this.s_tag_numbers.get(i);
                break;
            }
            if (n < 0) {
                n = this.s_nshortcuts++;
            }
        } else {
            n = this.s_nshortcuts++;
        }
        if ("BR".equals(tag.getTagName())) {
            stringBuffer2.append("br");
        } else {
            stringBuffer2.append(Character.toLowerCase(tag.getTagName().charAt(0)));
        }
        stringBuffer2.append(n);
        if (tag.isEmptyXmlTag()) {
            stringBuffer2.append('/');
        }
        stringBuffer2.append('>');
        String string = stringBuffer2.toString();
        this.s_tags.add(tag);
        this.s_tag_numbers.add(new Integer(n));
        this.s_shortcuts.add(string);
        stringBuffer.append(string);
    }

    private String unshorcutize(String string) {
        block2: for (int i = 0; i < this.s_shortcuts.size(); ++i) {
            String string2 = (String)this.s_shortcuts.get(i);
            int n = -1;
            while ((n = string.indexOf(string2, n + 1)) >= 0) {
                Tag tag = (Tag)this.s_tags.get(i);
                try {
                    string = string.substring(0, n) + "<" + tag.getText() + ">" + string.substring(n + string2.length());
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                    continue block2;
                }
            }
        }
        return string;
    }

    private void queueTranslatable(Text text) {
        if (text.toHtml().trim().length() > 0) {
            this.translatable.addAll(this.afters);
            this.afters.clear();
            this.translatable.add(text);
        } else {
            this.afters.add(text);
        }
    }

    private void queueTranslatable(Tag tag) {
        this.afters.add(tag);
    }

    protected void queuePrefix(Tag tag) {
        if (this.text) {
            this.queueTranslatable(tag);
        } else if (this.isParagraphTag(tag)) {
            this.flushbefors();
            this.writeout("<" + tag.getText() + ">");
        } else {
            this.befors.add(tag);
        }
    }

    private void queuePrefix(Text text) {
        this.befors.add(text);
    }

    private void flushbefors() {
        for (int i = 0; i < this.befors.size(); ++i) {
            Node node = (Node)this.befors.get(i);
            if (node instanceof Tag) {
                this.writeout("<" + node.getText() + ">");
                continue;
            }
            this.writeout(node.getText());
        }
        this.befors.clear();
    }

    private String entitiesToChars(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    int n2;
                    int n3;
                    if (i + 1 >= n) {
                        stringBuffer.append(c);
                        continue block7;
                    }
                    char c2 = string.charAt(i + 1);
                    if (c2 == '#') {
                        char c3;
                        n3 = string.charAt(i + 2);
                        if (n3 == 120 || n3 == 88) {
                            char c4;
                            for (n2 = i + 3; n2 < n && this.isHexDigit(c4 = string.charAt(n2)); ++n2) {
                            }
                            String string2 = string.substring(i + 3, n2);
                            try {
                                int n4 = Integer.parseInt(string2, 16);
                                if (n4 > 0 && n4 <= 65535) {
                                    stringBuffer.append((char)n4);
                                    if (n2 < n && string.charAt(n2) == ';') {
                                        i = n2;
                                        continue block7;
                                    }
                                    i = n2 - 1;
                                    continue block7;
                                }
                                stringBuffer.append(c);
                            }
                            catch (NumberFormatException numberFormatException) {
                                stringBuffer.append(c);
                            }
                            continue block7;
                        }
                        for (n2 = i + 2; n2 < n && this.isDecimalDigit(c3 = string.charAt(n2)); ++n2) {
                        }
                        String string3 = string.substring(i + 2, n2);
                        try {
                            int n5 = Integer.parseInt(string3, 10);
                            if (n5 > 0 && n5 <= 65535) {
                                stringBuffer.append((char)n5);
                                if (n2 < n && string.charAt(n2) == ';') {
                                    i = n2;
                                    continue block7;
                                }
                                i = n2 - 1;
                                continue block7;
                            }
                            stringBuffer.append(c);
                        }
                        catch (NumberFormatException numberFormatException) {
                            stringBuffer.append(c);
                        }
                        continue block7;
                    }
                    if (this.isLatinLetter(c2)) {
                        String string4;
                        int n6;
                        for (n3 = i + 1; n3 < n; ++n3) {
                            char c5 = string.charAt(n3);
                            n2 = c5;
                            if (!this.isLatinLetter(c5)) break;
                        }
                        if ((n6 = this.lookupEntity(string4 = string.substring(i + 1, n3))) > 0 && n6 <= 65535) {
                            stringBuffer.append((char)n6);
                            if (n3 < n && string.charAt(n3) == ';') {
                                i = n3;
                                continue block7;
                            }
                            i = n3 - 1;
                            continue block7;
                        }
                        stringBuffer.append(c);
                        continue block7;
                    }
                    stringBuffer.append(c);
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private boolean isLatinLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private int lookupEntity(String string) {
        for (int i = 0; i < ENTITIES.length; ++i) {
            Object[] objectArray = ENTITIES[i];
            if (!string.equals(objectArray[0])) continue;
            return (Integer)objectArray[1];
        }
        return -1;
    }

    private String charsToEntities(String string) {
        String string2;
        char c;
        boolean bl;
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 5);
        block6: for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            switch (c2) {
                case '\u00a0': {
                    stringBuffer.append("&nbsp;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '<': {
                    int n2 = string.indexOf(62, i);
                    if (n2 >= 0) {
                        String string3 = string.substring(i, n2 + 1);
                        bl = false;
                        for (c = '\u0000'; c < this.s_shortcuts.size(); ++c) {
                            string2 = (String)this.s_shortcuts.get(c);
                            if (!string3.equals(string2)) continue;
                            bl = true;
                            break;
                        }
                        if (bl) {
                            stringBuffer.append(string3);
                            i = n2;
                            continue block6;
                        }
                        stringBuffer.append("&lt;");
                        continue block6;
                    }
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        String string4 = stringBuffer.toString();
        String string5 = this.filter.getTargetEncoding();
        if (string5 != null) {
            CharsetEncoder charsetEncoder = Charset.forName(string5).newEncoder();
            int n3 = 0;
            bl = true;
            while (bl) {
                while (n3 < string4.length()) {
                    c = string4.charAt(n3);
                    if (!charsetEncoder.canEncode(c)) {
                        string2 = c == '[' || c == '\\' || c == '^' || c == '$' || c == '.' || c == '|' || c == '?' || c == '*' || c == '+' || c == '(' || c == ')' ? "\\" + c : "" + c;
                        String string6 = "&#" + c + ';';
                        string4 = string4.replaceAll(string2, string6);
                        break;
                    }
                    ++n3;
                }
                if (n3 != string4.length()) continue;
                bl = false;
            }
        }
        return string4;
    }
}

