/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import org.omegat.core.threads.CommandThread;
import org.omegat.gui.HListener;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.openide.awt.Mnemonics;

public class ProjectFrame
extends JFrame {
    private JEditorPane m_editorPane;
    private JButton m_addNewFileButton;
    private JButton m_wikiImportButton;
    private JButton m_closeButton;
    private ArrayList m_nameList;
    private ArrayList m_offsetList;
    private int numberofUniqueSegments;
    private MainWindow m_parent;

    public ProjectFrame(MainWindow mainWindow) {
        this.m_parent = mainWindow;
        this.m_nameList = new ArrayList(256);
        this.m_offsetList = new ArrayList(256);
        this.initWindowLayout();
        Container container = this.getContentPane();
        this.m_editorPane = new JEditorPane();
        this.m_editorPane.setEditable(false);
        this.m_editorPane.setContentType("text/html");
        JScrollPane jScrollPane = new JScrollPane(this.m_editorPane);
        container.add((Component)jScrollPane, "Center");
        this.m_addNewFileButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.m_addNewFileButton, (String)OStrings.getString("TF_MENU_FILE_IMPORT"));
        this.m_addNewFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectFrame.this.doImportSourceFiles();
            }
        });
        this.m_wikiImportButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.m_wikiImportButton, (String)OStrings.getString("TF_MENU_WIKI_IMPORT"));
        this.m_wikiImportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectFrame.this.doWikiImport();
            }
        });
        this.uiUpdateImportButtonStatus();
        this.m_closeButton = new JButton();
        this.m_closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectFrame.this.doCancel();
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectFrame.this.doCancel();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.m_addNewFileButton);
        box.add(this.m_wikiImportButton);
        box.add(this.m_closeButton);
        box.add(Box.createHorizontalGlue());
        container.add((Component)box, "South");
        this.m_editorPane.addHyperlinkListener(new HListener(this.m_parent, true));
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
                ProjectFrame.this.m_parent.filelistWindowClosed();
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.m_closeButton, (String)OStrings.getString("BUTTON_CLOSE"));
        this.setTitle(OStrings.getString("PF_WINDOW_TITLE"));
        this.uiUpdateImportButtonStatus();
    }

    private void initWindowLayout() {
        try {
            String string = Preferences.getPreference("project_files_window_x");
            String string2 = Preferences.getPreference("project_files_window_y");
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt(string2);
            this.setLocation(n, n2);
            String string3 = Preferences.getPreference("project_files_window_width");
            String string4 = Preferences.getPreference("project_files_window_height");
            int n3 = Integer.parseInt(string3);
            int n4 = Integer.parseInt(string4);
            this.setSize(n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setBounds((dimension.width - 600) / 2, (dimension.height - 400) / 2, 600, 400);
        }
    }

    private void saveWindowLayout() {
        Preferences.setPreference("project_files_window_width", this.getWidth());
        Preferences.setPreference("project_files_window_height", this.getHeight());
        Preferences.setPreference("project_files_window_x", this.getX());
        Preferences.setPreference("project_files_window_y", this.getY());
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        int n = windowEvent.getID();
        if (n == 201 || n == 202) {
            this.saveWindowLayout();
        }
        super.processWindowEvent(windowEvent);
    }

    private void doCancel() {
        this.setVisible(false);
    }

    public void reset() {
        this.m_nameList.clear();
        this.m_offsetList.clear();
        this.m_editorPane.setText("");
        this.numberofUniqueSegments = -1;
        this.uiUpdateImportButtonStatus();
    }

    public void addFile(String string, int n) {
        this.m_nameList.add(string);
        this.m_offsetList.add(new Integer(n));
    }

    public void buildDisplay() {
        if (this.m_nameList == null || this.m_offsetList == null || this.m_nameList.size() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>\n");
        stringBuffer.append("<head>\n");
        stringBuffer.append("<style>\n");
        stringBuffer.append("<style type=\"text/css\">\n");
        stringBuffer.append("    <!--\n");
        stringBuffer.append("    body {\n");
        stringBuffer.append("            font-family: " + this.getFont().getName() + ";\n");
        stringBuffer.append("            font-size: " + this.getFont().getSize() + "pt;\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("    -->\n");
        stringBuffer.append("</style>\n");
        stringBuffer.append("</head>\n");
        stringBuffer.append("<body>\n");
        stringBuffer.append("<table align=center width=95% border=0>\n");
        stringBuffer.append("<tr>\n");
        stringBuffer.append("<th width=80% align=center>");
        stringBuffer.append(OStrings.getString("PF_FILENAME"));
        stringBuffer.append("</th>\n");
        stringBuffer.append("<th width=20% align=center>");
        stringBuffer.append(OStrings.getString("PF_NUM_SEGMENTS"));
        stringBuffer.append("</th>\n");
        stringBuffer.append("</tr>\n");
        int n = 1;
        int n2 = 0;
        String string = this.m_parent.getActiveFileName();
        for (int i = 0; i < this.m_nameList.size(); ++i) {
            String string2 = (String)this.m_nameList.get(i);
            n2 = (Integer)this.m_offsetList.get(i);
            int n3 = 1 + n2 - n;
            String string3 = string2.equals(string) ? "<tr bgcolor=\"#C8DDF2\">\n" : "<tr>\n";
            stringBuffer.append(string3);
            stringBuffer.append("<td width=80%>");
            stringBuffer.append("<a href=\"" + n + "\">" + string2 + "</a>");
            stringBuffer.append("</td>\n");
            stringBuffer.append("<td width=20% align=center>");
            stringBuffer.append(n3);
            stringBuffer.append("</td>\n");
            stringBuffer.append("</tr>\n");
            n = n2 + 1;
        }
        if (this.m_nameList.size() > 1) {
            stringBuffer.append("<tr>\n");
            stringBuffer.append("<td width=80%><b>");
            stringBuffer.append(OStrings.getString("GUI_PROJECT_TOTAL_SEGMENTS"));
            stringBuffer.append("</b></td>\n");
            stringBuffer.append("<td width=20% align=center><b>");
            stringBuffer.append(CommandThread.core.getNumberOfSegmentsTotal());
            stringBuffer.append("</b></td>\n");
            stringBuffer.append("</tr>\n");
        }
        stringBuffer.append("<tr>\n");
        stringBuffer.append("<td width=80%><b>");
        stringBuffer.append(OStrings.getString("GUI_PROJECT_UNIQUE_SEGMENTS"));
        stringBuffer.append("</b></td>\n");
        stringBuffer.append("<td width=20% align=center><b>");
        stringBuffer.append(CommandThread.core.getNumberOfUniqueSegments());
        stringBuffer.append("</b></td>\n");
        stringBuffer.append("</tr>\n");
        stringBuffer.append("<tr>\n");
        stringBuffer.append("<td width=80%><b>");
        stringBuffer.append(OStrings.getString("GUI_PROJECT_TRANSLATED"));
        stringBuffer.append("</b></td>\n");
        stringBuffer.append("<td width=20% align=center id=\"nts\"><b>");
        stringBuffer.append(CommandThread.core.getNumberofTranslatedSegments());
        stringBuffer.append("</b></td>\n");
        stringBuffer.append("</tr>\n");
        stringBuffer.append("</table>\n");
        stringBuffer.append("</body>\n");
        stringBuffer.append("</html>\n");
        this.m_editorPane.setText(stringBuffer.toString());
        this.uiUpdateImportButtonStatus();
    }

    public void updateNumberOfTranslatedSegments() {
        try {
            HTMLDocument hTMLDocument = (HTMLDocument)this.m_editorPane.getDocument();
            Element element = hTMLDocument.getElement("nts");
            int n = CommandThread.core.getNumberofTranslatedSegments();
            hTMLDocument.setInnerHTML(element, "<b>" + n + "</b>");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doImportSourceFiles() {
        this.m_parent.doImportSourceFiles();
    }

    private void doWikiImport() {
        this.m_parent.doWikiImport();
    }

    public void uiUpdateImportButtonStatus() {
        this.m_addNewFileButton.setEnabled(this.m_parent.isProjectLoaded());
        this.m_wikiImportButton.setEnabled(this.m_parent.isProjectLoaded());
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.buildDisplay();
    }
}

