/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.StringContent;
import javax.swing.undo.UndoManager;
import org.omegat.core.threads.CommandThread;
import org.omegat.core.threads.SearchThread;
import org.omegat.gui.EntryListPane;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.OmegaTFileChooser;
import org.openide.awt.Mnemonics;

public class SearchWindow
extends JFrame {
    private MainWindow m_parent;
    private JLabel m_searchLabel;
    private JTextField m_searchField;
    private JButton m_searchButton;
    private JRadioButton m_exactSearchRB;
    private JRadioButton m_keywordSearchRB;
    private JLabel m_resultsLabel;
    private JCheckBox m_caseCB;
    private JCheckBox m_regexCB;
    private JCheckBox m_tmSearchCB;
    private boolean m_tmSearch = true;
    private JLabel m_dirLabel;
    private JTextField m_dirField;
    private JButton m_dirButton;
    private JCheckBox m_dirCB;
    private JCheckBox m_recursiveCB;
    private JButton m_dismissButton;
    private EntryListPane m_viewer;
    private SearchThread m_thread;
    private static final String SEARCH_TYPE_EXACT = "EXACT";
    private static final String SEARCH_TYPE_KEYWORD = "KEYWORD";

    public SearchWindow(MainWindow mainWindow, String string) {
        this.m_parent = mainWindow;
        this.m_searchLabel = new JLabel();
        this.m_searchField = new MFindField();
        if (string != null) {
            this.m_searchField.setText(string);
        }
        this.m_searchButton = new JButton();
        Box box = Box.createHorizontalBox();
        box.add(this.m_searchLabel);
        box.add(this.m_searchField);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.m_searchButton);
        this.m_exactSearchRB = new JRadioButton();
        this.m_keywordSearchRB = new JRadioButton();
        this.m_resultsLabel = new JLabel();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_exactSearchRB);
        buttonGroup.add(this.m_keywordSearchRB);
        Box box2 = Box.createHorizontalBox();
        box2.add(this.m_exactSearchRB);
        box2.add(Box.createHorizontalStrut(10));
        box2.add(this.m_keywordSearchRB);
        box2.add(Box.createHorizontalStrut(10));
        box2.add(this.m_resultsLabel);
        this.m_caseCB = new JCheckBox();
        this.m_regexCB = new JCheckBox();
        this.m_tmSearchCB = new JCheckBox();
        Box box3 = Box.createHorizontalBox();
        box3.add(this.m_caseCB);
        box3.add(Box.createHorizontalStrut(10));
        box3.add(this.m_regexCB);
        box3.add(Box.createHorizontalStrut(10));
        box3.add(this.m_tmSearchCB);
        this.m_viewer = new EntryListPane(mainWindow);
        JScrollPane jScrollPane = new JScrollPane(this.m_viewer);
        this.m_dirLabel = new JLabel();
        this.m_dirField = new JTextField();
        this.m_dirField.setEditable(false);
        this.m_dirButton = new JButton();
        Box box4 = Box.createHorizontalBox();
        box4.add(this.m_dirLabel);
        box4.add(this.m_dirField);
        box4.add(Box.createHorizontalStrut(10));
        box4.add(this.m_dirButton);
        this.m_dirCB = new JCheckBox();
        this.m_dirCB.setSelected(false);
        this.m_recursiveCB = new JCheckBox();
        this.m_recursiveCB.setSelected(true);
        this.m_recursiveCB.setEnabled(false);
        this.m_dismissButton = new JButton();
        Box box5 = Box.createHorizontalBox();
        box5.add(this.m_dirCB);
        box5.add(Box.createHorizontalStrut(10));
        box5.add(this.m_recursiveCB);
        box5.add(Box.createHorizontalGlue());
        box5.add(this.m_dismissButton);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(box, gridBagConstraints);
        container.add(box);
        gridBagLayout.setConstraints(box2, gridBagConstraints);
        container.add(box2);
        gridBagLayout.setConstraints(box3, gridBagConstraints);
        container.add(box3);
        gridBagConstraints.weighty = 3.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        container.add(jScrollPane);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagLayout.setConstraints(box4, gridBagConstraints);
        container.add(box4);
        gridBagLayout.setConstraints(box5, gridBagConstraints);
        container.add(box5);
        this.m_dismissButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.doCancel();
            }
        });
        this.m_searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.doSearch();
            }
        });
        this.m_dirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.doBrowseDirectory();
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.doCancel();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        this.m_exactSearchRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.m_searchField.requestFocus();
            }
        });
        this.m_keywordSearchRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.m_searchField.requestFocus();
            }
        });
        this.m_caseCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.m_searchField.requestFocus();
            }
        });
        this.m_regexCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.m_searchField.requestFocus();
            }
        });
        this.m_tmSearchCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.m_tmSearch = SearchWindow.this.m_tmSearchCB.isSelected();
                SearchWindow.this.m_searchField.requestFocus();
            }
        });
        this.m_dirCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchWindow.this.updateOptionStatus();
                if (SearchWindow.this.m_dirCB.isSelected()) {
                    SearchWindow.this.m_dirField.requestFocus();
                } else {
                    SearchWindow.this.m_searchField.requestFocus();
                }
            }
        });
        this.updateUIText();
        this.loadPreferences();
        this.m_viewer.setText(OStrings.getString("SW_VIEWER_TEXT"));
        if (!mainWindow.isProjectLoaded()) {
            this.m_dirCB.setSelected(true);
            this.m_dirCB.setEnabled(false);
            this.m_tmSearchCB.setSelected(false);
            this.m_tmSearchCB.setEnabled(false);
            this.m_dirField.setEditable(true);
            this.updateOptionStatus();
        }
        this.m_searchField.requestFocus();
        this.m_thread = new SearchThread(mainWindow, this, string);
        this.m_thread.start();
    }

    private void loadPreferences() {
        String string;
        String string2;
        String string3;
        String string4;
        try {
            string4 = Preferences.getPreference("search_window_x");
            string3 = Preferences.getPreference("search_window_y");
            int n = Integer.parseInt(string4);
            int n2 = Integer.parseInt(string3);
            this.setLocation(n, n2);
            string2 = Preferences.getPreference("search_window_width");
            string = Preferences.getPreference("search_window_height");
            int n3 = Integer.parseInt(string2);
            int n4 = Integer.parseInt(string);
            this.setSize(n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            this.setSize(650, 700);
        }
        string4 = Preferences.getPreference("search_window_search_files");
        if (string4 == null || string4.length() == 0) {
            string4 = "false";
        }
        this.m_dirCB.setSelected(Boolean.valueOf(string4));
        string3 = Preferences.getPreference("search_window_dir");
        if (!string3.equals("")) {
            this.m_dirField.setText(string3);
        }
        this.m_dirField.setEditable(this.m_dirCB.isSelected());
        String string5 = Preferences.getPreference("search_window_search_recursive");
        if (string5 == null || string5.length() == 0) {
            string5 = "true";
        }
        this.m_recursiveCB.setSelected(Boolean.valueOf(string5));
        this.m_recursiveCB.setEnabled(this.m_dirCB.isSelected());
        String string6 = Preferences.getPreference("search_window_search_type");
        if (string6 == null || string6.length() == 0) {
            string6 = SEARCH_TYPE_EXACT;
        }
        this.m_exactSearchRB.setSelected(string6.equals(SEARCH_TYPE_EXACT));
        this.m_keywordSearchRB.setSelected(string6.equals(SEARCH_TYPE_KEYWORD));
        string2 = Preferences.getPreference("search_window_case_sensitive");
        if (string2 == null || string2.length() == 0) {
            string2 = "false";
        }
        this.m_caseCB.setSelected(Boolean.valueOf(string2));
        string = Preferences.getPreference("search_window_reg_expressions");
        if (string == null || string.length() == 0) {
            string = "false";
        }
        this.m_regexCB.setSelected(Boolean.valueOf(string));
        String string7 = Preferences.getPreference("search_window_tm_search");
        if (string7 == null || string7.length() == 0) {
            string7 = "true";
        }
        this.m_tmSearchCB.setSelected(Boolean.valueOf(string7));
        this.m_tmSearch = Boolean.valueOf(string7);
        this.updateOptionStatus();
    }

    private void savePreferences() {
        Preferences.setPreference("search_window_width", this.getWidth());
        Preferences.setPreference("search_window_height", this.getHeight());
        Preferences.setPreference("search_window_x", this.getX());
        Preferences.setPreference("search_window_y", this.getY());
        if (this.m_exactSearchRB.isSelected()) {
            Preferences.setPreference("search_window_search_type", SEARCH_TYPE_EXACT);
        } else if (this.m_keywordSearchRB.isSelected()) {
            Preferences.setPreference("search_window_search_type", SEARCH_TYPE_KEYWORD);
        }
        Preferences.setPreference("search_window_case_sensitive", Boolean.toString(this.m_caseCB.isSelected()));
        Preferences.setPreference("search_window_reg_expressions", Boolean.toString(this.m_regexCB.isSelected()));
        Preferences.setPreference("search_window_tm_search", Boolean.toString(this.m_tmSearch));
        Preferences.setPreference("search_window_dir", this.m_dirField.getText());
        Preferences.setPreference("search_window_search_files", Boolean.toString(this.m_dirCB.isSelected()));
        Preferences.setPreference("search_window_search_recursive", Boolean.toString(this.m_recursiveCB.isSelected()));
        Preferences.save();
    }

    private void updateOptionStatus() {
        this.m_tmSearchCB.setEnabled(!this.m_dirCB.isSelected());
        this.m_tmSearchCB.setSelected(!this.m_dirCB.isSelected() && this.m_tmSearch);
        this.m_recursiveCB.setEnabled(this.m_dirCB.isSelected());
        this.m_dirField.setEditable(this.m_dirCB.isSelected());
    }

    public void displayResults() {
        this.m_viewer.finalize();
        this.m_resultsLabel.setText(StaticUtils.format(OStrings.getString("SW_NR_OF_RESULTS"), new Object[]{new Integer(this.m_viewer.getNrEntries())}));
    }

    public void addEntry(int n, String string, String string2, String string3) {
        this.m_viewer.addEntry(n, string, string2, string3);
    }

    public void postMessage(String string) {
        this.m_viewer.addMessage(string);
    }

    public void setSearchControlFocus() {
        this.m_searchField.requestFocus();
    }

    public void threadDied() {
        this.m_thread = null;
        this.dispose();
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        int n = windowEvent.getID();
        if (n == 201 || n == 202) {
            this.savePreferences();
            this.m_parent.searchWindowClosed(this);
            if (this.m_thread != null) {
                this.m_thread.interrupt();
            }
        }
        super.processWindowEvent(windowEvent);
    }

    private void doBrowseDirectory() {
        File file;
        OmegaTFileChooser omegaTFileChooser = new OmegaTFileChooser();
        omegaTFileChooser.setDialogTitle(OStrings.getString("SW_TITLE"));
        omegaTFileChooser.setFileSelectionMode(1);
        String string = this.m_dirField.getText();
        if (!string.equals("") && (file = new File(string)).exists() && file.isDirectory()) {
            omegaTFileChooser.setCurrentDirectory(file);
        }
        omegaTFileChooser.showOpenDialog(this);
        file = omegaTFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        String string2 = file.getAbsolutePath() + File.separator;
        this.m_dirField.setText(string2);
    }

    private void doSearch() {
        if (this.m_thread == null) {
            this.doCancel();
        } else {
            this.m_viewer.reset();
            String string = null;
            if (this.m_dirCB.isSelected()) {
                File file;
                string = this.m_dirField.getText();
                if (!string.endsWith(File.separator)) {
                    string = string + File.separator;
                }
                if (!(file = new File(string)).exists() || !file.isDirectory()) {
                    String string2 = StaticUtils.format(OStrings.getString("SW_ERROR_BAD_DIR"), new Object[]{this.m_dirField.getText()});
                    this.m_viewer.setText(string2);
                    Log.log(string2);
                    return;
                }
                if (CommandThread.core != null && this.m_dirCB.isSelected()) {
                    Preferences.setPreference("search_window_dir", string);
                    Preferences.save();
                }
            }
            this.m_thread.requestSearch(this.m_searchField.getText(), string, this.m_recursiveCB.isSelected(), this.m_exactSearchRB.isSelected(), this.m_keywordSearchRB.isSelected(), this.m_caseCB.isSelected(), this.m_regexCB.isSelected(), this.m_tmSearchCB.isSelected());
        }
    }

    private void doCancel() {
        this.dispose();
    }

    private void updateUIText() {
        this.setTitle(OStrings.getString("SW_TITLE"));
        Mnemonics.setLocalizedText((JLabel)this.m_searchLabel, (String)OStrings.getString("SW_SEARCH_TEXT"));
        Mnemonics.setLocalizedText((AbstractButton)this.m_searchButton, (String)OStrings.getString("BUTTON_SEARCH"));
        Mnemonics.setLocalizedText((AbstractButton)this.m_exactSearchRB, (String)OStrings.getString("SW_EXACT_SEARCH"));
        Mnemonics.setLocalizedText((AbstractButton)this.m_keywordSearchRB, (String)OStrings.getString("SW_WORD_SEARCH"));
        Mnemonics.setLocalizedText((AbstractButton)this.m_caseCB, (String)OStrings.getString("SW_CASE_SENSITIVE"));
        Mnemonics.setLocalizedText((AbstractButton)this.m_regexCB, (String)OStrings.getString("SW_REG_EXPRESSIONS"));
        Mnemonics.setLocalizedText((AbstractButton)this.m_tmSearchCB, (String)OStrings.getString("SW_SEARCH_TM"));
        Mnemonics.setLocalizedText((JLabel)this.m_dirLabel, (String)OStrings.getString("SW_LOCATION"));
        Mnemonics.setLocalizedText((AbstractButton)this.m_dirCB, (String)OStrings.getString("SW_DIR_SEARCH"));
        Mnemonics.setLocalizedText((AbstractButton)this.m_recursiveCB, (String)OStrings.getString("SW_DIR_RECURSIVE"));
        Mnemonics.setLocalizedText((AbstractButton)this.m_dirButton, (String)OStrings.getString("SW_BROWSE"));
        Mnemonics.setLocalizedText((AbstractButton)this.m_dismissButton, (String)OStrings.getString("BUTTON_CLOSE"));
    }

    class MFindField
    extends JTextField {
        private UndoManager undoManager;

        public MFindField() {
            KeyStroke keyStroke = StaticUtils.onMacOSX() ? KeyStroke.getKeyStroke(90, 4, false) : KeyStroke.getKeyStroke(90, 2, false);
            AbstractAction abstractAction = new AbstractAction(this){
                private final /* synthetic */ MFindField this$1;
                {
                    this.this$1 = mFindField;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.undo();
                }
            };
            this.getInputMap().put(keyStroke, "UNDO");
            this.getActionMap().put("UNDO", abstractAction);
            KeyStroke keyStroke2 = StaticUtils.onMacOSX() ? KeyStroke.getKeyStroke(89, 4, false) : KeyStroke.getKeyStroke(89, 2, false);
            AbstractAction abstractAction2 = new AbstractAction(this){
                private final /* synthetic */ MFindField this$1;
                {
                    this.this$1 = mFindField;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.redo();
                }
            };
            this.getInputMap().put(keyStroke2, "REDO");
            this.getActionMap().put("REDO", abstractAction2);
        }

        protected Document createDefaultModel() {
            PlainDocument plainDocument = new PlainDocument(new StringContent());
            this.undoManager = new UndoManager();
            plainDocument.addUndoableEditListener(this.undoManager);
            return plainDocument;
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 && keyEvent.getID() == 401) {
                if (!this.getText().equals("")) {
                    SearchWindow.this.doSearch();
                }
            } else {
                super.processKeyEvent(keyEvent);
            }
        }

        protected void undo() {
            if (this.undoManager.canUndo()) {
                this.undoManager.undo();
            }
        }

        protected void redo() {
            if (this.undoManager.canRedo()) {
                this.undoManager.redo();
            }
        }
    }
}

