/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleContext;
import javax.swing.text.Utilities;
import javax.swing.undo.UndoManager;
import org.omegat.core.matching.SourceTextEntry;
import org.omegat.core.spellchecker.SpellChecker;
import org.omegat.core.threads.CommandThread;
import org.omegat.gui.main.DocumentSegment;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.Log;
import org.omegat.util.OConsts;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.Token;
import org.omegat.util.gui.ExtendedEditorKit;
import org.omegat.util.gui.Styles;

public class EditorTextArea
extends JTextPane
implements MouseListener,
DocumentListener {
    private MainWindow mw;
    private UndoManager undoManager;
    private static final String IMPOSSIBLE = "Should not have happened, report to http://sf.net/tracker/?group_id=68187&atid=520347";
    private static final int CTRL_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final int CTRL_DEL_MASK = StaticUtils.onMacOSX() ? 8 : CTRL_KEY_MASK;
    int textLength = 0;
    private JPopupMenu popup;
    public static final int CASE_LOWER = 1;
    public static final int CASE_TITLE = 2;
    public static final int CASE_UPPER = 3;
    public static final int CASE_CYCLE = 0;

    public EditorTextArea(MainWindow mainWindow) {
        this.mw = mainWindow;
        this.setEditorKit(new ExtendedEditorKit());
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument(new StyleContext());
        defaultStyledDocument.addDocumentListener(this);
        this.undoManager = new UndoManager();
        defaultStyledDocument.addUndoableEditListener(this.undoManager);
        this.setDocument(defaultStyledDocument);
        this.setText(OStrings.getString("TF_INTRO_MESSAGE"));
        this.addMouseListener(this);
    }

    public synchronized void cancelUndo() {
        this.undoManager.die();
    }

    public synchronized void undoOneEdit() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    public synchronized void redoOneEdit() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    public synchronized void mouseClicked(MouseEvent mouseEvent) {
        if (this.mw == null) {
            return;
        }
        if (!this.mw.m_docReady) {
            return;
        }
        if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3) {
            if (this.createSpellCheckerPopUp(mouseEvent.getPoint())) {
                return;
            }
            if (this.createGoToSegmentPopUp(mouseEvent.getPoint())) {
                return;
            }
        }
        if (mouseEvent.getClickCount() == 2) {
            this.goToSegmentAtCaretLocation();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    protected synchronized void processKeyEvent(KeyEvent keyEvent) {
        this.processKeyEventBody(keyEvent);
        this.mw.setLengthLabel(" " + Integer.toString(this.mw.m_sourceDisplayLength) + "/" + Integer.toString(this.getTextLength() - this.mw.m_segmentEndInset - OStrings.getSegmentEndMarker().length() - (this.mw.m_segmentStartOffset + this.mw.m_sourceDisplayLength + OStrings.getSegmentStartMarker().length())) + " ");
    }

    protected synchronized void processKeyEventBody(KeyEvent keyEvent) {
        int n;
        if (this.mw == null) {
            return;
        }
        if (!this.mw.m_projectLoaded) {
            if ((keyEvent.getModifiers() & CTRL_KEY_MASK) == CTRL_KEY_MASK || (keyEvent.getModifiers() & 8) == 8) {
                super.processKeyEvent(keyEvent);
            }
            return;
        }
        int n2 = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        if (keyEvent.getID() == 402) {
            super.processKeyEvent(keyEvent);
            return;
        }
        if (keyEvent.getID() == 401 && (n2 == 17 || n2 == 18 || n2 == 157 || n2 == 16)) {
            super.processKeyEvent(keyEvent);
            return;
        }
        if (keyEvent.getID() == 401 && keyEvent.getModifiers() == CTRL_KEY_MASK && n2 == 67 || keyEvent.getID() == 400 && keyEvent.getModifiers() == CTRL_KEY_MASK && c == '\u0003') {
            super.processKeyEvent(keyEvent);
            return;
        }
        switch (c) {
            case '\b': {
                if (this.mw.checkCaretForDelete(false)) {
                    if (keyEvent.getModifiers() == CTRL_DEL_MASK && keyEvent.getKeyCode() == 8) {
                        try {
                            int n3 = this.getCaretPosition();
                            int n4 = Utilities.getPreviousWord(this, n3);
                            int n5 = Utilities.getWordEnd(this, n4);
                            int n6 = Utilities.getPreviousWord(this, n4);
                            int n7 = Utilities.getWordEnd(this, n6);
                            this.setSelectionEnd(n3);
                            if (n5 != n3 && n5 < n3) {
                                this.setSelectionStart(n4);
                            } else {
                                this.setSelectionStart(n7);
                            }
                            this.mw.checkCaret();
                            this.replaceSelection("");
                            return;
                        }
                        catch (BadLocationException badLocationException) {}
                    } else {
                        super.processKeyEvent(keyEvent);
                    }
                }
                this.checkSpelling(false);
                return;
            }
            case '\u007f': {
                if (this.mw.checkCaretForDelete(true)) {
                    if (keyEvent.getModifiers() == CTRL_DEL_MASK && keyEvent.getKeyCode() == 127) {
                        try {
                            int n8 = this.getCaretPosition();
                            int n9 = Utilities.getNextWord(this, n8);
                            int n10 = Utilities.getWordEnd(this, n8);
                            this.setSelectionStart(n8);
                            if (n9 == n10) {
                                this.setSelectionEnd(n10);
                            } else {
                                this.setSelectionEnd(n9);
                            }
                            this.mw.checkCaret();
                            this.replaceSelection("");
                            return;
                        }
                        catch (BadLocationException badLocationException) {}
                    } else {
                        super.processKeyEvent(keyEvent);
                    }
                }
                this.checkSpelling(false);
                return;
            }
        }
        if (n2 == 36 || n2 == 35) {
            super.processKeyEvent(keyEvent);
            this.mw.checkCaret();
            return;
        }
        if (keyEvent.getModifiers() == CTRL_KEY_MASK && keyEvent.getKeyCode() == 65) {
            int n11 = this.mw.m_segmentStartOffset + this.mw.m_sourceDisplayLength + OConsts.segmentStartStringFull.length();
            int n12 = this.getTextLength() - this.mw.m_segmentEndInset - OConsts.segmentEndStringFull.length();
            this.setSelectionStart(n11);
            this.setSelectionEnd(n12);
            return;
        }
        this.mw.checkCaret();
        if (n2 == 10) {
            if (keyEvent.isShiftDown()) {
                KeyEvent keyEvent2 = new KeyEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), 0, 10, '\n');
                super.processKeyEvent(keyEvent2);
            } else if (this.mw.m_advancer != n2) {
                return;
            }
        }
        if (n2 == this.mw.m_advancer) {
            if (this.mw.m_advancer == '\n') {
                if ((keyEvent.getModifiers() & CTRL_KEY_MASK) == CTRL_KEY_MASK) {
                    if (keyEvent.getID() == 401) {
                        this.mw.doPrevEntry();
                    }
                } else if (!keyEvent.isShiftDown() && keyEvent.getID() == 401) {
                    this.mw.doNextEntry();
                }
            } else if (this.mw.m_advancer == '\t') {
                if (keyEvent.isShiftDown()) {
                    if (keyEvent.getID() == 401) {
                        this.mw.doPrevEntry();
                    }
                } else if (keyEvent.getID() == 401) {
                    this.mw.doNextEntry();
                }
            }
            return;
        }
        if (keyEvent.isShiftDown()) {
            if (n2 == 38 || n2 == 37 || n2 == 224 || n2 == 226) {
                int n13;
                super.processKeyEvent(keyEvent);
                if (keyEvent.getID() == 401 && (n13 = this.getCaretPosition()) < (n = this.mw.m_segmentStartOffset + this.mw.m_sourceDisplayLength + OConsts.segmentStartStringFull.length())) {
                    this.moveCaretPosition(n);
                }
            } else if (n2 == 40 || n2 == 39 || n2 == 225 || n2 == 227) {
                int n14;
                super.processKeyEvent(keyEvent);
                if (keyEvent.getID() == 401 && (n14 = this.getCaretPosition()) > (n = this.getTextLength() - this.mw.m_segmentEndInset - OConsts.segmentEndStringFull.length())) {
                    this.moveCaretPosition(n);
                }
            }
        }
        if (!keyEvent.isShiftDown()) {
            if (n2 == 38 || n2 == 37 || n2 == 224 || n2 == 226) {
                int n15 = this.getSelectionEnd();
                if (n15 != (n = this.getSelectionStart())) {
                    this.setCaretPosition(n);
                } else {
                    super.processKeyEvent(keyEvent);
                }
                this.mw.checkCaret();
                return;
            }
            if (n2 == 40 || n2 == 39 || n2 == 225 || n2 == 227) {
                int n16 = this.getSelectionEnd();
                if (n16 != (n = this.getSelectionStart())) {
                    this.setCaretPosition(n16);
                } else {
                    super.processKeyEvent(keyEvent);
                }
                this.mw.checkCaret();
                return;
            }
        }
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isActionKey() && n2 == 0 && keyEvent.getModifiers() != CTRL_KEY_MASK) {
            this.checkSpelling(false);
        }
    }

    public synchronized void checkSpelling(boolean bl) {
        if (!this.mw.autoSpellCheckingOn()) {
            return;
        }
        try {
            int n;
            int n2;
            int n3 = this.getCaretPosition();
            int n4 = this.mw.getTranslationStart();
            int n5 = this.mw.getTranslationEnd();
            if (bl) {
                n2 = n4;
                n = n5;
            } else {
                int n6 = Utilities.getPreviousWord(this, n3);
                int n7 = Utilities.getWordEnd(this, n6);
                int n8 = Utilities.getNextWord(this, n3);
                int n9 = Utilities.getWordEnd(this, n8);
                n2 = n6 < n4 ? n4 : n6;
                n = n9 > n5 ? n5 : n9;
            }
            String string = this.getText(n2, n - n2);
            List list = StaticUtils.tokenizeText(string);
            SpellChecker spellChecker = CommandThread.core.getSpellchecker();
            AttributeSet attributeSet = this.mw.getTranslatedAttributeSet();
            MutableAttributeSet mutableAttributeSet = Styles.applyStyles(attributeSet, Styles.MISSPELLED);
            AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
            abstractDocument.removeUndoableEditListener(this.undoManager);
            abstractDocument.replace(n2, n - n2, string, attributeSet);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Token token = (Token)iterator.next();
                String string2 = token.getTextFromString(string);
                AttributeSet attributeSet2 = !spellChecker.isCorrect(string2) ? mutableAttributeSet : attributeSet;
                abstractDocument.replace(n2 + token.getOffset(), token.getLength(), string2, attributeSet2);
            }
            this.setCaretPosition(n3);
            abstractDocument.addUndoableEditListener(this.undoManager);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public synchronized int getTextLength() {
        return this.textLength;
    }

    public synchronized void removeUpdate(DocumentEvent documentEvent) {
        this.textLength -= documentEvent.getLength();
    }

    public synchronized void insertUpdate(DocumentEvent documentEvent) {
        this.textLength += documentEvent.getLength();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void replaceSelection(String string) {
        this.mw.checkCaret();
        super.replaceSelection(string);
        this.checkSpelling(true);
    }

    private synchronized boolean createSpellCheckerPopUp(Point point) {
        int n = this.viewToModel(point);
        if (!this.mw.autoSpellCheckingOn()) {
            return false;
        }
        if (n < this.mw.getTranslationStart() || n > this.mw.getTranslationEnd()) {
            return false;
        }
        try {
            final int n2 = Utilities.getWordStart(this, n);
            int n3 = Utilities.getWordEnd(this, n);
            final String string = this.getText(n2, n3 - n2);
            SpellChecker spellChecker = CommandThread.core.getSpellchecker();
            final AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
            if (!spellChecker.isCorrect(string)) {
                ArrayList arrayList = spellChecker.suggest(string);
                this.popup = new JPopupMenu();
                for (int i = 0; i < arrayList.size(); ++i) {
                    final String string2 = (String)arrayList.get(i);
                    JMenuItem jMenuItem = this.popup.add(string2);
                    jMenuItem.addActionListener(new ActionListener(){

                        public synchronized void actionPerformed(ActionEvent actionEvent) {
                            try {
                                int n = EditorTextArea.this.getCaretPosition();
                                abstractDocument.replace(n2, string.length(), string2, EditorTextArea.this.mw.getTranslatedAttributeSet());
                                EditorTextArea.this.setCaretPosition(n);
                            }
                            catch (BadLocationException badLocationException) {
                                System.err.println(badLocationException);
                            }
                        }
                    });
                }
                if (arrayList.size() == 0) {
                    JMenuItem jMenuItem = this.popup.add(OStrings.getString("SC_NO_SUGGESTIONS"));
                    jMenuItem.addActionListener(new ActionListener(){

                        public synchronized void actionPerformed(ActionEvent actionEvent) {
                        }
                    });
                }
                this.popup.add(new JSeparator());
                JMenuItem jMenuItem = this.popup.add(OStrings.getString("SC_IGNORE_ALL"));
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        EditorTextArea.this.addIgnoreWord(string, n2, false);
                    }
                });
                jMenuItem = this.popup.add(OStrings.getString("SC_ADD_TO_DICTIONARY"));
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        EditorTextArea.this.addIgnoreWord(string, n2, true);
                    }
                });
                this.popup.show(this, (int)point.getX(), (int)point.getY());
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logRB(IMPOSSIBLE);
            Log.log(badLocationException);
        }
        return true;
    }

    private synchronized void addIgnoreWord(String string, int n, boolean bl) {
        SpellChecker spellChecker = CommandThread.core.getSpellchecker();
        if (bl) {
            spellChecker.learnWord(string);
        } else {
            spellChecker.ignoreWord(string);
        }
        AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
        try {
            abstractDocument.replace(n, string.length(), string, this.mw.getTranslatedAttributeSet());
            int n2 = this.mw.m_segmentStartOffset;
            int n3 = this.mw.getTranslationEnd() - this.mw.getTranslationStart();
            int n4 = this.mw.m_sourceDisplayLength + OConsts.segmentStartStringFull.length() + n3 + OConsts.segmentEndStringFull.length() + 2;
            int n5 = this.mw.m_curEntryNum - this.mw.m_xlFirstEntry;
            DocumentSegment documentSegment = this.mw.m_docSegList[n5];
            documentSegment.length = n4;
            int n6 = 0;
            int n7 = 0;
            for (int i = this.mw.m_xlFirstEntry; i <= this.mw.m_xlLastEntry; ++i) {
                SourceTextEntry sourceTextEntry = CommandThread.core.getSTE(i);
                if (sourceTextEntry.isTranslated() && n6 != n5) {
                    String string2;
                    int n8 = n7;
                    if (this.mw.displaySegmentSources()) {
                        n8 += sourceTextEntry.getSrcText().length() + 1;
                    }
                    if ((string2 = sourceTextEntry.getTranslation()).indexOf(string) != -1) {
                        List list = StaticUtils.tokenizeText(string2);
                        for (int j = 0; j < list.size(); ++j) {
                            Token token = (Token)list.get(j);
                            String string3 = token.getTextFromString(string2);
                            if (!string3.equals(string)) continue;
                            abstractDocument.replace(n8 + token.getOffset(), string.length(), string, this.mw.getTranslatedAttributeSet());
                        }
                    }
                }
                n7 += this.mw.m_docSegList[n6++].length;
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logRB(IMPOSSIBLE);
            Log.log(badLocationException);
        }
    }

    private synchronized boolean createGoToSegmentPopUp(Point point) {
        final int n = this.viewToModel(point);
        if (n >= this.mw.getTranslationStart() - OConsts.segmentStartStringFull.length() && n <= this.mw.getTranslationEnd() + OConsts.segmentStartStringFull.length()) {
            return false;
        }
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = this.popup.add(OStrings.getString("MW_PROMPT_SEG_NR_TITLE"));
        jMenuItem.addActionListener(new ActionListener(){

            public synchronized void actionPerformed(ActionEvent actionEvent) {
                EditorTextArea.this.setCaretPosition(n);
                EditorTextArea.this.goToSegmentAtCaretLocation();
            }
        });
        this.popup.show(this, (int)point.getX(), (int)point.getY());
        return true;
    }

    private synchronized void goToSegmentAtCaretLocation() {
        block3: {
            int n;
            block2: {
                n = this.getCaretPosition();
                if (n >= this.mw.m_segmentStartOffset) break block2;
                int n2 = 0;
                for (int i = this.mw.m_xlFirstEntry; i < this.mw.m_curEntryNum; ++i) {
                    DocumentSegment documentSegment = this.mw.m_docSegList[i - this.mw.m_xlFirstEntry];
                    if (n >= (n2 += documentSegment.length)) continue;
                    this.mw.doGotoEntry(i + 1);
                    return;
                }
                break block3;
            }
            if (n <= this.getTextLength() - this.mw.m_segmentEndInset) break block3;
            int n3 = this.getTextLength() - this.mw.m_segmentEndInset;
            for (int i = this.mw.m_curEntryNum + 1; i <= this.mw.m_xlLastEntry; ++i) {
                DocumentSegment documentSegment = this.mw.m_docSegList[i - this.mw.m_xlFirstEntry];
                if (n > (n3 += documentSegment.length)) continue;
                this.mw.doGotoEntry(i + 1);
                return;
            }
        }
    }

    public synchronized void changeCase(int n) {
        int n2 = this.getSelectionStart();
        int n3 = this.getSelectionEnd();
        int n4 = this.getCaretPosition();
        int n5 = this.mw.getTranslationStart();
        int n6 = this.mw.getTranslationEnd();
        if (n3 < n5 || n2 > n6) {
            return;
        }
        if (n2 < n5 && n3 <= n6) {
            n2 = n5;
        }
        if (n3 > n6 && n2 >= n5) {
            n3 = n6;
        }
        try {
            int n7;
            int n8;
            if (n2 == n3) {
                n2 = Utilities.getWordStart(this, n2);
                n3 = Utilities.getWordEnd(this, n3);
            }
            this.setSelectionStart(n2);
            this.setSelectionEnd(n3);
            String string = this.getText(n2, n3 - n2);
            List list = StaticUtils.tokenizeText(string);
            StringBuffer stringBuffer = new StringBuffer(string);
            if (n == 0) {
                n8 = 0;
                n7 = 0;
                int n9 = 0;
                int n10 = 0;
                for (int i = 0; i < list.size(); ++i) {
                    Token token = (Token)list.get(i);
                    String string2 = token.getTextFromString(string);
                    if (this.isLowerCase(string2)) {
                        ++n8;
                        continue;
                    }
                    if (this.isTitleCase(string2)) {
                        ++n9;
                        continue;
                    }
                    if (this.isUpperCase(string2)) {
                        ++n7;
                        continue;
                    }
                    ++n10;
                }
                if (n8 == 0 && n9 == 0 && n7 == 0 && n10 == 0) {
                    return;
                }
                if (n8 != 0 && n9 == 0 && n7 == 0) {
                    n = 2;
                }
                if (n8 == 0 && n9 != 0 && n7 == 0) {
                    n = 3;
                }
                if (n8 == 0 && n9 == 0 && n7 != 0) {
                    n = 1;
                }
                if (n10 != 0) {
                    n = 3;
                }
            }
            n8 = 0;
            for (n7 = 0; n7 < list.size(); ++n7) {
                Token token = (Token)list.get(n7);
                String string3 = this.doChangeCase(token.getTextFromString(string), n);
                stringBuffer.replace(token.getOffset() + n8, token.getLength() + token.getOffset() + n8, string3);
                n8 += string3.length() - token.getLength();
            }
            this.replaceSelection(stringBuffer.toString());
            this.setCaretPosition(n4);
            this.setSelectionStart(n2);
            this.setSelectionEnd(n3);
        }
        catch (BadLocationException badLocationException) {
            Log.log("bad location exception when changing case");
            Log.log(badLocationException);
        }
    }

    private String doChangeCase(String string, int n) {
        Locale locale = CommandThread.core.getProjectProperties().getTargetLanguage().getLocale();
        switch (n) {
            case 1: {
                return string.toLowerCase(locale);
            }
            case 3: {
                return string.toUpperCase(locale);
            }
            case 2: {
                return Character.toTitleCase(string.charAt(0)) + string.substring(1).toLowerCase(locale);
            }
        }
        return string.toUpperCase(locale);
    }

    private boolean isLowerCase(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetter(c) || Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isUpperCase(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetter(c) || Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isTitleCase(String string) {
        if (string.length() > 1) {
            return Character.isTitleCase(string.charAt(0)) && this.isLowerCase(string.substring(1));
        }
        return Character.isTitleCase(string.charAt(0));
    }
}

