/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeListener;
import com.vlsolutions.swing.docking.ui.DockingUISettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.roydesign.mac.MRJAdapter;
import org.omegat.core.ProjectProperties;
import org.omegat.core.StringEntry;
import org.omegat.core.matching.NearString;
import org.omegat.core.matching.SourceTextEntry;
import org.omegat.core.spellchecker.SpellChecker;
import org.omegat.core.threads.CommandThread;
import org.omegat.core.threads.DialogThread;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.gui.HelpFrame;
import org.omegat.gui.ProjectFrame;
import org.omegat.gui.SearchWindow;
import org.omegat.gui.TagValidationFrame;
import org.omegat.gui.dialogs.AboutDialog;
import org.omegat.gui.dialogs.FontSelectionDialog;
import org.omegat.gui.dialogs.SpellcheckerConfigurationDialog;
import org.omegat.gui.dialogs.WorkflowOptionsDialog;
import org.omegat.gui.filters2.FiltersCustomizer;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.DocumentSegment;
import org.omegat.gui.main.EditorTextArea;
import org.omegat.gui.main.GlossaryTextArea;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.main.MatchesTextArea;
import org.omegat.gui.main.SegmentHistory;
import org.omegat.gui.segmentation.SegmentationCustomizer;
import org.omegat.util.LFileCopy;
import org.omegat.util.Log;
import org.omegat.util.OConsts;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.RequestPacket;
import org.omegat.util.StaticUtils;
import org.omegat.util.Token;
import org.omegat.util.WikiGet;
import org.omegat.util.gui.OmegaTFileChooser;
import org.omegat.util.gui.Styles;
import org.openide.awt.Mnemonics;

public class MainWindow
extends JFrame
implements ActionListener,
WindowListener,
ComponentListener {
    private boolean layoutInitialized = false;
    private boolean entryActivated = false;
    private static final String IMPOSSIBLE = "Should not have happened, report to http://sf.net/tracker/?group_id=68187&atid=520347";
    public final int WITH_END_MARKERS = 1;
    public final int IS_NOT_TRANSLATED = 2;
    private Font m_font;
    public int m_xlFirstEntry;
    public int m_xlLastEntry;
    public int m_segmentStartOffset;
    public int m_sourceDisplayLength;
    public int m_segmentEndInset;
    private int m_glossaryLength;
    private boolean m_segmentTagHasNumber;
    public boolean m_docReady;
    public DocumentSegment[] m_docSegList;
    public char m_advancer;
    private SourceTextEntry m_curEntry;
    private String m_activeProj;
    public int m_curEntryNum;
    private TagValidationFrame m_tagWin;
    private ProjectFrame m_projWin;
    private AttributeSet m_translatedAttributeSet;
    private AttributeSet m_unTranslatedAttributeSet;
    private boolean m_displaySegmentSources;
    private Set m_searches;
    public boolean m_projectLoaded;
    private boolean m_autoSpellChecking;
    private JMenuItem cycleSwitchCaseMenuItem;
    private JMenuItem editFindInProjectMenuItem;
    private JMenuItem editInsertSourceMenuItem;
    private JMenuItem editInsertTranslationMenuItem;
    private JMenu editMenu;
    private JMenuItem editOverwriteSourceMenuItem;
    private JMenuItem editOverwriteTranslationMenuItem;
    private JMenuItem editRedoMenuItem;
    private JMenuItem editSelectFuzzy1MenuItem;
    private JMenuItem editSelectFuzzy2MenuItem;
    private JMenuItem editSelectFuzzy3MenuItem;
    private JMenuItem editSelectFuzzy4MenuItem;
    private JMenuItem editSelectFuzzy5MenuItem;
    private JMenuItem editUndoMenuItem;
    private JMenuItem gotoHistoryBackMenuItem;
    private JMenuItem gotoHistoryForwardMenuItem;
    private JMenu gotoMenu;
    private JMenuItem gotoNextSegmentMenuItem;
    private JMenuItem gotoNextUntranslatedMenuItem;
    private JMenuItem gotoPreviousSegmentMenuItem;
    private JMenuItem gotoSegmentMenuItem;
    private JMenuItem helpAboutMenuItem;
    private JMenuItem helpContentsMenuItem;
    private JMenu helpMenu;
    private JLabel lengthLabel;
    private JMenuItem lowerCaseMenuItem;
    private JMenuBar mainMenu;
    private JCheckBoxMenuItem optionsAlwaysConfirmQuitCheckBoxMenuItem;
    private JMenuItem optionsFontSelectionMenuItem;
    private JMenu optionsMenu;
    private JMenuItem optionsRestoreGUIMenuItem;
    private JMenuItem optionsSentsegMenuItem;
    private JMenuItem optionsSetupFileFiltersMenuItem;
    private JMenuItem optionsSpellCheckMenuItem;
    private JCheckBoxMenuItem optionsTabAdvanceCheckBoxMenuItem;
    private JMenuItem optionsWorkflowMenuItem;
    private JLabel progressLabel;
    private JMenuItem projectCloseMenuItem;
    private JMenuItem projectCompileMenuItem;
    private JMenuItem projectEditMenuItem;
    private JMenuItem projectExitMenuItem;
    private JMenuItem projectImportMenuItem;
    private JMenu projectMenu;
    private JMenuItem projectNewMenuItem;
    private JMenuItem projectOpenMenuItem;
    private JMenuItem projectReloadMenuItem;
    private JMenuItem projectSaveMenuItem;
    private JMenuItem projectWikiImportMenuItem;
    private JSeparator separator1inEditMenu;
    private JSeparator separator1inOptionsMenu;
    private JSeparator separator1inProjectMenu;
    private JSeparator separator2inEditMenu;
    private JSeparator separator2inProjectMenu;
    private JSeparator separator3inEditMenu;
    private JSeparator separator4inEditMenu;
    private JSeparator separator4inProjectMenu;
    private JSeparator separator5inEditMenu;
    private JSeparator separator5inProjectMenu;
    private JSeparator separatorInGoToMenu;
    private JSeparator separatorInSwitchCaseSubMenu;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JPanel statusPanel2;
    private JMenu switchCaseSubMenu;
    private JMenuItem titleCaseMenuItem;
    private JMenu toolsMenu;
    private JMenuItem toolsValidateTagsMenuItem;
    private JMenuItem upperCaseMenuItem;
    private JCheckBoxMenuItem viewDisplaySegmentSourceCheckBoxMenuItem;
    private JMenuItem viewFileListMenuItem;
    private JCheckBoxMenuItem viewMarkTranslatedSegmentsCheckBoxMenuItem;
    private JCheckBoxMenuItem viewMarkUntranslatedSegmentsCheckBoxMenuItem;
    private JMenu viewMenu;
    private DockingDesktop desktop;
    private DockableScrollPane editorScroller;
    private EditorTextArea editor;
    private DockableScrollPane matchesScroller;
    private MatchesTextArea matches;
    private DockableScrollPane glossaryScroller;
    private GlossaryTextArea glossary;
    private SegmentHistory history = SegmentHistory.getInstance();

    public MainWindow() {
        this.m_searches = new HashSet();
        this.initComponents();
        this.createMainComponents();
        this.initDocking();
        this.additionalUIInit();
        this.oldInit();
        this.loadInstantStart();
    }

    private void createMainComponents() {
        this.editor = new EditorTextArea(this);
        this.matches = new MatchesTextArea(this);
        this.glossary = new GlossaryTextArea();
        String string = Preferences.getPreferenceDefault("source_font", "Dialog");
        int n = Preferences.getPreferenceDefault("source_font_size", 12);
        this.m_font = new Font(string, 0, n);
        this.editor.setFont(this.m_font);
        this.matches.setFont(this.m_font);
        this.glossary.setFont(this.m_font);
        this.m_autoSpellChecking = Preferences.isPreference("allow_auto_spellchecking");
    }

    private ImageIcon getIcon(String string) {
        return new ImageIcon(this.getClass().getResource("/org/omegat/gui/resources/" + string));
    }

    private void initDocking() {
        DockingUISettings.getInstance().installUI();
        UIManager.put("DockViewTitleBar.minimizeButtonText", OStrings.getString("DOCKING_HINT_MINIMIZE"));
        UIManager.put("DockViewTitleBar.maximizeButtonText", OStrings.getString("DOCKING_HINT_MAXIMIZE"));
        UIManager.put("DockViewTitleBar.restoreButtonText", OStrings.getString("DOCKING_HINT_RESTORE"));
        UIManager.put("DockViewTitleBar.attachButtonText", OStrings.getString("DOCKING_HINT_DOCK"));
        UIManager.put("DockViewTitleBar.floatButtonText", OStrings.getString("DOCKING_HINT_UNDOCK"));
        UIManager.put("DockViewTitleBar.closeButtonText", new String());
        UIManager.put("DockTabbedPane.minimizeButtonText", OStrings.getString("DOCKING_HINT_MINIMIZE"));
        UIManager.put("DockTabbedPane.maximizeButtonText", OStrings.getString("DOCKING_HINT_MAXIMIZE"));
        UIManager.put("DockTabbedPane.restoreButtonText", OStrings.getString("DOCKING_HINT_RESTORE"));
        UIManager.put("DockTabbedPane.floatButtonText", OStrings.getString("DOCKING_HINT_UNDOCK"));
        UIManager.put("DockTabbedPane.closeButtonText", new String());
        UIManager.put("DockViewTitleBar.titleFont", new JLabel().getFont());
        UIManager.put("DockViewTitleBar.isCloseButtonDisplayed", Boolean.FALSE);
        UIManager.put("DockViewTitleBar.hide", this.getIcon("minimize.gif"));
        UIManager.put("DockViewTitleBar.hide.rollover", this.getIcon("minimize.rollover.gif"));
        UIManager.put("DockViewTitleBar.hide.pressed", this.getIcon("minimize.pressed.gif"));
        UIManager.put("DockViewTitleBar.maximize", this.getIcon("maximize.gif"));
        UIManager.put("DockViewTitleBar.maximize.rollover", this.getIcon("maximize.rollover.gif"));
        UIManager.put("DockViewTitleBar.maximize.pressed", this.getIcon("maximize.pressed.gif"));
        UIManager.put("DockViewTitleBar.restore", this.getIcon("restore.gif"));
        UIManager.put("DockViewTitleBar.restore.rollover", this.getIcon("restore.rollover.gif"));
        UIManager.put("DockViewTitleBar.restore.pressed", this.getIcon("restore.pressed.gif"));
        UIManager.put("DockViewTitleBar.dock", this.getIcon("restore.gif"));
        UIManager.put("DockViewTitleBar.dock.rollover", this.getIcon("restore.rollover.gif"));
        UIManager.put("DockViewTitleBar.dock.pressed", this.getIcon("restore.pressed.gif"));
        UIManager.put("DockViewTitleBar.float", this.getIcon("undock.gif"));
        UIManager.put("DockViewTitleBar.float.rollover", this.getIcon("undock.rollover.gif"));
        UIManager.put("DockViewTitleBar.float.pressed", this.getIcon("undock.pressed.gif"));
        UIManager.put("DockViewTitleBar.attach", this.getIcon("dock.gif"));
        UIManager.put("DockViewTitleBar.attach.rollover", this.getIcon("dock.rollover.gif"));
        UIManager.put("DockViewTitleBar.attach.pressed", this.getIcon("dock.pressed.gif"));
        UIManager.put("DockViewTitleBar.menu.hide", this.getIcon("minimize.gif"));
        UIManager.put("DockViewTitleBar.menu.maximize", this.getIcon("maximize.gif"));
        UIManager.put("DockViewTitleBar.menu.restore", this.getIcon("restore.gif"));
        UIManager.put("DockViewTitleBar.menu.dock", this.getIcon("restore.gif"));
        UIManager.put("DockViewTitleBar.menu.float", this.getIcon("undock.gif"));
        UIManager.put("DockViewTitleBar.menu.attach", this.getIcon("dock.gif"));
        UIManager.put("DockViewTitleBar.menu.close", this.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.close", this.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.close.rollover", this.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.close.pressed", this.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.close", this.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.hide", this.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.maximize", this.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.float", this.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.closeAll", this.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.closeAllOther", this.getIcon("empty.gif"));
        UIManager.put("DockingDesktop.closeActionAccelerator", null);
        UIManager.put("DockingDesktop.maximizeActionAccelerator", null);
        UIManager.put("DockingDesktop.dockActionAccelerator", null);
        UIManager.put("DockingDesktop.floatActionAccelerator", null);
        UIManager.put("DragControler.detachCursor", this.getIcon("undock.gif").getImage());
        this.editorScroller = new DockableScrollPane("EDITOR", " ", this.editor, false);
        this.editorScroller.setMinimumSize(new Dimension(100, 100));
        this.matchesScroller = new DockableScrollPane("MATCHES", OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Fuzzy_Matches"), this.matches, true);
        this.glossaryScroller = new DockableScrollPane("GLOSSARY", OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Glossary"), this.glossary, true);
        this.desktop = new DockingDesktop();
        this.desktop.addDockableStateWillChangeListener(new DockableStateWillChangeListener(){

            public void dockableStateWillChange(DockableStateWillChangeEvent dockableStateWillChangeEvent) {
                if (dockableStateWillChangeEvent.getFutureState().isClosed()) {
                    dockableStateWillChangeEvent.cancel();
                }
            }
        });
        this.desktop.addDockable((Dockable)this.editorScroller);
        this.desktop.split((Dockable)this.editorScroller, (Dockable)this.matchesScroller, DockingConstants.SPLIT_RIGHT);
        this.desktop.split((Dockable)this.matchesScroller, (Dockable)this.glossaryScroller, DockingConstants.SPLIT_BOTTOM);
        this.desktop.setDockableWidth((Dockable)this.editorScroller, 0.6);
        this.desktop.setDockableHeight((Dockable)this.matchesScroller, 0.7);
        this.getContentPane().add((Component)this.desktop, "Center");
    }

    private void additionalUIInit() {
        this.updateTitle();
        this.loadWindowIcon();
        this.m_projWin = new ProjectFrame(this);
        this.m_projWin.setFont(this.m_font);
        this.statusLabel.setText(new String() + ' ');
        this.loadScreenLayout();
        this.updateCheckboxesOnStart();
        this.uiUpdateOnProjectClose();
        this.initUIShortcuts();
        try {
            MRJAdapter.addQuitApplicationListener((ActionListener)new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.doQuit();
                }
            });
            MRJAdapter.addAboutListener((ActionListener)new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.doAbout();
                }
            });
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Log.log(noClassDefFoundError);
        }
        if (!StaticUtils.onMacOSX()) {
            this.projectMenu.add(this.separator2inProjectMenu);
            this.projectMenu.add(this.projectExitMenuItem);
        }
    }

    private void loadWindowIcon() {
        try {
            URL uRL = this.getClass().getResource("/org/omegat/gui/resources/OmegaT_small.gif");
            ImageIcon imageIcon = new ImageIcon(uRL);
            Image image = imageIcon.getImage();
            this.setIconImage(image);
        }
        catch (Exception exception) {
            Log.log(exception);
        }
    }

    private void initUIShortcuts() {
        this.setAccelerator(this.projectOpenMenuItem, 79);
        this.setAccelerator(this.projectSaveMenuItem, 83);
        this.setAccelerator(this.projectEditMenuItem, 69);
        this.setAccelerator(this.projectExitMenuItem, 81);
        this.setAccelerator(this.editUndoMenuItem, 90);
        this.setAccelerator(this.editRedoMenuItem, 89);
        this.setAccelerator(this.editOverwriteTranslationMenuItem, 82);
        this.setAccelerator(this.editInsertTranslationMenuItem, 73);
        this.setAccelerator(this.editOverwriteSourceMenuItem, 82, true);
        this.setAccelerator(this.editInsertSourceMenuItem, 73, true);
        this.setAccelerator(this.editFindInProjectMenuItem, 70);
        this.setAccelerator(this.editSelectFuzzy1MenuItem, 49);
        this.setAccelerator(this.editSelectFuzzy2MenuItem, 50);
        this.setAccelerator(this.editSelectFuzzy3MenuItem, 51);
        this.setAccelerator(this.editSelectFuzzy4MenuItem, 52);
        this.setAccelerator(this.editSelectFuzzy5MenuItem, 53);
        this.setAccelerator(this.gotoNextUntranslatedMenuItem, 85);
        this.setAccelerator(this.gotoNextSegmentMenuItem, 78);
        this.setAccelerator(this.gotoPreviousSegmentMenuItem, 80);
        this.setAccelerator(this.gotoSegmentMenuItem, 74);
        this.setAccelerator(this.gotoHistoryForwardMenuItem, 78, true);
        this.setAccelerator(this.gotoHistoryBackMenuItem, 80, true);
        this.setAccelerator(this.viewFileListMenuItem, 76);
        this.setAccelerator(this.toolsValidateTagsMenuItem, 84);
    }

    private void setAccelerator(JMenuItem jMenuItem, int n) {
        this.setAccelerator(jMenuItem, n, false);
    }

    private void setAccelerator(JMenuItem jMenuItem, int n, boolean bl) {
        int n2 = bl ? 1 : 0;
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, n2 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    private void updateTitle() {
        String string = OStrings.getDisplayVersion();
        if (this.isProjectLoaded()) {
            string = string + " :: " + this.m_activeProj;
            try {
                String string2 = this.getActiveFileName();
                this.editorScroller.setName(StaticUtils.format(OStrings.getString("GUI_SUBWINDOWTITLE_Editor"), new Object[]{string2}));
            }
            catch (Exception exception) {}
        } else {
            this.loadInstantStart();
        }
        this.setTitle(string);
    }

    public void oldInit() {
        this.m_curEntryNum = -1;
        this.m_activeProj = new String();
        this.enableEvents(0L);
        String string = OConsts.segmentStartStringFull;
        int n = string.lastIndexOf(48);
        this.m_segmentTagHasNumber = n > 4 && string.charAt(n - 1) == '0' && string.charAt(n - 2) == '0' && string.charAt(n - 3) == '0';
    }

    private void updateCheckboxesOnStart() {
        if (Preferences.isPreference("tab_advance")) {
            this.optionsTabAdvanceCheckBoxMenuItem.setSelected(true);
            this.m_advancer = (char)9;
        } else {
            this.m_advancer = (char)10;
        }
        this.optionsAlwaysConfirmQuitCheckBoxMenuItem.setSelected(Preferences.isPreference("always_confirm_quit"));
        if (Preferences.isPreference("mark_translated_segments")) {
            this.viewMarkTranslatedSegmentsCheckBoxMenuItem.setSelected(true);
            this.m_translatedAttributeSet = Styles.TRANSLATED;
        } else if (Preferences.isPreference("mark_untranslated_segments")) {
            this.viewMarkUntranslatedSegmentsCheckBoxMenuItem.setSelected(true);
            this.m_unTranslatedAttributeSet = Styles.UNTRANSLATED;
        } else {
            this.m_translatedAttributeSet = Styles.PLAIN;
            this.m_unTranslatedAttributeSet = Styles.PLAIN;
        }
        if (Preferences.isPreference("display_segment_sources")) {
            this.viewDisplaySegmentSourceCheckBoxMenuItem.setSelected(true);
            this.m_displaySegmentSources = true;
        }
    }

    private void loadScreenLayout() {
        Object object;
        String string;
        try {
            string = Preferences.getPreference("screen_x");
            object = Preferences.getPreference("screen_y");
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt((String)object);
            this.setLocation(n, n2);
            String string2 = Preferences.getPreference("screen_width");
            String string3 = Preferences.getPreference("screen_height");
            int n3 = Integer.parseInt(string2);
            int n4 = Integer.parseInt(string3);
            this.setSize(n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            object = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Rectangle rectangle = ((GraphicsEnvironment)object).getMaximumWindowBounds();
            if (rectangle.width < 900) {
                this.setSize(580, 536);
                this.setLocation(0, 0);
            }
            this.setSize(690, 700);
            this.setLocation(0, 0);
        }
        string = Preferences.getPreference("docking_layout");
        if (string.length() > 0) {
            object = StaticUtils.uudecode(string);
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                this.desktop.readXML((InputStream)byteArrayInputStream);
                byteArrayInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.layoutInitialized = true;
    }

    public void filelistWindowClosed() {
    }

    private void loadInstantStart() {
        try {
            String string = this.detectInstantStartLanguage();
            String string2 = StaticUtils.installDir() + File.separator + "docs" + File.separator + string + File.separator + "instantStartGuideNoTOC.html";
            JTextPane jTextPane = new JTextPane();
            jTextPane.setEditable(false);
            jTextPane.setPage("file:///" + string2);
            this.editorScroller.setViewportView(jTextPane);
            this.editorScroller.setName(OStrings.getString("DOCKING_INSTANT_START_TITLE"));
        }
        catch (IOException iOException) {
            this.editorScroller.setViewportView(this.editor);
        }
    }

    private String detectInstantStartLanguage() {
        String string = Locale.getDefault().getLanguage().toLowerCase();
        String string2 = Locale.getDefault().getCountry().toUpperCase();
        File file = new File(StaticUtils.installDir() + File.separator + "docs" + File.separator + string + "_" + string2 + File.separator + "instantStartGuideNoTOC.html");
        if (file.exists()) {
            return string + "_" + string2;
        }
        file = new File(StaticUtils.installDir() + File.separator + "docs" + File.separator + string + File.separator + "instantStartGuideNoTOC.html");
        if (file.exists()) {
            return string;
        }
        return "en";
    }

    public void saveScreenLayout() {
        if (!this.layoutInitialized) {
            return;
        }
        Preferences.setPreference("screen_width", this.getWidth());
        Preferences.setPreference("screen_height", this.getHeight());
        Preferences.setPreference("screen_x", this.getX());
        Preferences.setPreference("screen_y", this.getY());
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.desktop.writeXML((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            String string = StaticUtils.uuencode(byArray);
            Preferences.setPreference("docking_layout", string);
        }
        catch (Exception exception) {
            Preferences.setPreference("docking_layout", new String());
        }
    }

    private void doAbout() {
        new AboutDialog(this).setVisible(true);
    }

    private void doQuit() {
        boolean bl = false;
        if (this.isProjectLoaded()) {
            bl = CommandThread.core.isProjectModified();
        }
        if ((bl || Preferences.isPreference("always_confirm_quit")) && 0 != JOptionPane.showConfirmDialog(this, OStrings.getString("MW_QUIT_CONFIRM"), OStrings.getString("CONFIRM_DIALOG_TITLE"), 0)) {
            return;
        }
        this.saveScreenLayout();
        Preferences.save();
        if (this.isProjectLoaded()) {
            this.doSave();
        }
        if (CommandThread.core != null) {
            CommandThread.core.interrupt();
        }
        for (int i = 0; i < 600 && CommandThread.core != null; ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.exit(0);
    }

    private void doValidateTags() {
        ArrayList arrayList = CommandThread.core.validateTags();
        if (arrayList.size() > 0) {
            if (this.m_tagWin == null) {
                this.m_tagWin = new TagValidationFrame(this);
                this.m_tagWin.addWindowListener(this);
                this.m_tagWin.setFont(this.m_font);
            } else {
                this.m_tagWin.dispose();
            }
            this.m_tagWin.setVisible(true);
            this.m_tagWin.displayStringList(arrayList);
        } else {
            if (this.m_tagWin != null) {
                this.m_tagWin.dispose();
            }
            JOptionPane.showMessageDialog(this, OStrings.getString("TF_NOTICE_OK_TAGS"), OStrings.getString("TF_NOTICE_TITLE_TAGS"), 1);
        }
    }

    public synchronized void doNextEntry() {
        if (!this.isProjectLoaded()) {
            return;
        }
        this.commitEntry();
        ++this.m_curEntryNum;
        if (this.m_curEntryNum > this.m_xlLastEntry) {
            if (this.m_curEntryNum >= CommandThread.core.numEntries()) {
                this.m_curEntryNum = 0;
            }
            this.loadDocument();
        }
        this.activateEntry();
    }

    public synchronized void doPrevEntry() {
        if (!this.isProjectLoaded()) {
            return;
        }
        this.commitEntry();
        --this.m_curEntryNum;
        if (this.m_curEntryNum < this.m_xlFirstEntry) {
            if (this.m_curEntryNum < 0) {
                this.m_curEntryNum = CommandThread.core.numEntries() - 1;
            }
            if (this.m_curEntryNum < 0) {
                this.m_curEntryNum = 0;
            }
            this.loadDocument();
        }
        this.activateEntry();
    }

    private synchronized void doNextUntranslatedEntry() {
        SourceTextEntry sourceTextEntry;
        int n;
        if (!this.isProjectLoaded()) {
            return;
        }
        this.commitEntry();
        int n2 = CommandThread.core.numEntries();
        boolean bl = false;
        for (n = this.m_curEntryNum + 1; n < n2; ++n) {
            sourceTextEntry = CommandThread.core.getSTE(n);
            if (sourceTextEntry == null || sourceTextEntry.getTranslation().length() != 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (n = 0; n < this.m_curEntryNum; ++n) {
                sourceTextEntry = CommandThread.core.getSTE(n);
                if (sourceTextEntry == null || sourceTextEntry.getTranslation().length() != 0) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.m_curEntryNum = n;
            if (this.m_curEntryNum < this.m_xlFirstEntry || this.m_curEntryNum > this.m_xlLastEntry) {
                this.loadDocument();
            }
        }
        this.activateEntry();
    }

    private synchronized void doInsertSource() {
        if (!this.isProjectLoaded()) {
            return;
        }
        this.doInsertText(this.m_curEntry.getSrcText());
    }

    private synchronized void doOverwriteSource() {
        if (!this.isProjectLoaded()) {
            return;
        }
        this.doReplaceEditText(this.m_curEntry.getSrcText());
    }

    public synchronized void doInsertTrans() {
        if (!this.isProjectLoaded()) {
            return;
        }
        int n = this.matches.getActiveMatch();
        if (n < 0) {
            return;
        }
        if (n >= this.m_curEntry.getStrEntry().getNearListTranslated().size()) {
            return;
        }
        NearString nearString = (NearString)this.m_curEntry.getStrEntry().getNearListTranslated().get(n);
        this.doInsertText(nearString.str.getTranslation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doInsertText(String string) {
        EditorTextArea editorTextArea = this.editor;
        synchronized (editorTextArea) {
            this.editor.replaceSelection(string);
        }
    }

    public synchronized void doRecycleTrans() {
        if (!this.isProjectLoaded()) {
            return;
        }
        int n = this.matches.getActiveMatch();
        if (n < 0) {
            return;
        }
        if (n >= this.m_curEntry.getStrEntry().getNearListTranslated().size()) {
            return;
        }
        NearString nearString = (NearString)this.m_curEntry.getStrEntry().getNearListTranslated().get(n);
        this.doReplaceEditText(nearString.str.getTranslation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doReplaceEditText(String string) {
        EditorTextArea editorTextArea = this.editor;
        synchronized (editorTextArea) {
            int n = this.getTranslationStart();
            int n2 = this.getTranslationEnd();
            this.editor.select(n, n2);
            this.editor.replaceSelection(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCloseProject() {
        Preferences.save();
        if (this.isProjectLoaded()) {
            this.doSave();
        }
        this.m_projWin.reset();
        MainWindow mainWindow = this;
        synchronized (mainWindow) {
            this.m_projectLoaded = false;
        }
        mainWindow = this;
        synchronized (mainWindow) {
            this.editor.setText(OStrings.getString("TF_INTRO_MESSAGE"));
        }
        this.matches.clear();
        this.glossary.clear();
        this.updateTitle();
        this.uiUpdateOnProjectClose();
        CommandThread.core.signalProjectClosing();
        CommandThread.core.cleanUp();
        this.progressLabel.setText(OStrings.getString("MW_PROGRESS_DEFAULT"));
        this.setLengthLabel(OStrings.getString("MW_SEGMENT_LENGTH_DEFAULT"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uiUpdateOnProjectClose() {
        this.projectNewMenuItem.setEnabled(true);
        this.projectOpenMenuItem.setEnabled(true);
        this.projectImportMenuItem.setEnabled(false);
        this.projectWikiImportMenuItem.setEnabled(false);
        this.projectReloadMenuItem.setEnabled(false);
        this.projectCloseMenuItem.setEnabled(false);
        this.projectSaveMenuItem.setEnabled(false);
        this.projectEditMenuItem.setEnabled(false);
        this.projectCompileMenuItem.setEnabled(false);
        this.editMenu.setEnabled(false);
        this.editFindInProjectMenuItem.setEnabled(false);
        this.editInsertSourceMenuItem.setEnabled(false);
        this.editInsertTranslationMenuItem.setEnabled(false);
        this.editOverwriteSourceMenuItem.setEnabled(false);
        this.editOverwriteTranslationMenuItem.setEnabled(false);
        this.editRedoMenuItem.setEnabled(false);
        this.editSelectFuzzy1MenuItem.setEnabled(false);
        this.editSelectFuzzy2MenuItem.setEnabled(false);
        this.editSelectFuzzy3MenuItem.setEnabled(false);
        this.editSelectFuzzy4MenuItem.setEnabled(false);
        this.editSelectFuzzy5MenuItem.setEnabled(false);
        this.editUndoMenuItem.setEnabled(false);
        this.gotoMenu.setEnabled(false);
        this.gotoNextSegmentMenuItem.setEnabled(false);
        this.gotoNextUntranslatedMenuItem.setEnabled(false);
        this.gotoPreviousSegmentMenuItem.setEnabled(false);
        this.gotoSegmentMenuItem.setEnabled(false);
        this.viewFileListMenuItem.setEnabled(false);
        this.toolsValidateTagsMenuItem.setEnabled(false);
        this.switchCaseSubMenu.setEnabled(false);
        Object object = this.editor;
        synchronized (object) {
            this.editor.setEditable(false);
        }
        this.m_projWin.uiUpdateImportButtonStatus();
        this.m_projWin.setVisible(false);
        if (this.m_tagWin != null) {
            this.m_tagWin.dispose();
        }
        object = this.m_searches.iterator();
        while (object.hasNext()) {
            SearchWindow searchWindow = (SearchWindow)object.next();
            searchWindow.dispose();
        }
        this.m_searches.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uiUpdateOnProjectOpen() {
        this.projectNewMenuItem.setEnabled(false);
        this.projectOpenMenuItem.setEnabled(false);
        this.projectImportMenuItem.setEnabled(true);
        this.projectWikiImportMenuItem.setEnabled(true);
        this.projectReloadMenuItem.setEnabled(true);
        this.projectCloseMenuItem.setEnabled(true);
        this.projectSaveMenuItem.setEnabled(true);
        this.projectEditMenuItem.setEnabled(true);
        this.projectCompileMenuItem.setEnabled(true);
        this.editMenu.setEnabled(true);
        this.editFindInProjectMenuItem.setEnabled(true);
        this.editInsertSourceMenuItem.setEnabled(true);
        this.editInsertTranslationMenuItem.setEnabled(true);
        this.editOverwriteSourceMenuItem.setEnabled(true);
        this.editOverwriteTranslationMenuItem.setEnabled(true);
        this.editRedoMenuItem.setEnabled(true);
        this.editSelectFuzzy1MenuItem.setEnabled(true);
        this.editSelectFuzzy2MenuItem.setEnabled(true);
        this.editSelectFuzzy3MenuItem.setEnabled(true);
        this.editSelectFuzzy4MenuItem.setEnabled(true);
        this.editSelectFuzzy5MenuItem.setEnabled(true);
        this.editUndoMenuItem.setEnabled(true);
        this.gotoMenu.setEnabled(true);
        this.gotoNextSegmentMenuItem.setEnabled(true);
        this.gotoNextUntranslatedMenuItem.setEnabled(true);
        this.gotoPreviousSegmentMenuItem.setEnabled(true);
        this.gotoSegmentMenuItem.setEnabled(true);
        this.viewFileListMenuItem.setEnabled(true);
        this.toolsValidateTagsMenuItem.setEnabled(true);
        this.switchCaseSubMenu.setEnabled(true);
        EditorTextArea editorTextArea = this.editor;
        synchronized (editorTextArea) {
            this.editor.setEditable(true);
        }
        this.updateTitle();
        this.m_projWin.buildDisplay();
        this.m_projWin.uiUpdateImportButtonStatus();
        this.m_projWin.setVisible(true);
    }

    public synchronized void projectLoaded() {
        Thread thread = new Thread(){

            public void run() {
                MainWindow.this.updateFuzzyInfo();
                MainWindow.this.updateGlossaryInfo();
            }
        };
        SwingUtilities.invokeLater(thread);
    }

    private void doEditProject() {
        int n;
        ProjectProperties projectProperties = CommandThread.core.getProjectProperties();
        boolean bl = false;
        try {
            bl = projectProperties.editProject(this);
        }
        catch (IOException iOException) {
            this.displayWarning(OStrings.getString("MW_ERROR_PROJECT_NOT_EDITABLE"), iOException);
        }
        if (bl && (n = JOptionPane.showConfirmDialog(this, OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0)) == 0) {
            this.doReloadProject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFont() {
        FontSelectionDialog fontSelectionDialog = new FontSelectionDialog((Frame)this, this.m_font);
        fontSelectionDialog.setVisible(true);
        if (fontSelectionDialog.getReturnStatus() == 1) {
            this.commitEntry(false);
            this.m_font = fontSelectionDialog.getSelectedFont();
            EditorTextArea editorTextArea = this.editor;
            synchronized (editorTextArea) {
                this.editor.setFont(this.m_font);
            }
            this.matches.setFont(this.m_font);
            this.glossary.setFont(this.m_font);
            if (this.m_tagWin != null) {
                this.m_tagWin.setFont(this.m_font);
            }
            if (this.m_projWin != null) {
                this.m_projWin.setFont(this.m_font);
            }
            Preferences.setPreference("source_font", this.m_font.getName());
            Preferences.setPreference("source_font_size", this.m_font.getSize());
            this.activateEntry();
        }
    }

    private void setupFilters() {
        FiltersCustomizer filtersCustomizer = new FiltersCustomizer(this);
        filtersCustomizer.setVisible(true);
        if (filtersCustomizer.getReturnStatus() == 1) {
            int n;
            FilterMaster.getInstance().saveConfig();
            if (this.isProjectLoaded() && (n = JOptionPane.showConfirmDialog(this, OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0)) == 0) {
                this.doReloadProject();
            }
        } else {
            FilterMaster.getInstance().loadConfig();
        }
    }

    private void setupSegmentation() {
        int n;
        SegmentationCustomizer segmentationCustomizer = new SegmentationCustomizer(this);
        segmentationCustomizer.setVisible(true);
        if (segmentationCustomizer.getReturnStatus() == 1 && this.isProjectLoaded() && (n = JOptionPane.showConfirmDialog(this, OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0)) == 0) {
            this.doReloadProject();
        }
    }

    private void setupWorkflow() {
        new WorkflowOptionsDialog(this).setVisible(true);
    }

    private void doSave() {
        if (!this.isProjectLoaded()) {
            return;
        }
        this.setMessageText(OStrings.getString("MW_STATUS_SAVING"));
        CommandThread.core.save();
        this.setMessageText(OStrings.getString("MW_STATUS_SAVED"));
    }

    private void doCreateProject() {
        CommandThread.core.createProject();
        try {
            String string = CommandThread.core.getProjectProperties().getProjectRoot();
            if (new File(string).exists()) {
                this.doLoadProject(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doLoadProject() {
        if (this.isProjectLoaded()) {
            this.displayError("Please close the project first!", new Exception("Another project is open"));
            return;
        }
        this.matches.clear();
        this.glossary.clear();
        this.history.clear();
        this.editorScroller.setViewportView(this.editor);
        RequestPacket requestPacket = new RequestPacket(2, this);
        CommandThread.core.messageBoardPost(requestPacket);
    }

    public void doLoadProject(String string) {
        if (this.isProjectLoaded()) {
            this.displayError("Please close the project first!", new Exception("Another project is open"));
            return;
        }
        this.matches.clear();
        this.glossary.clear();
        this.history.clear();
        this.editorScroller.setViewportView(this.editor);
        RequestPacket requestPacket = new RequestPacket(2, this, string);
        CommandThread.core.messageBoardPost(requestPacket);
    }

    public void doReloadProject() {
        ProjectProperties projectProperties = CommandThread.core.getProjectProperties();
        String string = projectProperties.getProjectRoot();
        this.doCloseProject();
        this.doLoadProject(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doImportSourceFiles() {
        OmegaTFileChooser omegaTFileChooser = new OmegaTFileChooser();
        omegaTFileChooser.setMultiSelectionEnabled(true);
        omegaTFileChooser.setFileSelectionMode(2);
        int n = omegaTFileChooser.showOpenDialog(this);
        if (n != 0) return;
        String string = CommandThread.core.getProjectProperties().getSourceRoot();
        File file = new File(string);
        File[] fileArray = omegaTFileChooser.getSelectedFiles();
        try {
            int n2 = 0;
            while (true) {
                Serializable serializable;
                if (n2 >= fileArray.length) {
                    this.doReloadProject();
                    return;
                }
                File file2 = fileArray[n2];
                if (file2.isDirectory()) {
                    serializable = new ArrayList();
                    StaticUtils.buildFileList(serializable, file2, true);
                    String string2 = file2.getParent();
                    for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                        String string3 = (String)((ArrayList)serializable).get(i);
                        String string4 = string3.substring(string2.length());
                        File file3 = new File(string3);
                        File file4 = new File(file, string4);
                        LFileCopy.copy(file3, file4);
                    }
                } else {
                    serializable = new File(file, fileArray[n2].getName());
                    LFileCopy.copy(file2, serializable);
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            this.displayError(OStrings.getString("MAIN_ERROR_File_Import_Failed"), iOException);
        }
    }

    public void doWikiImport() {
        String string = JOptionPane.showInputDialog(this, OStrings.getString("TF_WIKI_IMPORT_PROMPT"), OStrings.getString("TF_WIKI_IMPORT_TITLE"), 2);
        String string2 = CommandThread.core.getProjectProperties().getSourceRoot();
        if (string != null && string.trim().length() > 0) {
            WikiGet.doWikiGet(string, string2);
            this.doReloadProject();
        }
    }

    public synchronized void doGotoEntry() {
        final JOptionPane jOptionPane = new JOptionPane(OStrings.getString("MW_PROMPT_SEG_NR_MSG"), -1, 2);
        jOptionPane.setWantsInput(true);
        final JDialog jDialog = new JDialog(this, OStrings.getString("MW_PROMPT_SEG_NR_TITLE"), true);
        jDialog.setContentPane(jOptionPane);
        jOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (jDialog.isVisible() && propertyChangeEvent.getSource() == jOptionPane) {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = jOptionPane.getValue();
                    if (object == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    if (string.equals("inputValue") || string.equals("value") && (Integer)object == 0) {
                        jOptionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                        String string2 = (String)jOptionPane.getInputValue();
                        if (string2 == null || string2.trim().length() == 0) {
                            this.displayErrorMessage();
                            return;
                        }
                        int n = -1;
                        try {
                            n = Integer.parseInt(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.displayErrorMessage();
                            return;
                        }
                        if (n < 1 || n > CommandThread.core.numEntries()) {
                            this.displayErrorMessage();
                            return;
                        }
                    }
                    jDialog.setVisible(false);
                }
            }

            private void displayErrorMessage() {
                JOptionPane.showMessageDialog(jDialog, StaticUtils.format(OStrings.getString("MW_SEGMENT_NUMBER_ERROR"), new Object[]{new Integer(CommandThread.core.numEntries())}), OStrings.getString("TF_ERROR"), 0);
            }
        });
        jDialog.pack();
        jDialog.setLocationRelativeTo(this);
        jDialog.setVisible(true);
        Object object = jOptionPane.getInputValue();
        if (object != null && !object.equals(JOptionPane.UNINITIALIZED_VALUE)) {
            try {
                this.doGotoEntry((String)object);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public synchronized void doGotoEntry(int n) {
        if (!this.isProjectLoaded()) {
            return;
        }
        this.commitEntry();
        this.m_curEntryNum = n - 1;
        if (this.m_curEntryNum < this.m_xlFirstEntry) {
            if (this.m_curEntryNum < 0) {
                this.m_curEntryNum = CommandThread.core.numEntries() - 1;
            }
            if (this.m_curEntryNum < 0) {
                this.m_curEntryNum = 0;
            }
            this.loadDocument();
        } else if (this.m_curEntryNum > this.m_xlLastEntry) {
            if (this.m_curEntryNum >= CommandThread.core.numEntries()) {
                this.m_curEntryNum = 0;
            }
            this.loadDocument();
        }
        this.activateEntry();
    }

    public synchronized void doGotoEntry(String string) {
        try {
            int n = Integer.parseInt(string);
            this.doGotoEntry(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public synchronized void finishLoadProject() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized void run() {
                MainWindow.this.m_activeProj = CommandThread.core.getProjectProperties().getProjectName();
                MainWindow.this.m_curEntryNum = 0;
                MainWindow.this.loadDocument();
                6 var1_1 = this;
                synchronized (var1_1) {
                    MainWindow.this.m_projectLoaded = true;
                }
                MainWindow.this.uiUpdateOnProjectOpen();
            }
        });
    }

    private void doCompileProject() {
        if (!this.isProjectLoaded()) {
            return;
        }
        try {
            CommandThread.core.compileProject();
        }
        catch (IOException iOException) {
            this.displayError(OStrings.getString("TF_COMPILE_ERROR"), iOException);
        }
        catch (TranslationException translationException) {
            this.displayError(OStrings.getString("TF_COMPILE_ERROR"), translationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFind() {
        if (!this.isProjectLoaded()) {
            return;
        }
        EditorTextArea editorTextArea = this.editor;
        synchronized (editorTextArea) {
            String string = this.editor.getSelectedText();
            if (string != null) {
                string.trim();
            }
            SearchWindow searchWindow = new SearchWindow(this, string);
            searchWindow.addWindowListener(this);
            DialogThread dialogThread = new DialogThread(searchWindow);
            dialogThread.start();
            this.m_searches.add(searchWindow);
        }
    }

    public void searchWindowClosed(SearchWindow searchWindow) {
        this.m_searches.remove(searchWindow);
    }

    public void restoreGUI() {
        try {
            String string = "60#63#120#109#108#32#118#101#114#115#105#111#110#61#34#49#46#48#34#63#62#10#60#68#111#99#107#105#110#103#68#101#115#107#116#111#112#32#118#101#114#115#105#111#110#61#34#50#46#48#34#62#10#60#68#111#99#107#105#110#103#80#97#110#101#108#62#10#60#83#112#108#105#116#32#111#114#105#101#110#116#97#116#105#111#110#61#34#49#34#32#108#111#99#97#116#105#111#110#61#34#48#46#53#57#53#51#48#55#57#49#55#56#56#56#53#54#51#49#34#62#10#60#68#111#99#107#97#98#108#101#62#10#60#75#101#121#32#100#111#99#107#78#97#109#101#61#34#69#68#73#84#79#82#34#47#62#10#60#47#68#111#99#107#97#98#108#101#62#10#60#83#112#108#105#116#32#111#114#105#101#110#116#97#116#105#111#110#61#34#48#34#32#108#111#99#97#116#105#111#110#61#34#48#46#54#57#55#52#53#50#50#50#57#50#57#57#51#54#51#34#62#10#60#68#111#99#107#97#98#108#101#62#10#60#75#101#121#32#100#111#99#107#78#97#109#101#61#34#77#65#84#67#72#69#83#34#47#62#10#60#47#68#111#99#107#97#98#108#101#62#10#60#68#111#99#107#97#98#108#101#62#10#60#75#101#121#32#100#111#99#107#78#97#109#101#61#34#71#76#79#83#83#65#82#89#34#47#62#10#60#47#68#111#99#107#97#98#108#101#62#10#60#47#83#112#108#105#116#62#10#60#47#83#112#108#105#116#62#10#60#47#68#111#99#107#105#110#103#80#97#110#101#108#62#10#60#84#97#98#71#114#111#117#112#115#62#10#60#47#84#97#98#71#114#111#117#112#115#62#10#60#47#68#111#99#107#105#110#103#68#101#115#107#116#111#112#62#10";
            byte[] byArray = StaticUtils.uudecode(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.desktop.readXML((InputStream)byteArrayInputStream);
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMessageText(String string) {
        if (string.length() == 0) {
            string = new String() + ' ';
        }
        this.statusLabel.setText(string);
    }

    public void setLengthLabel(String string) {
        this.lengthLabel.setText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadDocument() {
        this.m_docReady = false;
        EditorTextArea editorTextArea = this.editor;
        synchronized (editorTextArea) {
            this.editor.setText(new String());
            if (this.isProjectLoaded()) {
                this.updateTitle();
            }
            this.m_projWin.buildDisplay();
            this.m_curEntry = CommandThread.core.getSTE(this.m_curEntryNum);
            this.m_xlFirstEntry = this.m_curEntry.getFirstInFile();
            this.m_xlLastEntry = this.m_curEntry.getLastInFile();
            int n = 1 + this.m_xlLastEntry - this.m_xlFirstEntry;
            this.m_docSegList = new DocumentSegment[n];
            int n2 = 0;
            AbstractDocument abstractDocument = (AbstractDocument)this.editor.getDocument();
            AttributeSet attributeSet = this.m_translatedAttributeSet;
            AttributeSet attributeSet2 = this.m_unTranslatedAttributeSet;
            if (this.m_displaySegmentSources) {
                attributeSet2 = Styles.GREEN;
            }
            for (int i = 0; i < n; ++i) {
                DocumentSegment documentSegment = new DocumentSegment();
                SourceTextEntry sourceTextEntry = CommandThread.core.getSTE(i + this.m_xlFirstEntry);
                String string = sourceTextEntry.getSrcText();
                String string2 = sourceTextEntry.getTranslation();
                boolean bl = false;
                if (string2.length() == 0) {
                    if (!this.m_displaySegmentSources) {
                        string2 = sourceTextEntry.getSrcText();
                        attributeSet = this.m_unTranslatedAttributeSet;
                    }
                } else {
                    bl = true;
                    attributeSet = this.m_translatedAttributeSet;
                }
                try {
                    if (this.m_displaySegmentSources) {
                        abstractDocument.insertString(n2, string + "\n", attributeSet2);
                        n2 += string.length() + 1;
                    }
                    abstractDocument.insertString(n2, string2, attributeSet);
                    if (bl && this.m_autoSpellChecking) {
                        this.checkSpelling(n2, string2);
                    }
                    abstractDocument.insertString(n2 += string2.length(), "\n\n", Styles.PLAIN);
                    n2 += 2;
                    if (this.m_displaySegmentSources) {
                        string2 = string + "\n" + string2;
                    }
                    string2 = string2 + "\n\n";
                }
                catch (BadLocationException badLocationException) {
                    Log.log(IMPOSSIBLE);
                    Log.log(badLocationException);
                }
                documentSegment.length = string2.length();
                this.m_docSegList[i] = documentSegment;
            }
        }
        Thread.yield();
    }

    private void updateFuzzyInfo() {
        if (!this.isProjectLoaded()) {
            return;
        }
        StringEntry stringEntry = this.m_curEntry.getStrEntry();
        this.matches.setMatches(stringEntry.getNearListTranslated());
    }

    private void updateGlossaryInfo() {
        StringEntry stringEntry = this.m_curEntry.getStrEntry();
        this.glossary.setGlossaryEntries(stringEntry.getGlossaryEntries());
    }

    private synchronized void commitEntry() {
        this.commitEntry(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void commitEntry(boolean bl) {
        if (!this.isProjectLoaded()) {
            return;
        }
        if (!this.entryActivated) {
            return;
        }
        this.entryActivated = false;
        EditorTextArea editorTextArea = this.editor;
        synchronized (editorTextArea) {
            String string;
            String string2;
            AbstractDocument abstractDocument = (AbstractDocument)this.editor.getDocument();
            AttributeSet attributeSet = this.m_translatedAttributeSet;
            int n = this.getTranslationStart();
            int n2 = this.getTranslationEnd();
            boolean bl2 = true;
            ArrayList arrayList = null;
            int n3 = 2;
            if (n == n2) {
                string2 = new String();
                bl2 = false;
                if (!this.m_displaySegmentSources) {
                    string = this.m_curEntry.getSrcText();
                    attributeSet = this.m_unTranslatedAttributeSet;
                } else {
                    string = new String();
                }
            } else {
                try {
                    string2 = abstractDocument.getText(n, n2 - n);
                    if (string2.equals(this.m_curEntry.getSrcText()) && !Preferences.isPreference("wf_allowTransEqualToSrc")) {
                        attributeSet = this.m_unTranslatedAttributeSet;
                        bl2 = false;
                    } else {
                        attributeSet = this.m_translatedAttributeSet;
                        n3 = 0;
                    }
                }
                catch (BadLocationException badLocationException) {
                    Log.log(IMPOSSIBLE);
                    Log.log(badLocationException);
                    string2 = new String();
                    bl2 = false;
                }
                string = string2;
            }
            int n4 = this.m_segmentStartOffset;
            int n5 = this.m_sourceDisplayLength + OConsts.segmentStartStringFull.length() + string2.length() + OConsts.segmentEndStringFull.length() + 2;
            int n6 = this.m_curEntryNum - this.m_xlFirstEntry;
            DocumentSegment documentSegment = this.m_docSegList[n6];
            documentSegment.length = string.length() + "\n\n".length();
            String string3 = null;
            if (this.m_displaySegmentSources) {
                int n7 = this.m_sourceDisplayLength + 1;
                n4 += n7;
                documentSegment.length += n7;
                string3 = this.m_curEntry.getSrcText();
            }
            documentSegment.length = this.replaceEntry(this.m_segmentStartOffset, n5, string3, string, n3);
            if (bl2 && this.m_autoSpellChecking) {
                arrayList = this.checkSpelling(n4, string);
            }
            if (bl) {
                String string4 = this.m_curEntry.getTranslation();
                if (string2.equals(this.m_curEntry.getSrcText()) && !Preferences.isPreference("wf_allowTransEqualToSrc")) {
                    this.m_curEntry.setTranslation(new String());
                } else {
                    this.m_curEntry.setTranslation(string2);
                }
                if (!this.m_curEntry.getTranslation().equals(string4)) {
                    int n8 = 1 + this.m_xlLastEntry - this.m_xlFirstEntry;
                    int[] nArray = new int[n8];
                    int n9 = 0;
                    for (int i = 0; i < n8; ++i) {
                        nArray[i] = n9;
                        documentSegment = this.m_docSegList[i];
                        n9 += documentSegment.length;
                    }
                    Iterator iterator = this.m_curEntry.getStrEntry().getParentList().iterator();
                    while (iterator.hasNext()) {
                        SourceTextEntry sourceTextEntry = (SourceTextEntry)iterator.next();
                        int n10 = sourceTextEntry.entryNum();
                        if (n10 > this.m_xlLastEntry) continue;
                        if (n10 < this.m_xlFirstEntry) break;
                        if (n10 == this.m_curEntryNum) continue;
                        int n11 = n10 - this.m_xlFirstEntry;
                        int n12 = nArray[n11];
                        int n13 = documentSegment.length;
                        documentSegment = this.m_docSegList[n11];
                        documentSegment.length = this.replaceEntry(n12, documentSegment.length, string3, string, n3);
                        int n14 = 0;
                        if (this.m_displaySegmentSources) {
                            n14 = sourceTextEntry.getSrcText().length() + "\n".length();
                        }
                        if (!bl2 || arrayList == null) continue;
                        Iterator iterator2 = arrayList.iterator();
                        while (iterator2.hasNext()) {
                            Token token = (Token)iterator2.next();
                            int n15 = token.getOffset();
                            int n16 = n15 + token.getLength();
                            String string5 = token.getTextFromString(string);
                            try {
                                abstractDocument.replace(n12 + n14 + n15, token.getLength(), string5, Styles.applyStyles(attributeSet, Styles.MISSPELLED));
                            }
                            catch (BadLocationException badLocationException) {
                                Log.log(badLocationException);
                            }
                        }
                    }
                }
            }
            this.editor.cancelUndo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int replaceEntry(int n, int n2, String string, String string2, int n3) {
        EditorTextArea editorTextArea = this.editor;
        synchronized (editorTextArea) {
            AbstractDocument abstractDocument = (AbstractDocument)this.editor.getDocument();
            int n4 = 0;
            AttributeSet attributeSet = (n3 & 2) == 2 ? this.m_unTranslatedAttributeSet : this.m_translatedAttributeSet;
            try {
                String string3;
                abstractDocument.remove(n, n2);
                abstractDocument.insertString(n, "\n\n", Styles.PLAIN);
                n4 = 2;
                if ((n3 & 1) == 1) {
                    string3 = OConsts.segmentEndStringFull;
                    abstractDocument.insertString(n, string3, Styles.PLAIN);
                    abstractDocument.replace(n + string3.indexOf(OConsts.segmentEndString), OConsts.segmentEndString.length(), OConsts.segmentEndString, Styles.BOLD);
                    n4 += string3.length();
                }
                if (string2 != null && !string2.equals("")) {
                    abstractDocument.insertString(n, string2, attributeSet);
                    n4 += string2.length();
                }
                if ((n3 & 1) == 1) {
                    abstractDocument.insertString(n, " ", Styles.PLAIN);
                    string3 = new String(OConsts.segmentStartString);
                    try {
                        if (this.m_segmentTagHasNumber) {
                            String string4 = String.valueOf(this.m_curEntryNum + 1);
                            int n5 = string3.lastIndexOf(48);
                            string3 = string3.substring(0, n5 - string4.length() + 1) + string4 + string3.substring(n5 + 1, string3.length());
                        }
                    }
                    catch (Exception exception) {
                        Log.log("ERROR: exception while putting segment # in start tag:");
                        Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
                        Log.log(exception);
                    }
                    abstractDocument.insertString(n, string3, Styles.BOLD);
                    n4 += string3.length();
                }
                if (string != null) {
                    if ((n3 & 1) != 1) {
                        string = string + "\n";
                    }
                    abstractDocument.insertString(n, string, Styles.GREEN);
                    n4 += string.length();
                }
            }
            catch (BadLocationException badLocationException) {
                Log.log(IMPOSSIBLE);
                Log.log(badLocationException);
            }
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void activateEntry() {
        if (!this.isProjectLoaded()) {
            return;
        }
        int n = 0;
        for (int i = this.m_xlFirstEntry; i <= this.m_xlLastEntry; ++i) {
            if (!CommandThread.core.getSTE(i).isTranslated()) continue;
            ++n;
        }
        this.progressLabel.setText(" " + Integer.toString(n) + "/" + Integer.toString(this.m_xlLastEntry - this.m_xlFirstEntry + 1) + " (" + Integer.toString(CommandThread.core.getNumberofTranslatedSegments()) + "/" + Integer.toString(CommandThread.core.getNumberOfUniqueSegments()) + ", " + Integer.toString(CommandThread.core.getNumberOfSegmentsTotal()) + ") ");
        this.setLengthLabel(" " + Integer.toString(this.m_curEntry.getSrcText().length()) + "/" + Integer.toString(this.m_curEntry.getTranslation().length()) + " ");
        EditorTextArea editorTextArea = this.editor;
        synchronized (editorTextArea) {
            int n2;
            int n3;
            int n4;
            Object[] objectArray;
            this.history.insertNew(this.m_curEntryNum);
            this.gotoHistoryBackMenuItem.setEnabled(this.history.hasPrev());
            this.gotoHistoryForwardMenuItem.setEnabled(this.history.hasNext());
            if (this.m_curEntryNum < this.m_xlFirstEntry) {
                Log.log("ERROR: Current entry # lower than first entry #");
                Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
            }
            if (this.m_curEntryNum > this.m_xlLastEntry) {
                Log.log("ERROR: Current entry # greater than last entry #");
                Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
            }
            this.m_curEntry = CommandThread.core.getSTE(this.m_curEntryNum);
            String string = this.m_curEntry.getSrcText();
            this.m_sourceDisplayLength = string.length();
            this.m_segmentStartOffset = 0;
            int n5 = this.m_curEntryNum - this.m_xlFirstEntry;
            DocumentSegment documentSegment = null;
            try {
                for (int i = 0; i < n5; ++i) {
                    documentSegment = this.m_docSegList[i];
                    this.m_segmentStartOffset += documentSegment.length;
                }
                documentSegment = this.m_docSegList[n5];
            }
            catch (Exception exception) {
                Log.log("ERROR: exception while calculating character offset:");
                Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
                Log.log(exception);
                return;
            }
            this.m_segmentEndInset = this.editor.getTextLength() - (this.m_segmentStartOffset + documentSegment.length - 2);
            String string2 = this.m_curEntry.getTranslation();
            if (string2 == null || string2.length() == 0) {
                string2 = this.m_curEntry.getSrcText();
                if (Preferences.isPreference("wf_noSourceText")) {
                    string2 = new String();
                }
                if (Preferences.isPreference("wf_insertBestMatch")) {
                    String string3 = Preferences.getPreferenceDefault("wf_minimalSimilarity", "80");
                    int n6 = 0;
                    try {
                        n6 = Integer.parseInt(string3);
                    }
                    catch (Exception exception) {
                        Log.log("ERROR: exception while parsing percentage:");
                        Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
                        Log.log(exception);
                        return;
                    }
                    List list = this.m_curEntry.getStrEntry().getNearListTranslated();
                    if (list.size() > 0) {
                        objectArray = (Object[])list.get(0);
                        if (objectArray.score >= n6) {
                            n4 = string2.length();
                            string2 = Preferences.getPreferenceDefault("wf_explanatoryText", OStrings.getString("WF_DEFAULT_PREFIX")) + objectArray.str.getTranslation();
                        }
                    }
                }
            }
            int n7 = this.replaceEntry(this.m_segmentStartOffset, documentSegment.length, string, string2, 1);
            try {
                this.updateFuzzyInfo();
                this.updateGlossaryInfo();
            }
            catch (Exception exception) {
                Log.log("ERROR: exception while updating match and glossary info:");
                Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
                Log.log(exception);
                return;
            }
            StringEntry stringEntry = this.m_curEntry.getStrEntry();
            int n8 = stringEntry.getNearListTranslated().size();
            try {
                if (n8 > 0 && this.m_glossaryLength > 0) {
                    objectArray = new Object[]{new Integer(n8), new Integer(this.m_glossaryLength)};
                    this.setMessageText(StaticUtils.format(OStrings.getString("TF_NUM_NEAR_AND_GLOSSARY"), objectArray));
                } else if (n8 > 0) {
                    objectArray = new Object[]{new Integer(n8)};
                    this.setMessageText(StaticUtils.format(OStrings.getString("TF_NUM_NEAR"), objectArray));
                } else if (this.m_glossaryLength > 0) {
                    objectArray = new Object[]{new Integer(this.m_glossaryLength)};
                    this.setMessageText(StaticUtils.format(OStrings.getString("TF_NUM_GLOSSARY"), objectArray));
                } else {
                    this.setMessageText(new String());
                }
            }
            catch (Exception exception) {
                Log.log("ERROR: exception while setting message text:");
                Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
                Log.log(exception);
                return;
            }
            int n9 = 0;
            n4 = this.m_curEntryNum - this.m_xlFirstEntry;
            try {
                for (n3 = Math.max(0, n4 - 3); n3 < n4; ++n3) {
                    documentSegment = this.m_docSegList[n3];
                    n9 += documentSegment.length;
                }
            }
            catch (Exception exception) {
                Log.log("ERROR: exception while calculating previous offset:");
                Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
                Log.log(exception);
                return;
            }
            n3 = this.m_segmentStartOffset - n9;
            int n10 = 0;
            int n11 = this.m_xlLastEntry - this.m_xlFirstEntry;
            try {
                for (n2 = n4 + 1; n2 < n4 + 4 && n2 <= n11; ++n2) {
                    documentSegment = this.m_docSegList[n2];
                    n10 += documentSegment.length;
                }
            }
            catch (Exception exception) {
                Log.log("ERROR: exception while calculating next offset:");
                Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
                Log.log(exception);
                return;
            }
            n2 = this.m_segmentStartOffset + n7 + n10;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        MainWindow.this.editor.setCaretPosition(n2);
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 7 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                try {
                                    MainWindow.access$700(7.access$900(this.this$1)).setCaretPosition(7.access$800(this.this$1));
                                    SwingUtilities.invokeLater(new Runnable(this){
                                        private final /* synthetic */ 8 this$2;
                                        {
                                            this.this$2 = var1_1;
                                        }

                                        public void run() {
                                            7.access$900(8.access$1000(this.this$2)).checkCaret();
                                        }
                                    });
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }

                            static /* synthetic */ 7 access$1000(8 var0) {
                                return var0.this$1;
                            }
                        });
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }

                static /* synthetic */ int access$800(7 var0) {
                    return var0.n3;
                }

                static /* synthetic */ MainWindow access$900(7 var0) {
                    return var0.MainWindow.this;
                }
            });
            if (!this.m_docReady) {
                this.m_docReady = true;
            }
            this.editor.cancelUndo();
            this.editor.checkSpelling(true);
        }
        this.entryActivated = true;
    }

    public void displayWarning(String string, Throwable throwable) {
        this.setMessageText(string);
        String string2 = string;
        if (throwable != null) {
            string2 = string2 + "\n" + throwable.toString();
        }
        JOptionPane.showMessageDialog(this, string2, OStrings.getString("TF_WARNING"), 2);
    }

    public void displayError(String string, Throwable throwable) {
        this.setMessageText(string);
        String string2 = string;
        if (throwable != null) {
            string2 = string2 + "\n" + throwable.toString();
        }
        JOptionPane.showMessageDialog(this, string2, OStrings.getString("TF_ERROR"), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean checkCaretForDelete(boolean bl) {
        EditorTextArea editorTextArea = this.editor;
        synchronized (editorTextArea) {
            int n = this.editor.getCaretPosition();
            this.checkCaret();
            if (bl) {
                int n2 = this.editor.getTextLength() - this.m_segmentEndInset - OConsts.segmentEndStringFull.length();
                int n3 = this.editor.getSelectionStart();
                int n4 = this.editor.getSelectionEnd();
                if (n >= n2 && n3 >= n2 && n4 >= n2) {
                    return false;
                }
            } else {
                int n5 = this.getTranslationStart();
                int n6 = this.editor.getSelectionStart();
                int n7 = this.editor.getSelectionEnd();
                if (n <= n5 && n7 <= n5 && n6 <= n5) {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getTranslationStart() {
        EditorTextArea editorTextArea = this.editor;
        synchronized (editorTextArea) {
            return this.m_segmentStartOffset + this.m_sourceDisplayLength + OConsts.segmentStartStringFull.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getTranslationEnd() {
        EditorTextArea editorTextArea = this.editor;
        synchronized (editorTextArea) {
            return this.editor.getTextLength() - this.m_segmentEndInset - OConsts.segmentEndStringFull.length();
        }
    }

    private synchronized ArrayList checkSpelling(int n, String string) {
        List list = StaticUtils.tokenizeText(string);
        ArrayList<Token> arrayList = new ArrayList<Token>();
        Iterator iterator = list.iterator();
        AbstractDocument abstractDocument = (AbstractDocument)this.editor.getDocument();
        AttributeSet attributeSet = this.m_translatedAttributeSet;
        SpellChecker spellChecker = CommandThread.core.getSpellchecker();
        while (iterator.hasNext()) {
            int n2;
            Token token = (Token)iterator.next();
            int n3 = token.getOffset();
            String string2 = string.substring(n3, n2 = n3 + token.getLength());
            if (spellChecker.isCorrect(string2)) continue;
            try {
                abstractDocument.replace(n + n3, token.getLength(), string2, Styles.applyStyles(attributeSet, Styles.MISSPELLED));
            }
            catch (BadLocationException badLocationException) {
                Log.log(badLocationException);
            }
            arrayList.add(token);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkCaret() {
        EditorTextArea editorTextArea = this.editor;
        synchronized (editorTextArea) {
            int n = this.editor.getSelectionStart();
            int n2 = this.editor.getSelectionEnd();
            int n3 = this.getTranslationStart();
            int n4 = this.getTranslationEnd();
            if (n != n2) {
                if (n < n3) {
                    this.editor.setSelectionStart(n3);
                } else if (n > n4) {
                    this.editor.setSelectionStart(n4);
                }
                if (n2 > n4) {
                    this.editor.setSelectionEnd(n4);
                } else if (n2 < n3) {
                    this.editor.setSelectionStart(n3);
                }
            } else if (n < n3) {
                this.editor.setCaretPosition(n3);
            } else if (n > n4) {
                this.editor.setCaretPosition(n4);
            }
        }
    }

    public void fatalError(String string, Throwable throwable) {
        Log.log(string);
        if (throwable != null) {
            Log.log(throwable);
        }
        CommandThread.core.interrupt();
        for (int i = 0; i < 100 && CommandThread.core != null; ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Runtime.getRuntime().halt(1);
    }

    public synchronized boolean isProjectLoaded() {
        return this.m_projectLoaded;
    }

    private String getActiveFileFullPath() {
        return CommandThread.core.getSTE((int)this.m_curEntryNum).getSrcFile().name;
    }

    public String getActiveFileName() {
        String string = this.getActiveFileFullPath().substring(CommandThread.core.sourceRoot().length());
        return string;
    }

    public ProjectFrame getProjectFrame() {
        return this.m_projWin;
    }

    public AttributeSet getTranslatedAttributeSet() {
        return this.m_translatedAttributeSet;
    }

    public boolean displaySegmentSources() {
        return this.m_displaySegmentSources;
    }

    private void initComponents() {
        this.separator2inProjectMenu = new JSeparator();
        this.projectExitMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.statusPanel2 = new JPanel();
        this.progressLabel = new JLabel();
        this.lengthLabel = new JLabel();
        this.mainMenu = new JMenuBar();
        this.projectMenu = new JMenu();
        this.projectNewMenuItem = new JMenuItem();
        this.projectOpenMenuItem = new JMenuItem();
        this.projectImportMenuItem = new JMenuItem();
        this.projectWikiImportMenuItem = new JMenuItem();
        this.projectReloadMenuItem = new JMenuItem();
        this.projectCloseMenuItem = new JMenuItem();
        this.separator4inProjectMenu = new JSeparator();
        this.projectSaveMenuItem = new JMenuItem();
        this.separator5inProjectMenu = new JSeparator();
        this.projectCompileMenuItem = new JMenuItem();
        this.separator1inProjectMenu = new JSeparator();
        this.projectEditMenuItem = new JMenuItem();
        this.viewFileListMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.editUndoMenuItem = new JMenuItem();
        this.editRedoMenuItem = new JMenuItem();
        this.separator1inEditMenu = new JSeparator();
        this.editOverwriteTranslationMenuItem = new JMenuItem();
        this.editInsertTranslationMenuItem = new JMenuItem();
        this.separator4inEditMenu = new JSeparator();
        this.editOverwriteSourceMenuItem = new JMenuItem();
        this.editInsertSourceMenuItem = new JMenuItem();
        this.separator2inEditMenu = new JSeparator();
        this.editFindInProjectMenuItem = new JMenuItem();
        this.separator3inEditMenu = new JSeparator();
        this.switchCaseSubMenu = new JMenu();
        this.lowerCaseMenuItem = new JMenuItem();
        this.upperCaseMenuItem = new JMenuItem();
        this.titleCaseMenuItem = new JMenuItem();
        this.separatorInSwitchCaseSubMenu = new JSeparator();
        this.cycleSwitchCaseMenuItem = new JMenuItem();
        this.separator5inEditMenu = new JSeparator();
        this.editSelectFuzzy1MenuItem = new JMenuItem();
        this.editSelectFuzzy2MenuItem = new JMenuItem();
        this.editSelectFuzzy3MenuItem = new JMenuItem();
        this.editSelectFuzzy4MenuItem = new JMenuItem();
        this.editSelectFuzzy5MenuItem = new JMenuItem();
        this.gotoMenu = new JMenu();
        this.gotoNextUntranslatedMenuItem = new JMenuItem();
        this.gotoNextSegmentMenuItem = new JMenuItem();
        this.gotoPreviousSegmentMenuItem = new JMenuItem();
        this.gotoSegmentMenuItem = new JMenuItem();
        this.separatorInGoToMenu = new JSeparator();
        this.gotoHistoryForwardMenuItem = new JMenuItem();
        this.gotoHistoryBackMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.viewMarkTranslatedSegmentsCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.viewMarkUntranslatedSegmentsCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.viewDisplaySegmentSourceCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.toolsMenu = new JMenu();
        this.toolsValidateTagsMenuItem = new JMenuItem();
        this.optionsMenu = new JMenu();
        this.optionsTabAdvanceCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.optionsAlwaysConfirmQuitCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.separator1inOptionsMenu = new JSeparator();
        this.optionsFontSelectionMenuItem = new JMenuItem();
        this.optionsSetupFileFiltersMenuItem = new JMenuItem();
        this.optionsSentsegMenuItem = new JMenuItem();
        this.optionsSpellCheckMenuItem = new JMenuItem();
        this.optionsWorkflowMenuItem = new JMenuItem();
        this.optionsRestoreGUIMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpContentsMenuItem = new JMenuItem();
        this.helpAboutMenuItem = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)this.projectExitMenuItem, (String)OStrings.getString("TF_MENU_FILE_QUIT"));
        this.projectExitMenuItem.addActionListener(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.statusPanel.setLayout(new BorderLayout());
        this.statusLabel.setFont(new Font("MS Sans Serif", 0, 11));
        this.statusPanel.add((Component)this.statusLabel, "Center");
        this.statusPanel2.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText((JLabel)this.progressLabel, (String)OStrings.getString("MW_PROGRESS_DEFAULT"));
        this.progressLabel.setToolTipText(OStrings.getString("MW_PROGRESS_TOOLTIP"));
        this.progressLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.progressLabel.setHorizontalTextPosition(0);
        this.statusPanel2.add(this.progressLabel);
        Mnemonics.setLocalizedText((JLabel)this.lengthLabel, (String)OStrings.getString("MW_SEGMENT_LENGTH_DEFAULT"));
        this.lengthLabel.setToolTipText(OStrings.getString("MW_SEGMENT_LENGTH_TOOLTIP"));
        this.lengthLabel.setAlignmentX(1.0f);
        this.lengthLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lengthLabel.setFocusable(false);
        this.statusPanel2.add(this.lengthLabel);
        this.statusPanel.add((Component)this.statusPanel2, "East");
        this.getContentPane().add((Component)this.statusPanel, "South");
        Mnemonics.setLocalizedText((AbstractButton)this.projectMenu, (String)OStrings.getString("TF_MENU_FILE"));
        Mnemonics.setLocalizedText((AbstractButton)this.projectNewMenuItem, (String)OStrings.getString("TF_MENU_FILE_CREATE"));
        this.projectNewMenuItem.addActionListener(this);
        this.projectMenu.add(this.projectNewMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.projectOpenMenuItem, (String)OStrings.getString("TF_MENU_FILE_OPEN"));
        this.projectOpenMenuItem.addActionListener(this);
        this.projectMenu.add(this.projectOpenMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.projectImportMenuItem, (String)OStrings.getString("TF_MENU_FILE_IMPORT"));
        this.projectImportMenuItem.addActionListener(this);
        this.projectMenu.add(this.projectImportMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.projectWikiImportMenuItem, (String)OStrings.getString("TF_MENU_WIKI_IMPORT"));
        this.projectWikiImportMenuItem.addActionListener(this);
        this.projectMenu.add(this.projectWikiImportMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.projectReloadMenuItem, (String)OStrings.getString("TF_MENU_PROJECT_RELOAD"));
        this.projectReloadMenuItem.addActionListener(this);
        this.projectMenu.add(this.projectReloadMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.projectCloseMenuItem, (String)OStrings.getString("TF_MENU_FILE_CLOSE"));
        this.projectCloseMenuItem.addActionListener(this);
        this.projectMenu.add(this.projectCloseMenuItem);
        this.projectMenu.add(this.separator4inProjectMenu);
        Mnemonics.setLocalizedText((AbstractButton)this.projectSaveMenuItem, (String)OStrings.getString("TF_MENU_FILE_SAVE"));
        this.projectSaveMenuItem.addActionListener(this);
        this.projectMenu.add(this.projectSaveMenuItem);
        this.projectMenu.add(this.separator5inProjectMenu);
        Mnemonics.setLocalizedText((AbstractButton)this.projectCompileMenuItem, (String)OStrings.getString("TF_MENU_FILE_COMPILE"));
        this.projectCompileMenuItem.addActionListener(this);
        this.projectMenu.add(this.projectCompileMenuItem);
        this.projectMenu.add(this.separator1inProjectMenu);
        Mnemonics.setLocalizedText((AbstractButton)this.projectEditMenuItem, (String)OStrings.getString("MW_PROJECTMENU_EDIT"));
        this.projectEditMenuItem.addActionListener(this);
        this.projectMenu.add(this.projectEditMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.viewFileListMenuItem, (String)OStrings.getString("TF_MENU_FILE_PROJWIN"));
        this.viewFileListMenuItem.addActionListener(this);
        this.projectMenu.add(this.viewFileListMenuItem);
        this.mainMenu.add(this.projectMenu);
        Mnemonics.setLocalizedText((AbstractButton)this.editMenu, (String)OStrings.getString("TF_MENU_EDIT"));
        Mnemonics.setLocalizedText((AbstractButton)this.editUndoMenuItem, (String)OStrings.getString("TF_MENU_EDIT_UNDO"));
        this.editUndoMenuItem.addActionListener(this);
        this.editMenu.add(this.editUndoMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.editRedoMenuItem, (String)OStrings.getString("TF_MENU_EDIT_REDO"));
        this.editRedoMenuItem.addActionListener(this);
        this.editMenu.add(this.editRedoMenuItem);
        this.editMenu.add(this.separator1inEditMenu);
        Mnemonics.setLocalizedText((AbstractButton)this.editOverwriteTranslationMenuItem, (String)OStrings.getString("TF_MENU_EDIT_RECYCLE"));
        this.editOverwriteTranslationMenuItem.addActionListener(this);
        this.editMenu.add(this.editOverwriteTranslationMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.editInsertTranslationMenuItem, (String)OStrings.getString("TF_MENU_EDIT_INSERT"));
        this.editInsertTranslationMenuItem.addActionListener(this);
        this.editMenu.add(this.editInsertTranslationMenuItem);
        this.editMenu.add(this.separator4inEditMenu);
        Mnemonics.setLocalizedText((AbstractButton)this.editOverwriteSourceMenuItem, (String)OStrings.getString("TF_MENU_EDIT_SOURCE_OVERWRITE"));
        this.editOverwriteSourceMenuItem.addActionListener(this);
        this.editMenu.add(this.editOverwriteSourceMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.editInsertSourceMenuItem, (String)OStrings.getString("TF_MENU_EDIT_SOURCE_INSERT"));
        this.editInsertSourceMenuItem.addActionListener(this);
        this.editMenu.add(this.editInsertSourceMenuItem);
        this.editMenu.add(this.separator2inEditMenu);
        Mnemonics.setLocalizedText((AbstractButton)this.editFindInProjectMenuItem, (String)OStrings.getString("TF_MENU_EDIT_FIND"));
        this.editFindInProjectMenuItem.addActionListener(this);
        this.editMenu.add(this.editFindInProjectMenuItem);
        this.editMenu.add(this.separator3inEditMenu);
        Mnemonics.setLocalizedText((AbstractButton)this.switchCaseSubMenu, (String)OStrings.getString("TF_EDIT_MENU_SWITCH_CASE"));
        Mnemonics.setLocalizedText((AbstractButton)this.lowerCaseMenuItem, (String)OStrings.getString("TF_EDIT_MENU_SWITCH_CASE_TO_LOWER"));
        this.lowerCaseMenuItem.addActionListener(this);
        this.switchCaseSubMenu.add(this.lowerCaseMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.upperCaseMenuItem, (String)OStrings.getString("TF_EDIT_MENU_SWITCH_CASE_TO_UPPER"));
        this.upperCaseMenuItem.addActionListener(this);
        this.switchCaseSubMenu.add(this.upperCaseMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.titleCaseMenuItem, (String)OStrings.getString("TF_EDIT_MENU_SWITCH_CASE_TO_TITLE"));
        this.titleCaseMenuItem.addActionListener(this);
        this.switchCaseSubMenu.add(this.titleCaseMenuItem);
        this.switchCaseSubMenu.add(this.separatorInSwitchCaseSubMenu);
        this.cycleSwitchCaseMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 1));
        Mnemonics.setLocalizedText((AbstractButton)this.cycleSwitchCaseMenuItem, (String)OStrings.getString("TF_EDIT_MENU_SWITCH_CASE_CYCLE"));
        this.cycleSwitchCaseMenuItem.addActionListener(this);
        this.switchCaseSubMenu.add(this.cycleSwitchCaseMenuItem);
        this.editMenu.add(this.switchCaseSubMenu);
        this.editMenu.add(this.separator5inEditMenu);
        Mnemonics.setLocalizedText((AbstractButton)this.editSelectFuzzy1MenuItem, (String)OStrings.getString("TF_MENU_EDIT_COMPARE_1"));
        this.editSelectFuzzy1MenuItem.addActionListener(this);
        this.editMenu.add(this.editSelectFuzzy1MenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.editSelectFuzzy2MenuItem, (String)OStrings.getString("TF_MENU_EDIT_COMPARE_2"));
        this.editSelectFuzzy2MenuItem.addActionListener(this);
        this.editMenu.add(this.editSelectFuzzy2MenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.editSelectFuzzy3MenuItem, (String)OStrings.getString("TF_MENU_EDIT_COMPARE_3"));
        this.editSelectFuzzy3MenuItem.addActionListener(this);
        this.editMenu.add(this.editSelectFuzzy3MenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.editSelectFuzzy4MenuItem, (String)OStrings.getString("TF_MENU_EDIT_COMPARE_4"));
        this.editSelectFuzzy4MenuItem.addActionListener(this);
        this.editMenu.add(this.editSelectFuzzy4MenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.editSelectFuzzy5MenuItem, (String)OStrings.getString("TF_MENU_EDIT_COMPARE_5"));
        this.editSelectFuzzy5MenuItem.addActionListener(this);
        this.editMenu.add(this.editSelectFuzzy5MenuItem);
        this.mainMenu.add(this.editMenu);
        Mnemonics.setLocalizedText((AbstractButton)this.gotoMenu, (String)OStrings.getString("MW_GOTOMENU"));
        Mnemonics.setLocalizedText((AbstractButton)this.gotoNextUntranslatedMenuItem, (String)OStrings.getString("TF_MENU_EDIT_UNTRANS"));
        this.gotoNextUntranslatedMenuItem.addActionListener(this);
        this.gotoMenu.add(this.gotoNextUntranslatedMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.gotoNextSegmentMenuItem, (String)OStrings.getString("TF_MENU_EDIT_NEXT"));
        this.gotoNextSegmentMenuItem.addActionListener(this);
        this.gotoMenu.add(this.gotoNextSegmentMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.gotoPreviousSegmentMenuItem, (String)OStrings.getString("TF_MENU_EDIT_PREV"));
        this.gotoPreviousSegmentMenuItem.addActionListener(this);
        this.gotoMenu.add(this.gotoPreviousSegmentMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.gotoSegmentMenuItem, (String)OStrings.getString("TF_MENU_EDIT_GOTO"));
        this.gotoSegmentMenuItem.addActionListener(this);
        this.gotoMenu.add(this.gotoSegmentMenuItem);
        this.gotoMenu.add(this.separatorInGoToMenu);
        Mnemonics.setLocalizedText((AbstractButton)this.gotoHistoryForwardMenuItem, (String)OStrings.getString("TF_MENU_GOTO_FORWARD_IN_HISTORY"));
        this.gotoHistoryForwardMenuItem.addActionListener(this);
        this.gotoMenu.add(this.gotoHistoryForwardMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.gotoHistoryBackMenuItem, (String)OStrings.getString("TF_MENU_GOTO_BACK_IN_HISTORY"));
        this.gotoHistoryBackMenuItem.addActionListener(this);
        this.gotoMenu.add(this.gotoHistoryBackMenuItem);
        this.mainMenu.add(this.gotoMenu);
        Mnemonics.setLocalizedText((AbstractButton)this.viewMenu, (String)OStrings.getString("MW_VIEW_MENU"));
        Mnemonics.setLocalizedText((AbstractButton)this.viewMarkTranslatedSegmentsCheckBoxMenuItem, (String)OStrings.getString("TF_MENU_DISPLAY_MARK_TRANSLATED"));
        this.viewMarkTranslatedSegmentsCheckBoxMenuItem.addActionListener(this);
        this.viewMenu.add(this.viewMarkTranslatedSegmentsCheckBoxMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.viewMarkUntranslatedSegmentsCheckBoxMenuItem, (String)OStrings.getString("TF_MENU_DISPLAY_MARK_UNTRANSLATED"));
        this.viewMarkUntranslatedSegmentsCheckBoxMenuItem.addActionListener(this);
        this.viewMenu.add(this.viewMarkUntranslatedSegmentsCheckBoxMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.viewDisplaySegmentSourceCheckBoxMenuItem, (String)OStrings.getString("MW_VIEW_MENU_DISPLAY_SEGMENT_SOURCES"));
        this.viewDisplaySegmentSourceCheckBoxMenuItem.addActionListener(this);
        this.viewMenu.add(this.viewDisplaySegmentSourceCheckBoxMenuItem);
        this.mainMenu.add(this.viewMenu);
        Mnemonics.setLocalizedText((AbstractButton)this.toolsMenu, (String)OStrings.getString("TF_MENU_TOOLS"));
        Mnemonics.setLocalizedText((AbstractButton)this.toolsValidateTagsMenuItem, (String)OStrings.getString("TF_MENU_TOOLS_VALIDATE"));
        this.toolsValidateTagsMenuItem.addActionListener(this);
        this.toolsMenu.add(this.toolsValidateTagsMenuItem);
        this.mainMenu.add(this.toolsMenu);
        Mnemonics.setLocalizedText((AbstractButton)this.optionsMenu, (String)OStrings.getString("MW_OPTIONSMENU"));
        this.optionsMenu.addActionListener(this);
        Mnemonics.setLocalizedText((AbstractButton)this.optionsTabAdvanceCheckBoxMenuItem, (String)OStrings.getString("TF_MENU_DISPLAY_ADVANCE"));
        this.optionsTabAdvanceCheckBoxMenuItem.addActionListener(this);
        this.optionsMenu.add(this.optionsTabAdvanceCheckBoxMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.optionsAlwaysConfirmQuitCheckBoxMenuItem, (String)OStrings.getString("MW_OPTIONSMENU_ALWAYS_CONFIRM_QUIT"));
        this.optionsAlwaysConfirmQuitCheckBoxMenuItem.addActionListener(this);
        this.optionsMenu.add(this.optionsAlwaysConfirmQuitCheckBoxMenuItem);
        this.optionsMenu.add(this.separator1inOptionsMenu);
        Mnemonics.setLocalizedText((AbstractButton)this.optionsFontSelectionMenuItem, (String)OStrings.getString("TF_MENU_DISPLAY_FONT"));
        this.optionsFontSelectionMenuItem.addActionListener(this);
        this.optionsMenu.add(this.optionsFontSelectionMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.optionsSetupFileFiltersMenuItem, (String)OStrings.getString("TF_MENU_DISPLAY_FILTERS"));
        this.optionsSetupFileFiltersMenuItem.addActionListener(this);
        this.optionsMenu.add(this.optionsSetupFileFiltersMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.optionsSentsegMenuItem, (String)OStrings.getString("MW_OPTIONSMENU_SENTSEG"));
        this.optionsSentsegMenuItem.addActionListener(this);
        this.optionsMenu.add(this.optionsSentsegMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.optionsSpellCheckMenuItem, (String)OStrings.getString("MW_OPTIONSMENU_SPELLCHECK"));
        this.optionsSpellCheckMenuItem.addActionListener(this);
        this.optionsMenu.add(this.optionsSpellCheckMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.optionsWorkflowMenuItem, (String)OStrings.getString("MW_OPTIONSMENU_WORKFLOW"));
        this.optionsWorkflowMenuItem.addActionListener(this);
        this.optionsMenu.add(this.optionsWorkflowMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.optionsRestoreGUIMenuItem, (String)OStrings.getString("MW_OPTIONSMENU_RESTORE_GUI"));
        this.optionsRestoreGUIMenuItem.addActionListener(this);
        this.optionsMenu.add(this.optionsRestoreGUIMenuItem);
        this.mainMenu.add(this.optionsMenu);
        Mnemonics.setLocalizedText((AbstractButton)this.helpMenu, (String)OStrings.getString("TF_MENU_HELP"));
        this.helpContentsMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.helpContentsMenuItem, (String)OStrings.getString("TF_MENU_HELP_CONTENTS"));
        this.helpContentsMenuItem.addActionListener(this);
        this.helpMenu.add(this.helpContentsMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.helpAboutMenuItem, (String)OStrings.getString("TF_MENU_HELP_ABOUT"));
        this.helpAboutMenuItem.addActionListener(this);
        this.helpMenu.add(this.helpAboutMenuItem);
        this.mainMenu.add(this.helpMenu);
        this.setJMenuBar(this.mainMenu);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.projectExitMenuItem) {
            this.projectExitMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.projectNewMenuItem) {
            this.projectNewMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.projectOpenMenuItem) {
            this.projectOpenMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.projectImportMenuItem) {
            this.projectImportMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.projectWikiImportMenuItem) {
            this.projectWikiImportMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.projectReloadMenuItem) {
            this.projectReloadMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.projectCloseMenuItem) {
            this.projectCloseMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.projectSaveMenuItem) {
            this.projectSaveMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.projectCompileMenuItem) {
            this.projectCompileMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.projectEditMenuItem) {
            this.projectEditMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.viewFileListMenuItem) {
            this.viewFileListMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.editUndoMenuItem) {
            this.editUndoMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.editRedoMenuItem) {
            this.editRedoMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.editOverwriteTranslationMenuItem) {
            this.editOverwriteTranslationMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.editInsertTranslationMenuItem) {
            this.editInsertTranslationMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.editOverwriteSourceMenuItem) {
            this.editOverwriteSourceMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.editInsertSourceMenuItem) {
            this.editInsertSourceMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.editFindInProjectMenuItem) {
            this.editFindInProjectMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.lowerCaseMenuItem) {
            this.lowerCaseMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.upperCaseMenuItem) {
            this.upperCaseMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.titleCaseMenuItem) {
            this.titleCaseMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.cycleSwitchCaseMenuItem) {
            this.cycleSwitchCaseMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.editSelectFuzzy1MenuItem) {
            this.editSelectFuzzy1MenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.editSelectFuzzy2MenuItem) {
            this.editSelectFuzzy2MenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.editSelectFuzzy3MenuItem) {
            this.editSelectFuzzy3MenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.editSelectFuzzy4MenuItem) {
            this.editSelectFuzzy4MenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.editSelectFuzzy5MenuItem) {
            this.editSelectFuzzy5MenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.gotoNextUntranslatedMenuItem) {
            this.gotoNextUntranslatedMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.gotoNextSegmentMenuItem) {
            this.gotoNextSegmentMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.gotoPreviousSegmentMenuItem) {
            this.gotoPreviousSegmentMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.gotoSegmentMenuItem) {
            this.gotoSegmentMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.gotoHistoryForwardMenuItem) {
            this.gotoHistoryForwardMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.gotoHistoryBackMenuItem) {
            this.gotoHistoryBackMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.viewMarkTranslatedSegmentsCheckBoxMenuItem) {
            this.viewMarkTranslatedSegmentsCheckBoxMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.viewMarkUntranslatedSegmentsCheckBoxMenuItem) {
            this.viewMarkUntranslatedSegmentsCheckBoxMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.viewDisplaySegmentSourceCheckBoxMenuItem) {
            this.viewDisplaySegmentSourceCheckBoxMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.toolsValidateTagsMenuItem) {
            this.toolsValidateTagsMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.optionsMenu) {
            this.optionsMenuActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.optionsTabAdvanceCheckBoxMenuItem) {
            this.optionsTabAdvanceCheckBoxMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.optionsAlwaysConfirmQuitCheckBoxMenuItem) {
            this.optionsAlwaysConfirmQuitCheckBoxMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.optionsFontSelectionMenuItem) {
            this.optionsFontSelectionMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.optionsSetupFileFiltersMenuItem) {
            this.optionsSetupFileFiltersMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.optionsSentsegMenuItem) {
            this.optionsSentsegMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.optionsSpellCheckMenuItem) {
            this.optionsSpellCheckMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.optionsWorkflowMenuItem) {
            this.optionsWorkflowMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.optionsRestoreGUIMenuItem) {
            this.optionsRestoreGUIMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.helpContentsMenuItem) {
            this.helpContentsMenuItemActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.helpAboutMenuItem) {
            this.helpAboutMenuItemActionPerformed(actionEvent);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        if (componentEvent.getSource() == this) {
            this.formComponentMoved(componentEvent);
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (componentEvent.getSource() == this) {
            this.formComponentResized(componentEvent);
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.formWindowClosing(windowEvent);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private void viewDisplaySegmentSourceCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.commitEntry(false);
        this.m_displaySegmentSources = this.viewDisplaySegmentSourceCheckBoxMenuItem.isSelected();
        Preferences.setPreference("display_segment_sources", this.m_displaySegmentSources);
        this.loadDocument();
        this.activateEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cycleSwitchCaseMenuItemActionPerformed(ActionEvent actionEvent) {
        EditorTextArea editorTextArea = this.editor;
        synchronized (editorTextArea) {
            this.editor.changeCase(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void titleCaseMenuItemActionPerformed(ActionEvent actionEvent) {
        EditorTextArea editorTextArea = this.editor;
        synchronized (editorTextArea) {
            this.editor.changeCase(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upperCaseMenuItemActionPerformed(ActionEvent actionEvent) {
        EditorTextArea editorTextArea = this.editor;
        synchronized (editorTextArea) {
            this.editor.changeCase(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lowerCaseMenuItemActionPerformed(ActionEvent actionEvent) {
        EditorTextArea editorTextArea = this.editor;
        synchronized (editorTextArea) {
            this.editor.changeCase(1);
        }
    }

    private void gotoHistoryBackMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doGotoHistoryBack();
    }

    private void gotoHistoryForwardMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doGotoHistoryForward();
    }

    private void optionsSpellCheckMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doSpellCheckSettings();
    }

    private void optionsMenuActionPerformed(ActionEvent actionEvent) {
    }

    private void viewMarkTranslatedSegmentsCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        Preferences.setPreference("mark_translated_segments", this.viewMarkTranslatedSegmentsCheckBoxMenuItem.isSelected());
        this.m_translatedAttributeSet = this.viewMarkTranslatedSegmentsCheckBoxMenuItem.isSelected() ? Styles.TRANSLATED : Styles.PLAIN;
        this.commitEntry(false);
        this.loadDocument();
        this.activateEntry();
    }

    private void optionsRestoreGUIMenuItemActionPerformed(ActionEvent actionEvent) {
        this.restoreGUI();
    }

    private void viewFileListMenuItemActionPerformed(ActionEvent actionEvent) {
        if (this.m_projWin == null) {
            this.viewFileListMenuItem.setSelected(false);
            return;
        }
        if (!this.m_projWin.isActive()) {
            this.m_projWin.buildDisplay();
            this.m_projWin.setVisible(true);
            this.m_projWin.toFront();
        } else {
            this.m_projWin.setVisible(false);
        }
    }

    private void optionsAlwaysConfirmQuitCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        Preferences.setPreference("always_confirm_quit", this.optionsAlwaysConfirmQuitCheckBoxMenuItem.isSelected());
    }

    private void editOverwriteSourceMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doOverwriteSource();
    }

    private void editInsertSourceMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doInsertSource();
    }

    private void projectImportMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doImportSourceFiles();
    }

    private void projectWikiImportMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doWikiImport();
    }

    private void projectReloadMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doReloadProject();
    }

    private void formComponentMoved(ComponentEvent componentEvent) {
        this.saveScreenLayout();
    }

    private void formComponentResized(ComponentEvent componentEvent) {
        this.saveScreenLayout();
    }

    private void optionsWorkflowMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setupWorkflow();
    }

    private void optionsSentsegMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setupSegmentation();
    }

    private void projectEditMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doEditProject();
    }

    private void optionsTabAdvanceCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        Preferences.setPreference("tab_advance", this.optionsTabAdvanceCheckBoxMenuItem.isSelected());
        this.m_advancer = this.optionsTabAdvanceCheckBoxMenuItem.isSelected() ? (char)9 : (char)10;
    }

    private void helpContentsMenuItemActionPerformed(ActionEvent actionEvent) {
        HelpFrame helpFrame = HelpFrame.getInstance();
        helpFrame.setVisible(true);
        helpFrame.toFront();
    }

    private void optionsSetupFileFiltersMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setupFilters();
    }

    private void optionsFontSelectionMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doFont();
    }

    private void toolsValidateTagsMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doValidateTags();
    }

    private void editSelectFuzzy5MenuItemActionPerformed(ActionEvent actionEvent) {
        this.matches.setActiveMatch(4);
    }

    private void editSelectFuzzy4MenuItemActionPerformed(ActionEvent actionEvent) {
        this.matches.setActiveMatch(3);
    }

    private void editSelectFuzzy3MenuItemActionPerformed(ActionEvent actionEvent) {
        this.matches.setActiveMatch(2);
    }

    private void editSelectFuzzy2MenuItemActionPerformed(ActionEvent actionEvent) {
        this.matches.setActiveMatch(1);
    }

    private void editSelectFuzzy1MenuItemActionPerformed(ActionEvent actionEvent) {
        this.matches.setActiveMatch(0);
    }

    private void editFindInProjectMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doFind();
    }

    private void editInsertTranslationMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doInsertTrans();
    }

    private void editOverwriteTranslationMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doRecycleTrans();
    }

    private void gotoNextUntranslatedMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doNextUntranslatedEntry();
    }

    private void gotoPreviousSegmentMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doPrevEntry();
    }

    private void gotoSegmentMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doGotoEntry();
    }

    private void gotoNextSegmentMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doNextEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editRedoMenuItemActionPerformed(ActionEvent actionEvent) {
        try {
            EditorTextArea editorTextArea = this.editor;
            synchronized (editorTextArea) {
                this.editor.redoOneEdit();
            }
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editUndoMenuItemActionPerformed(ActionEvent actionEvent) {
        try {
            EditorTextArea editorTextArea = this.editor;
            synchronized (editorTextArea) {
                this.editor.undoOneEdit();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    private void projectCompileMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doCompileProject();
    }

    private void projectCloseMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doCloseProject();
    }

    private void projectSaveMenuItemActionPerformed(ActionEvent actionEvent) {
        this.commitEntry();
        this.activateEntry();
        this.doSave();
    }

    private void projectOpenMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doLoadProject();
    }

    private void projectNewMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doCreateProject();
    }

    private void projectExitMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doQuit();
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        this.doQuit();
    }

    private void helpAboutMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doAbout();
    }

    private void viewMarkUntranslatedSegmentsCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        Preferences.setPreference("mark_untranslated_segments", this.viewMarkUntranslatedSegmentsCheckBoxMenuItem.isSelected());
        this.m_unTranslatedAttributeSet = this.viewMarkUntranslatedSegmentsCheckBoxMenuItem.isSelected() ? Styles.UNTRANSLATED : Styles.PLAIN;
        this.commitEntry(false);
        this.loadDocument();
        this.activateEntry();
    }

    private void doSpellCheckSettings() {
        SpellcheckerConfigurationDialog spellcheckerConfigurationDialog = new SpellcheckerConfigurationDialog((Frame)this, CommandThread.core.getProjectProperties().getTargetLanguage());
        spellcheckerConfigurationDialog.setVisible(true);
        if (spellcheckerConfigurationDialog.getReturnStatus() == 1) {
            this.m_autoSpellChecking = Preferences.isPreference("allow_auto_spellchecking");
            if (this.m_autoSpellChecking) {
                SpellChecker spellChecker = CommandThread.core.getSpellchecker();
                spellChecker.destroy();
                spellChecker.initialize();
            }
            this.commitEntry(false);
            int n = this.m_curEntryNum;
            this.loadDocument();
            this.activateEntry();
        }
    }

    public boolean autoSpellCheckingOn() {
        return this.m_autoSpellChecking;
    }

    private synchronized void doGotoHistoryBack() {
        int n = this.history.back();
        if (n != -1) {
            this.doGotoEntry(n + 1);
        }
    }

    private synchronized void doGotoHistoryForward() {
        int n = this.history.forward();
        if (n != -1) {
            this.doGotoEntry(n + 1);
        }
    }
}

