/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.segmentation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.ExceptionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.omegat.core.segmentation.MapRule;
import org.omegat.core.segmentation.SRX;
import org.omegat.core.segmentation.datamodels.MappingRulesModel;
import org.omegat.core.segmentation.datamodels.SegmentationRulesModel;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.openide.awt.Mnemonics;

public class SegmentationCustomizer
extends JDialog
implements ListSelectionListener {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JTextArea hintTextArea;
    private JLabel jLabel1;
    private JButton mapDeleteButton;
    private JButton mapDownButton;
    private JLabel mapErrorsLabel;
    private JButton mapInsertButton;
    private JPanel mapPanel;
    private JScrollPane mapScrollPane;
    private JTable mapTable;
    private JButton mapUpButton;
    private JButton okButton;
    private JButton ruleDeleteButton;
    private JButton ruleDownButton;
    private JLabel ruleErrorsLabel;
    private JButton ruleInsertButton;
    private JPanel rulePanel;
    private JScrollPane ruleScrollPane;
    private JTable ruleTable;
    private JButton ruleUpButton;
    private JButton toDefaultsButton;
    private int returnStatus = 0;

    private void constructor() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SegmentationCustomizer.this.cancelButtonActionPerformed(null);
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        this.initComponents();
        this.hintTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.getRootPane().setDefaultButton(this.okButton);
        this.mapTable.getSelectionModel().addListSelectionListener(this);
        this.ruleTable.getSelectionModel().addListSelectionListener(this);
        MappingRulesModel mappingRulesModel = (MappingRulesModel)this.mapTable.getModel();
        mappingRulesModel.addExceptionListener(new ExceptionListener(){

            public void exceptionThrown(Exception exception) {
                SegmentationCustomizer.this.mapErrorsLabel.setText(exception.getLocalizedMessage());
            }
        });
        this.pack();
        this.setSize(this.getWidth() * 5 / 4, this.getHeight() * 5 / 4);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public SegmentationCustomizer(Frame frame) {
        super(frame, true);
        this.constructor();
    }

    public SegmentationCustomizer(Dialog dialog) {
        super(dialog, true);
        this.constructor();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (listSelectionEvent.getSource() == this.mapTable.getSelectionModel()) {
            this.mapErrorsLabel.setText("");
            if (listSelectionModel.isSelectionEmpty()) {
                this.mapDeleteButton.setEnabled(false);
                this.mapUpButton.setEnabled(false);
                this.mapDownButton.setEnabled(false);
                this.ruleTable.setModel(new DefaultTableModel());
                this.ruleInsertButton.setEnabled(false);
            } else {
                this.mapDeleteButton.setEnabled(true);
                int n = this.mapTable.getSelectedRow();
                int n2 = this.mapTable.getRowCount();
                if (n > 0) {
                    this.mapUpButton.setEnabled(true);
                } else {
                    this.mapUpButton.setEnabled(false);
                }
                if (n < n2 - 1) {
                    this.mapDownButton.setEnabled(true);
                } else {
                    this.mapDownButton.setEnabled(false);
                }
                MapRule mapRule = (MapRule)SRX.getSRX().getMappingRules().get(n);
                SegmentationRulesModel segmentationRulesModel = new SegmentationRulesModel(mapRule.getRules());
                this.ruleTable.setModel(segmentationRulesModel);
                segmentationRulesModel.addExceptionListener(new ExceptionListener(){

                    public void exceptionThrown(Exception exception) {
                        SegmentationCustomizer.this.ruleErrorsLabel.setText(exception.getLocalizedMessage());
                    }
                });
                this.ruleInsertButton.setEnabled(true);
            }
        } else if (listSelectionEvent.getSource() == this.ruleTable.getSelectionModel()) {
            this.ruleErrorsLabel.setText("");
            if (listSelectionModel.isSelectionEmpty()) {
                this.ruleDeleteButton.setEnabled(false);
                this.ruleUpButton.setEnabled(false);
                this.ruleDownButton.setEnabled(false);
            } else {
                this.ruleDeleteButton.setEnabled(true);
                int n = this.ruleTable.getRowCount();
                int n3 = this.ruleTable.getSelectedRow();
                if (n3 > 0) {
                    this.ruleUpButton.setEnabled(true);
                } else {
                    this.ruleUpButton.setEnabled(false);
                }
                if (n3 < n - 1) {
                    this.ruleDownButton.setEnabled(true);
                } else {
                    this.ruleDownButton.setEnabled(false);
                }
            }
        }
    }

    private void commitTableEdits() {
        if (this.mapTable.getCellEditor() != null) {
            this.mapTable.getCellEditor().stopCellEditing();
        }
        if (this.ruleTable.getCellEditor() != null) {
            this.ruleTable.getCellEditor().stopCellEditing();
        }
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.toDefaultsButton = new JButton();
        this.jLabel1 = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.mapPanel = new JPanel();
        this.mapScrollPane = new JScrollPane();
        this.mapTable = new JTable();
        this.mapUpButton = new JButton();
        this.mapDeleteButton = new JButton();
        this.mapInsertButton = new JButton();
        this.mapDownButton = new JButton();
        this.hintTextArea = new JTextArea();
        this.mapErrorsLabel = new JLabel();
        this.rulePanel = new JPanel();
        this.ruleScrollPane = new JScrollPane();
        this.ruleTable = new JTable();
        this.ruleUpButton = new JButton();
        this.ruleDeleteButton = new JButton();
        this.ruleInsertButton = new JButton();
        this.ruleDownButton = new JButton();
        this.ruleErrorsLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(OStrings.getString("GUI_SEGMENTATION_TITLE"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SegmentationCustomizer.this.closeDialog(windowEvent);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText((AbstractButton)this.toDefaultsButton, (String)OStrings.getString("BUTTON_TO_DEFAULTS"));
        this.toDefaultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SegmentationCustomizer.this.toDefaultsButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.toDefaultsButton);
        this.jLabel1.setPreferredSize(new Dimension(20, 0));
        this.buttonPanel.add(this.jLabel1);
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SegmentationCustomizer.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.okButton);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SegmentationCustomizer.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.mapPanel.setLayout(new GridBagLayout());
        this.mapPanel.setBorder(BorderFactory.createTitledBorder(OStrings.getString("GUI_SEGMENTATION_RULESETS")));
        this.mapScrollPane.setPreferredSize(new Dimension(300, 100));
        this.mapTable.setModel(new MappingRulesModel(SRX.getSRX()));
        this.mapScrollPane.setViewportView(this.mapTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mapPanel.add((Component)this.mapScrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.mapUpButton, (String)OStrings.getString("GUI_SEGMENTATION_BUTTON_UP_1"));
        this.mapUpButton.setEnabled(false);
        this.mapUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SegmentationCustomizer.this.mapUpButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mapPanel.add((Component)this.mapUpButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.mapDeleteButton, (String)OStrings.getString("BUTTON_REMOVE"));
        this.mapDeleteButton.setEnabled(false);
        this.mapDeleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SegmentationCustomizer.this.mapDeleteButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mapPanel.add((Component)this.mapDeleteButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.mapInsertButton, (String)OStrings.getString("BUTTON_ADD_NODOTS"));
        this.mapInsertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SegmentationCustomizer.this.mapInsertButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mapPanel.add((Component)this.mapInsertButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.mapDownButton, (String)OStrings.getString("GUI_SEGMENTATION_BUTTON_DOWN_1"));
        this.mapDownButton.setEnabled(false);
        this.mapDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SegmentationCustomizer.this.mapDownButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mapPanel.add((Component)this.mapDownButton, gridBagConstraints);
        this.hintTextArea.setEditable(false);
        this.hintTextArea.setFont(new JLabel().getFont());
        this.hintTextArea.setLineWrap(true);
        this.hintTextArea.setText(OStrings.getString("GUI_SEGMENTATION_NOTE"));
        this.hintTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mapPanel.add((Component)this.hintTextArea, gridBagConstraints);
        this.mapErrorsLabel.setForeground(new Color(255, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.mapPanel.add((Component)this.mapErrorsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.getContentPane().add((Component)this.mapPanel, gridBagConstraints);
        this.rulePanel.setLayout(new GridBagLayout());
        this.rulePanel.setBorder(BorderFactory.createTitledBorder(OStrings.getString("GUI_SEGMENTATION_RULEORDER")));
        this.ruleScrollPane.setPreferredSize(new Dimension(300, 120));
        this.ruleScrollPane.setViewportView(this.ruleTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rulePanel.add((Component)this.ruleScrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ruleUpButton, (String)OStrings.getString("GUI_SEGMENTATION_BUTTON_UP_2"));
        this.ruleUpButton.setEnabled(false);
        this.ruleUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SegmentationCustomizer.this.ruleUpButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rulePanel.add((Component)this.ruleUpButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ruleDeleteButton, (String)OStrings.getString("BUTTON_REMOVE_2"));
        this.ruleDeleteButton.setEnabled(false);
        this.ruleDeleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SegmentationCustomizer.this.ruleDeleteButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rulePanel.add((Component)this.ruleDeleteButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ruleInsertButton, (String)OStrings.getString("BUTTON_ADD_NODOTS2"));
        this.ruleInsertButton.setEnabled(false);
        this.ruleInsertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SegmentationCustomizer.this.ruleInsertButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rulePanel.add((Component)this.ruleInsertButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ruleDownButton, (String)OStrings.getString("GUI_SEGMENTATION_BUTTON_DOWN_2"));
        this.ruleDownButton.setEnabled(false);
        this.ruleDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SegmentationCustomizer.this.ruleDownButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rulePanel.add((Component)this.ruleDownButton, gridBagConstraints);
        this.ruleErrorsLabel.setForeground(new Color(255, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.rulePanel.add((Component)this.ruleErrorsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.rulePanel, gridBagConstraints);
    }

    private void toDefaultsButtonActionPerformed(ActionEvent actionEvent) {
        this.commitTableEdits();
        SRX.init();
        MappingRulesModel mappingRulesModel = new MappingRulesModel(SRX.getSRX());
        this.mapTable.setModel(mappingRulesModel);
        mappingRulesModel.addExceptionListener(new ExceptionListener(){

            public void exceptionThrown(Exception exception) {
                SegmentationCustomizer.this.mapErrorsLabel.setText(exception.getLocalizedMessage());
            }
        });
        this.ruleTable.setModel(new DefaultTableModel());
    }

    private void ruleDownButtonActionPerformed(ActionEvent actionEvent) {
        this.commitTableEdits();
        SegmentationRulesModel segmentationRulesModel = (SegmentationRulesModel)this.ruleTable.getModel();
        int n = this.ruleTable.getSelectedRow();
        segmentationRulesModel.moveRowDown(n);
        this.ruleTable.getSelectionModel().clearSelection();
        this.ruleTable.getSelectionModel().addSelectionInterval(n + 1, n + 1);
    }

    private void ruleUpButtonActionPerformed(ActionEvent actionEvent) {
        this.commitTableEdits();
        SegmentationRulesModel segmentationRulesModel = (SegmentationRulesModel)this.ruleTable.getModel();
        int n = this.ruleTable.getSelectedRow();
        segmentationRulesModel.moveRowUp(n);
        this.ruleTable.getSelectionModel().clearSelection();
        this.ruleTable.getSelectionModel().addSelectionInterval(n - 1, n - 1);
    }

    private void ruleDeleteButtonActionPerformed(ActionEvent actionEvent) {
        this.commitTableEdits();
        SegmentationRulesModel segmentationRulesModel = (SegmentationRulesModel)this.ruleTable.getModel();
        segmentationRulesModel.removeRow(this.ruleTable.getSelectedRow());
    }

    private void mapDownButtonActionPerformed(ActionEvent actionEvent) {
        this.commitTableEdits();
        MappingRulesModel mappingRulesModel = (MappingRulesModel)this.mapTable.getModel();
        int n = this.mapTable.getSelectedRow();
        mappingRulesModel.moveRowDown(n);
        this.mapTable.getSelectionModel().clearSelection();
        this.mapTable.getSelectionModel().addSelectionInterval(n + 1, n + 1);
    }

    private void mapUpButtonActionPerformed(ActionEvent actionEvent) {
        this.commitTableEdits();
        MappingRulesModel mappingRulesModel = (MappingRulesModel)this.mapTable.getModel();
        int n = this.mapTable.getSelectedRow();
        mappingRulesModel.moveRowUp(n);
        this.mapTable.getSelectionModel().clearSelection();
        this.mapTable.getSelectionModel().addSelectionInterval(n - 1, n - 1);
    }

    private void mapDeleteButtonActionPerformed(ActionEvent actionEvent) {
        this.commitTableEdits();
        MappingRulesModel mappingRulesModel = (MappingRulesModel)this.mapTable.getModel();
        String string = mappingRulesModel.getValueAt(this.mapTable.getSelectedRow(), 0).toString();
        String string2 = OStrings.getString("CONFIRM_DIALOG_TITLE");
        String string3 = StaticUtils.format(OStrings.getString("SEG_CONFIRM_REMOVE_SENTSEG_SET"), new Object[]{string});
        if (JOptionPane.showConfirmDialog(this, string3, string2, 0) == 0) {
            mappingRulesModel.removeRow(this.mapTable.getSelectedRow());
        }
    }

    private void ruleInsertButtonActionPerformed(ActionEvent actionEvent) {
        this.commitTableEdits();
        SegmentationRulesModel segmentationRulesModel = (SegmentationRulesModel)this.ruleTable.getModel();
        segmentationRulesModel.addRow();
    }

    private void mapInsertButtonActionPerformed(ActionEvent actionEvent) {
        this.commitTableEdits();
        MappingRulesModel mappingRulesModel = (MappingRulesModel)this.mapTable.getModel();
        mappingRulesModel.addRow();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.commitTableEdits();
        SRX.getSRX().save();
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        SRX.reload();
        this.doClose(0);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose(0);
    }

    private void doClose(int n) {
        this.returnStatus = n;
        this.setVisible(false);
        this.dispose();
    }
}

