/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.omegat.util.StaticUtils;

public class OStrings {
    private static ResourceBundle bundle = ResourceBundle.getBundle("org/omegat/Bundle");
    private static String __VERSION_KEY = "version";
    private static String __UPDATE_KEY = "update";
    public static final String VERSION = ResourceBundle.getBundle("org/omegat/Version").getString(__VERSION_KEY);
    public static final String UPDATE = ResourceBundle.getBundle("org/omegat/Version").getString(__UPDATE_KEY);

    public static void loadBundle(String string) {
        boolean bl = false;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            bundle = new PropertyResourceBundle(fileInputStream);
            bl = true;
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Resource bundle file not found: " + string);
        }
        catch (IOException iOException) {
            System.err.println("Error while reading resource bundle file: " + string);
        }
        if (!bl) {
            System.err.println("Reverting to resource bundle for the default locale");
            bundle = ResourceBundle.getBundle("org/omegat/Bundle");
        }
    }

    public static String getString(String string) {
        return bundle.getString(string);
    }

    public static String getDisplayVersion() {
        return UPDATE != null && !UPDATE.equals("0") ? StaticUtils.format(OStrings.getString("version-update-template"), new Object[]{VERSION, UPDATE}) : StaticUtils.format(OStrings.getString("version-template"), new Object[]{VERSION, UPDATE});
    }

    public static String getSegmentStartMarker() {
        return "\n" + OStrings.getString("TF_CUR_SEGMENT_START");
    }

    public static String getSegmentEndMarker() {
        return " " + OStrings.getString("TF_CUR_SEGMENT_END");
    }
}

