/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.omegat.filters2.TranslationException;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.xml.XMLBlock;
import org.omegat.util.xml.XMLStreamReader;

public class ProjectFileStorage {
    private XMLStreamReader m_reader = new XMLStreamReader();
    private String m_target;
    private String m_source;
    private String m_tm;
    private String m_glossary;
    private String m_targetLocale;
    private String m_sourceLocale;
    private String m_sentenceSeg;
    private String m_root;

    public ProjectFileStorage() {
        this.m_reader.killEmptyBlocks();
        this.reset();
    }

    public void loadProjectFile(String string) throws IOException, TranslationException {
        this.m_reader.setStream(string, "UTF-8");
        if (this.m_reader.advanceToTag("omegat") == null) {
            return;
        }
        XMLBlock xMLBlock = this.m_reader.advanceToTag("project");
        if (xMLBlock == null) {
            return;
        }
        String string2 = xMLBlock.getAttribute("version");
        if (string2 != null && !string2.equals("1.0")) {
            throw new TranslationException(StaticUtils.format(OStrings.getString("PFR_ERROR_UNSUPPORTED_PROJECT_VERSION"), new Object[]{string2}));
        }
        this.m_root = string.substring(0, string.lastIndexOf(File.separator)) + File.separator;
        ArrayList arrayList = this.m_reader.closeBlock(xMLBlock);
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            xMLBlock = (XMLBlock)arrayList.get(i);
            if (xMLBlock.isClose()) continue;
            if (xMLBlock.getTagName().equals("target_dir")) {
                if (++i >= arrayList.size()) break;
                xMLBlock = (XMLBlock)arrayList.get(i);
                this.m_target = this.computeAbsolutePath(xMLBlock.getText(), "target");
                continue;
            }
            if (xMLBlock.getTagName().equals("source_dir")) {
                if (++i >= arrayList.size()) break;
                xMLBlock = (XMLBlock)arrayList.get(i);
                this.m_source = this.computeAbsolutePath(xMLBlock.getText(), "source");
                continue;
            }
            if (xMLBlock.getTagName().equals("tm_dir")) {
                if (++i >= arrayList.size()) break;
                xMLBlock = (XMLBlock)arrayList.get(i);
                this.m_tm = this.computeAbsolutePath(xMLBlock.getText(), "tm");
                continue;
            }
            if (xMLBlock.getTagName().equals("glossary_dir")) {
                if (++i >= arrayList.size()) break;
                xMLBlock = (XMLBlock)arrayList.get(i);
                this.m_glossary = this.computeAbsolutePath(xMLBlock.getText(), "glossary");
                continue;
            }
            if (xMLBlock.getTagName().equals("source_lang")) {
                if (++i >= arrayList.size()) break;
                xMLBlock = (XMLBlock)arrayList.get(i);
                if (xMLBlock == null) continue;
                this.m_sourceLocale = xMLBlock.getText();
                continue;
            }
            if (xMLBlock.getTagName().equals("target_lang")) {
                if (++i >= arrayList.size()) break;
                xMLBlock = (XMLBlock)arrayList.get(i);
                if (xMLBlock == null) continue;
                this.m_targetLocale = xMLBlock.getText();
                continue;
            }
            if (!xMLBlock.getTagName().equals("sentence_seg")) continue;
            if (++i >= arrayList.size()) break;
            xMLBlock = (XMLBlock)arrayList.get(i);
            if (xMLBlock == null) continue;
            this.m_sentenceSeg = xMLBlock.getText();
        }
    }

    private String computeAbsolutePath(String string, String string2) {
        if ("__DEFAULT__".equals(string)) {
            return this.m_root + string2 + File.separator;
        }
        try {
            File[] fileArray = File.listRoots();
            boolean bl = false;
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    bl = string.startsWith(fileArray[i].getCanonicalPath());
                }
                catch (IOException iOException) {
                    bl = false;
                }
                if (!bl) continue;
                return new File(string).getCanonicalPath() + File.separator;
            }
            return new File(this.m_root, string).getCanonicalPath() + File.separator;
        }
        catch (IOException iOException) {
            return string;
        }
    }

    private String computeRelativePath(String string, String string2) {
        if (string.equals(this.m_root + string2 + File.separator)) {
            return "__DEFAULT__";
        }
        try {
            String string3 = string;
            File file = new File(string).getCanonicalFile();
            File file2 = new File(this.m_root).getCanonicalFile();
            String string4 = new String();
            for (int i = 0; i < 2; ++i) {
                if ((file.getPath() + File.separator).startsWith(file2.getPath() + File.separator)) {
                    string3 = string4 + file.getPath().substring(file2.getPath().length());
                    if (!string3.startsWith(File.separator)) break;
                    string3 = string3.substring(1);
                    break;
                }
                file2 = file2.getParentFile();
                string4 = string4 + File.separator + "..";
            }
            return string3.replace(File.separatorChar, '/');
        }
        catch (IOException iOException) {
            return string.replace(File.separatorChar, '/');
        }
    }

    public void writeProjectFile(String string) throws IOException {
        this.m_root = string.substring(0, string.lastIndexOf(File.separator));
        this.m_root = this.m_root + File.separator;
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
        bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        bufferedWriter.write("<omegat>\n");
        bufferedWriter.write("  <project version=\"1.0\">\n");
        bufferedWriter.write("    <source_dir>" + this.computeRelativePath(this.m_source, "source") + "</source_dir>\n");
        bufferedWriter.write("    <target_dir>" + this.computeRelativePath(this.m_target, "target") + "</target_dir>\n");
        bufferedWriter.write("    <tm_dir>" + this.computeRelativePath(this.m_tm, "tm") + "</tm_dir>\n");
        bufferedWriter.write("    <glossary_dir>" + this.computeRelativePath(this.m_glossary, "glossary") + "</glossary_dir>\n");
        bufferedWriter.write("    <source_lang>" + this.m_sourceLocale + "</source_lang>\n");
        bufferedWriter.write("    <target_lang>" + this.m_targetLocale + "</target_lang>\n");
        bufferedWriter.write("    <sentence_seg>" + this.m_sentenceSeg + "</sentence_seg>\n");
        bufferedWriter.write("  </project>\n");
        bufferedWriter.write("</omegat>\n");
        bufferedWriter.close();
    }

    private void reset() {
        this.m_target = "";
        this.m_source = "";
        this.m_tm = "";
        this.m_glossary = "";
        this.m_sourceLocale = "";
        this.m_targetLocale = "";
        this.m_root = "";
    }

    public void setTarget(String string) {
        this.m_target = string;
    }

    public void setSource(String string) {
        this.m_source = string;
    }

    public void setTM(String string) {
        this.m_tm = string;
    }

    public void setGlossary(String string) {
        this.m_glossary = string;
    }

    public void setSourceLang(String string) {
        this.m_sourceLocale = string;
    }

    public void setTargetLang(String string) {
        this.m_targetLocale = string;
    }

    public String getTarget() {
        return this.m_target;
    }

    public String getSource() {
        return this.m_source;
    }

    public String getTM() {
        return this.m_tm;
    }

    public String getGlossary() {
        return this.m_glossary;
    }

    public String getSourceLang() {
        return this.m_sourceLocale;
    }

    public String getTargetLang() {
        return this.m_targetLocale;
    }

    public String getSentenceSeg() {
        return this.m_sentenceSeg;
    }

    public void setSentenceSeg(String string) {
        this.m_sentenceSeg = string;
    }
}

