package blanco.meta2xml.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.meta2xml.BlancoMeta2XmlConstants;
import blanco.meta2xml.BlancoMeta2XmlProcessMeta2Xml;
import blanco.meta2xml.BlancoMeta2XmlXml2JavaClass;
import blanco.meta2xml.task.valueobject.BlancoMeta2XmlProcessProcessInput;

public class BlancoMeta2XmlProcessProcessImpl implements
        BlancoMeta2XmlProcessProcess {

    public int execute(final BlancoMeta2XmlProcessProcessInput input)
            throws IOException, IllegalArgumentException {
        System.out.println("- " + BlancoMeta2XmlConstants.PRODUCT_NAME + " ("
                + BlancoMeta2XmlConstants.VERSION + ")");

        try {
            final File fileMetadir = new File(input.getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException("^fBNg["
                        + input.getMetadir() + "]݂܂B");
            }

            // e|fBNg쐬B
            new File(input.getTmpdir()
                    + BlancoMeta2XmlConstants.TARGET_SUBDIRECTORY).mkdirs();

            // w肳ꂽ^fBNg܂B
            final BlancoMeta2XmlProcessMeta2Xml meta2Xml = new BlancoMeta2XmlProcessMeta2Xml();
            meta2Xml.setCacheMeta2Xml(input.getCache().equals("true"));
            meta2Xml.processDirectory(fileMetadir, input.getTmpdir()
                    + BlancoMeta2XmlConstants.TARGET_SUBDIRECTORY);

            // XMLꂽ^t@CValueObject𐶐
            // ŏɃe|tH_𑖍
            final File fileWorkdir = new File(input.getTmpdir()
                    + BlancoMeta2XmlConstants.TARGET_SUBDIRECTORY);
            final File[] fileMeta2 = fileWorkdir.listFiles();
            if (fileMeta2 == null) {
                throw new IllegalArgumentException("[NfBNg["
                        + fileWorkdir.getAbsolutePath() + "]̃t@Cꗗ̎擾Ɏs܂B");
            }

            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoMeta2XmlXml2JavaClass().process(fileMeta2[index],
                        new File(input.getTargetdir()));
            }
            return 0;
        } catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (TransformerException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw e;
        }
    }
}
