/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.omegat.util.task;

import java.io.IOException;

import blanco.omegat.util.task.valueobject.BlancoOmegatTranslateXliffProcessInput;

/**
 * ob`NX [BlancoOmegatTranslateXliffBatchProcess]B
 *
 *
 * ob`̌ĂяoB
 * <code>
 * java -classpath (NXpX) blanco.omegat.util.task.BlancoOmegatTranslateXliffBatchProcess -help
 * </code>
 */
public class BlancoOmegatTranslateXliffBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoOmegatTranslateXliffBatchProcess batchProcess = new BlancoOmegatTranslateXliffBatchProcess();

        // ob`̈B
        final BlancoOmegatTranslateXliffProcessInput input = new BlancoOmegatTranslateXliffProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldTmxdirProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-tmxdir=")) {
                input.setTmxdir(arg.substring(8));
                isFieldTmxdirProcessed = true;
            } else if (arg.startsWith("-xliffdir=")) {
                input.setXliffdir(arg.substring(10));
            } else if (arg.startsWith("-xlifffile=")) {
                input.setXlifffile(arg.substring(11));
            } else if (arg.startsWith("-tool-id=")) {
                input.setToolId(arg.substring(9));
            } else if (arg.startsWith("-origin=")) {
                input.setOrigin(arg.substring(8));
            } else if (arg.startsWith("-skipiftargetexist=")) {
                input.setSkipiftargetexist(Boolean.valueOf(arg.substring(19)).booleanValue());
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoOmegatTranslateXliffBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldTmxdirProcessed == false) {
            System.out.println("BlancoOmegatTranslateXliffBatchProcess: JnsB̓p[^[input]̕K{tB[hl[tmxdir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoOmegatTranslateXliffProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoOmegatTranslateXliffProcessC^tF[X blanco.omegat.util.taskpbP[W BlancoOmegatTranslateXliffProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoOmegatTranslateXliffProcess process = new BlancoOmegatTranslateXliffProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoOmegatTranslateXliffProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoOmegatTranslateXliffBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoOmegatTranslateXliffBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoOmegatTranslateXliffBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoOmegatTranslateXliffBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoOmegatTranslateXliffBatchProcess: Usage:");
        System.out.println("  java blanco.omegat.util.task.BlancoOmegatTranslateXliffBatchProcess -verbose=l1 -tmxdir=l2 -xliffdir=l3 -xlifffile=l4 -tool-id=l5 -origin=l6 -skipiftargetexist=l7");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -tmxdir");
        System.out.println("      [TMX t@Ci[ĂfBNgB]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -xliffdir");
        System.out.println("      [́Eo͐ƂȂ OASIS XLIFF t@Ci[fBNgBxlifffileƔrpB]");
        System.out.println("      ^[]");
        System.out.println("    -xlifffile");
        System.out.println("      [́Eo͐ƂȂ OASIS XLIFF t@CBxliffdir ƔrpB]");
        System.out.println("      ^[]");
        System.out.println("    -tool-id");
        System.out.println("      [c[IDB]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[omegat]");
        System.out.println("    -origin");
        System.out.println("      [|󃁃̏oB]");
        System.out.println("      ^[]");
        System.out.println("    -skipiftargetexist");
        System.out.println("      [targetɂꍇɏXLbv邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoOmegatTranslateXliffProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getTmxdir() == null) {
            throw new IllegalArgumentException("BlancoOmegatTranslateXliffBatchProcess: JnsB̓p[^[input]̕K{tB[hl[tmxdir]ɒlݒ肳Ă܂B");
        }
    }
}
