/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xliff2tmx.task;

import java.io.File;
import java.io.IOException;

import blanco.commons.util.BlancoStringUtil;
import blanco.tmx.BlancoTmxSerializer;
import blanco.tmx.valueobject.BlancoTmx;
import blanco.tmx.valueobject.BlancoTmxTu;
import blanco.tmx.valueobject.BlancoTmxTuv;
import blanco.xliff.BlancoXliffUtil;
import blanco.xliff.valueobject.BlancoXliff;
import blanco.xliff.valueobject.BlancoXliffAltTrans;
import blanco.xliff.valueobject.BlancoXliffFile;
import blanco.xliff.valueobject.BlancoXliffTransUnit;
import blanco.xliff2tmx.task.valueobject.BlancoXliff2TmxProcessInput;

public class BlancoXliff2TmxProcessImpl implements BlancoXliff2TmxProcess {
    private BlancoXliff2TmxProcessInput fInput = null;

    public int execute(final BlancoXliff2TmxProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;

        final File sourceDir = new File(fInput.getSourcedir());
        if (sourceDir.exists() == false) {
            throw new IllegalArgumentException("w肳ꂽ sourcedir["
                    + sourceDir.getAbsolutePath() + "]݂͑܂B");
        }
        if (sourceDir.isDirectory() == false) {
            throw new IllegalArgumentException("w肳ꂽ sourcedir["
                    + sourceDir.getAbsolutePath() + "]̓fBNgł͂܂B");
        }

        final File targetDir = new File(fInput.getTargetdir());
        if (targetDir.exists() == false) {
            if (targetDir.mkdirs() == false) {
                throw new IllegalArgumentException("w肳ꂽ targetdir["
                        + targetDir.getAbsolutePath()
                        + "]݂Ȃ̂ō쐬݂܂s܂B");
            }
        }
        if (targetDir.isDirectory() == false) {
            throw new IllegalArgumentException("w肳ꂽ targetdir["
                    + targetDir.getAbsolutePath() + "]̓fBNgł͂܂B");
        }

        if (sourceDir.getCanonicalPath().equals(targetDir.getCanonicalPath())) {
            throw new IllegalArgumentException("sourcedir["
                    + sourceDir.getAbsolutePath() + "]  targetdir["
                    + targetDir.getAbsolutePath() + "] Ƃ͓fBNgłB");
        }

        final File[] sourceFiles = sourceDir.listFiles();
        if (sourceFiles == null) {
            return 0;
        }
        for (int index = 0; index < sourceFiles.length; index++) {
            if (sourceFiles[index].isFile() == false) {
                continue;
            }
            if (sourceFiles[index].getName().endsWith(".xlf")) {
                processXliff(sourceFiles[index], sourceDir);
            }
        }

        return 0;
    }

    private void processXliff(final File fileSource, final File sourceDir)
            throws IOException {
        final BlancoTmx tmx = new BlancoTmx();

        final String bundleSymbolicName = fileSource.getName().substring(0,
                fileSource.getName().length() - ".xlf".length());
        final BlancoXliff xliffSource = BlancoXliffUtil.getXliffInstance(
                fileSource.getParentFile(), bundleSymbolicName);

        for (int indexFile = 0; indexFile < xliffSource.getFileList().size(); indexFile++) {
            final BlancoXliffFile file = xliffSource.getFileList().get(
                    indexFile);
            for (int indexTransUnit = 0; indexTransUnit < file.getBody()
                    .getTransUnitList().size(); indexTransUnit++) {
                final BlancoXliffTransUnit sourceUnit = file.getBody()
                        .getTransUnitList().get(indexTransUnit);
                processUnit(sourceUnit, tmx);
            }
        }

        final BlancoTmxSerializer serializer = new BlancoTmxSerializer();
        serializer.serialize(tmx, new File(fInput.getTargetdir() + "/"
                + bundleSymbolicName + ".tmx"));
    }

    private void processUnit(final BlancoXliffTransUnit sourceUnit,
            final BlancoTmx tmx) {
        if (sourceUnit.getTranslate() == false) {
            return;
        }

        if (BlancoStringUtil.null2Blank(sourceUnit.getSource()).length() == 0) {
            return;
        }
        if (sourceUnit.getTarget() == null
                || BlancoStringUtil.null2Blank(
                        sourceUnit.getTarget().getTarget()).length() == 0) {
            return;
        }

        if (fInput.getCheckalttranspleiades()) {
            // ̒ǉI
            // Pleiades  |󂪈vĂ邱ƂmF鏈B
            boolean isEqualPleiades = false;
            for (int index = 0; index < sourceUnit.getAltTransList().size(); index++) {
                final BlancoXliffAltTrans altTrans = sourceUnit
                        .getAltTransList().get(index);
                if ("pleiades".equals(altTrans.getToolId()) == false) {
                    continue;
                }
                if (sourceUnit.getTarget().getTarget().equals(
                        altTrans.getTarget().getTarget())) {
                    isEqualPleiades = true;
                }
            }
            if (isEqualPleiades == false) {
                // PleiadesƈvȂ̂TMXΏۂ珜O܂B
                return;
            }
        }

        final BlancoTmxTu tu = new BlancoTmxTu();
        tu.setTuid(sourceUnit.getId());
        tmx.getBody().getTuList().add(tu);

        {
            final BlancoTmxTuv tuv = new BlancoTmxTuv();
            tu.getTuvList().add(tuv);
            tuv.setLang("en_US");
            tuv.setSeg(sourceUnit.getSource());
        }
        {
            final BlancoTmxTuv tuv = new BlancoTmxTuv();
            tu.getTuvList().add(tuv);
            tuv.setLang("ja_JP");
            tuv.setSeg(sourceUnit.getTarget().getTarget());
        }
    }
}
