/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipseplugingen.expand;

import java.io.File;
import java.util.List;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;

public class BlancoEclipsePluginGenExpandWizardPage {
    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    public final void expand(final Element elementCommon,
            final NodeList listList, final File directoryTarget) {
        final String pluginName = BlancoXmlUtil.getTextContent(elementCommon,
                "name");
        final String displayName = BlancoXmlUtil.getTextContent(elementCommon,
                "displayName");

        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");
        @SuppressWarnings("unused")
        final String description = BlancoXmlUtil.getTextContent(elementCommon,
                "description");

        final String className = "Abstract"
                + BlancoNameAdjuster.toClassName(pluginName) + "WizardPage";

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(directoryTarget.getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(packageName + ".wizards",
                "̃\[XR[h blanco FrameworkɂĎĂ܂B");

        fCgClass = fCgFactory.createClass(className, "");
        fCgSourceFile.getClassList().add(fCgClass);

        fCgClass.setAbstract(true);
        fCgClass.getExtendClassList().add(
                fCgFactory.createType("org.eclipse.jface.wizard.WizardPage"));

        fCgSourceFile.getImportList().add("org.eclipse.swt.SWT");
        fCgSourceFile.getImportList().add("org.eclipse.swt.layout.GridLayout");
        fCgSourceFile.getImportList()
                .add("org.eclipse.core.resources.IProject");
        fCgSourceFile.getImportList().add("org.eclipse.core.resources.IFile");

        fCgSourceFile.getImportList().add(
                packageName + "." + BlancoNameAdjuster.toClassName(pluginName)
                        + "PluginConstants");

        final BlancoCgField field1 = fCgFactory.createField("labelMessage1",
                "org.eclipse.swt.widgets.Label", "");
        fCgClass.getFieldList().add(field1);

        final BlancoCgField field2 = fCgFactory.createField("labelMessage2",
                "org.eclipse.swt.widgets.Label", "");
        fCgClass.getFieldList().add(field2);

        final BlancoCgField fieldSelection = fCgFactory.createField(
                "selection", "org.eclipse.jface.viewers.ISelection", "");
        fCgClass.getFieldList().add(fieldSelection);
        fieldSelection.setAccess("protected");

        {
            final BlancoCgMethod method = fCgFactory
                    .createMethod(className, "");
            fCgClass.getMethodList().add(method);
            method.setConstructor(true);

            method.getParameterList().add(
                    fCgFactory.createParameter("selection",
                            "org.eclipse.jface.viewers.ISelection", ""));

            final List<java.lang.String> listLine = method.getLineList();

            listLine.add("super(\"wizardPage\");");
            listLine.add("setTitle(\"" + displayName + " vOC pxEBU[h\");");
            listLine.add("this.selection = selection;");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod(
                    "createControl", "");
            fCgClass.getMethodList().add(method);

            method.getParameterList().add(
                    fCgFactory.createParameter("parent",
                            "org.eclipse.swt.widgets.Composite", ""));

            final List<java.lang.String> listLine = method.getLineList();

            listLine.add("GridLayout gridLayout = new GridLayout();");
            listLine.add("gridLayout.numColumns = 1;");
            listLine.add("");
            listLine
                    .add("Composite container = new Composite(parent, SWT.NULL);");
            listLine.add("container.setLayout(gridLayout);");
            listLine.add("");
            listLine.add("new Label(container, SWT.NONE).setText(\""
                    + displayName + " Wizardւ悤I\");");
            listLine.add("new Label(container, SWT.NONE).setText(\"̃EBU[h"
                    + displayName + "vOCp\ɂȂ܂ł̎菇`܂B\");");
            listLine.add("new Label(container, SWT.NONE).setText(\"\");");
            listLine
                    .add("new Label(container, SWT.NONE).setText(\"̃EBU[h̎傽ړÍAݒt@C(\" + "
                            + BlancoNameAdjuster.toClassName(pluginName)
                            + "PluginConstants.TARGET_FILENAME + \")vWFNg̃[gtH_ɍ쐬邱ƂłB\");");
            listLine
                    .add("new Label(container, SWT.NONE).setText(\"ݒt@C(\" + "
                            + BlancoNameAdjuster.toClassName(pluginName)
                            + "PluginConstants.TARGET_FILENAME + \")Ɋւ󋵂͉L̂悤ɂȂĂ܂B\");");
            listLine.add("");
            listLine.add("labelMessage1 = new Label(container, SWT.NONE);");
            listLine.add("labelMessage1.setText(\"  1.vWFNg̃[gtH_ \" + "
                    + BlancoNameAdjuster.toClassName(pluginName)
                    + "PluginConstants.TARGET_FILENAME + \"t@CVKɍ쐬܂B\");");
            listLine.add("labelMessage2 = new Label(container, SWT.NONE);");
            listLine
                    .add("labelMessage2.setText(\"  2.EBU[h(Finish)sƂɂVK\" + "
                            + BlancoNameAdjuster.toClassName(pluginName)
                            + "PluginConstants.TARGET_FILENAME + \"t@C쐬ĕҏWsƂł܂B\");");
            listLine.add("");
            listLine.add("setControl(container);");
            listLine.add("");
            listLine.add("IProject proj = "
                    + BlancoNameAdjuster.toClassName(pluginName)
                    + "Wizard.getProject(selection);");
            listLine.add("if (proj == null) {");
            listLine.add("setErrorMessage(\"vWFNgIł\");");
            listLine.add("setPageComplete(false);");
            listLine.add("labelMessage1.setText(\"  1.vWFNgIĂ܂B\");");
            listLine.add("labelMessage2.setText(\"  2.vWFNg̒ɂ \" + "
                    + BlancoNameAdjuster.toClassName(pluginName)
                    + "PluginConstants.TARGET_FILENAME + \"t@C͍쐬ł܂B\");");
            listLine.add("return;");
            listLine.add("}");
            listLine.add("");
            listLine.add("if (proj.isOpen() == false) {");
            listLine.add("setPageComplete(false);");
            listLine
                    .add("setErrorMessage(\"JĂvWFNgIĂAēxEBU[hsĂB\");");
            listLine
                    .add("labelMessage1.setText(\"  1.IꂽvWFNg͊JĂ܂B\");");
            listLine.add("labelMessage2.setText(\"  2.vWFNg̒ɂ \" + "
                    + BlancoNameAdjuster.toClassName(pluginName)
                    + "PluginConstants.TARGET_FILENAME + \"t@C͍쐬ł܂B\");");
            listLine.add("return;");
            listLine.add("}");
            listLine.add("");
            listLine.add("IFile file = proj.getFile("
                    + BlancoNameAdjuster.toClassName(pluginName)
                    + "PluginConstants.TARGET_FILENAME);");
            listLine.add("if (file.exists()) {");
            listLine.add("labelMessage1.setText(\"  1.ɃvWFNg̃[g \" + "
                    + BlancoNameAdjuster.toClassName(pluginName)
                    + "PluginConstants.TARGET_FILENAME + \"t@C݂Ă܂B\");");
            listLine
                    .add("labelMessage2.setText(\"  2.EBU[h(Finish)sƂɂ\" + "
                            + BlancoNameAdjuster.toClassName(pluginName)
                            + "PluginConstants.TARGET_FILENAME + \"t@C̕ҏWsƂł܂B\");");
            listLine.add("}");
        }

        // \[XR[hۂɐ܂B
        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }
}
