package blanco.xml.bind;

import java.util.Stack;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

import blanco.xml.bind.valueobject.BlancoXmlAttribute;
import blanco.xml.bind.valueobject.BlancoXmlCdata;
import blanco.xml.bind.valueobject.BlancoXmlCharacters;
import blanco.xml.bind.valueobject.BlancoXmlComment;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlDtd;
import blanco.xml.bind.valueobject.BlancoXmlElement;
import blanco.xml.bind.valueobject.BlancoXmlIgnorableWhitespace;
import blanco.xml.bind.valueobject.BlancoXmlLocator;
import blanco.xml.bind.valueobject.BlancoXmlPrefixMapping;

/**
 * RecnhłB
 * 
 * ̃NX XML/o[IuWFNg}bsO (X/O}bsO) blancoXmlBinding ̈ꕔłB<br>
 * ̃NX̓pbP[Wł̂ݗp\łB
 * 
 * @author IGA Tosiki
 */
class BlancoXmlUnmarshallerContentHandler implements ContentHandler,
        LexicalHandler {
    /**
     * ̂߂Ȃǂɕ̃LbVȂǂ܂Aނ눫܂B<br>
     * _ł͏׍H͂ɁẢPɒ͂邱ƂƂ܂B
     * 
     * ʂ̂Ȃ́Aȉ̂悤 Map 񋤗LB // private Map<String, String>
     * fStringMap = new HashMap<String, String>();
     */

    /**
     * [ghLgL܂B
     */
    final BlancoXmlDocument fDocument = new BlancoXmlDocument();

    /**
     * ݏ̃|CgL܂B
     */
    @SuppressWarnings("unchecked")
    private Stack fDocumentElementStack = new Stack();

    /**
     * RegnhIuWFNgVK쐬܂B
     */
    @SuppressWarnings("unchecked")
    public BlancoXmlUnmarshallerContentHandler() {
        fDocumentElementStack.push(fDocument);
    }

    /**
     * [ghLg擾܂B
     * 
     * @return
     */
    public BlancoXmlDocument getDocument() {
        return fDocument;
    }

    // ------------------------------------------------
    //  ContentHandler ̂߂̃\bhB
    // ------------------------------------------------

    public void startDocument() throws SAXException {
        // pushς݂łB
    }

    public void endDocument() throws SAXException {
        fDocumentElementStack.pop();
    }

    public void setDocumentLocator(final Locator argLocator) {
        final BlancoXmlLocator locator = new BlancoXmlLocator();

        // ݏ̃IuWFNg擾܂B
        final Object objCurrent = fDocumentElementStack.peek();
        if (objCurrent instanceof BlancoXmlDocument == false) {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshallerContentHandler: Documentł͂Ȃ̂ɑ΂ LocatorZbg悤Ƃ܂B");
        }

        ((BlancoXmlDocument) objCurrent).setLocator(locator);

        locator.setPublicId(argLocator.getPublicId());
        locator.setSystemId(argLocator.getSystemId());
        locator.setLineNumber(argLocator.getLineNumber());
        locator.setColumnNumber(argLocator.getColumnNumber());
    }

    public void startPrefixMapping(final String prefix, final String uri)
            throws SAXException {
        final BlancoXmlPrefixMapping prefixMapping = new BlancoXmlPrefixMapping();
        prefixMapping.setPrefix(prefix);
        prefixMapping.setUri(uri);

        // ݏ̃IuWFNg擾܂B
        final Object objCurrent = fDocumentElementStack.peek();
        if (objCurrent instanceof BlancoXmlDocument == false) {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshallerContentHandler: Documentł͂Ȃ̂ɑ΂ prefixMappingZbg悤Ƃ܂B");
        }

        ((BlancoXmlDocument) objCurrent).getPrefixMappings().add(prefixMapping);
    }

    public void endPrefixMapping(final String prefix) throws SAXException {
    }

    @SuppressWarnings("unchecked")
    public void startElement(final String uri, final String localName,
            final String qName, final Attributes atts) throws SAXException {
        final BlancoXmlElement element = new BlancoXmlElement();

        // ݏ̃IuWFNg擾܂B
        final Object objCurrent = fDocumentElementStack.peek();
        if (objCurrent instanceof BlancoXmlElement) {
            final BlancoXmlElement elementParent = ((BlancoXmlElement) objCurrent);
            elementParent.getChildNodes().add(element);
        } else if (objCurrent instanceof BlancoXmlDocument) {
            ((BlancoXmlDocument) objCurrent).getChildNodes().add(element);
        } else {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshallerContentHandler: z肳Ȃ^["
                            + objCurrent.getClass().getName()
                            + "]ɑ΂ Elementǉ悤Ƃ܂B");
        }

        // GgRs[܂B
        element.setUri(uri);
        element.setLocalName(localName);
        element.setQName(qName);

        // Agr[g̃Rs[s܂B
        copyAttributes(atts, element);

        fDocumentElementStack.push(element);
    }

    /**
     * Agr[g̃Rs[s܂B
     * 
     * @param atts
     *            ͂ƂȂAgr[gB
     * @param element
     *            ʐ̃GgB
     */
    private void copyAttributes(final Attributes atts,
            final BlancoXmlElement element) {
        final int attrLength = atts.getLength();
        for (int index = 0; index < attrLength; index++) {
            final BlancoXmlAttribute attribute = new BlancoXmlAttribute();
            element.getAtts().add(attribute);

            attribute.setUri(atts.getURI(index));
            attribute.setLocalName(atts.getLocalName(index));
            attribute.setQName(atts.getQName(index));
            attribute.setType(atts.getType(index));
            attribute.setValue(atts.getValue(index));
        }
    }

    public void endElement(final String uri, final String localName,
            final String qName) throws SAXException {
        fDocumentElementStack.pop();
    }

    public void characters(final char[] ch, final int start, final int length)
            throws SAXException {
        final BlancoXmlCharacters characters = new BlancoXmlCharacters();

        // ݏ̃IuWFNg擾܂B
        final Object objCurrent = fDocumentElementStack.peek();
        if (objCurrent instanceof BlancoXmlElement) {
            ((BlancoXmlElement) objCurrent).getChildNodes().add(characters);
        } else if (objCurrent instanceof BlancoXmlCdata) {
            ((BlancoXmlCdata) objCurrent).getChildNodes().add(characters);
        } else if (objCurrent instanceof BlancoXmlDocument) {
            ((BlancoXmlDocument) objCurrent).getChildNodes().add(characters);
        } else {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshallerContentHandler: z肳Ȃ^["
                            + objCurrent.getClass().getName()
                            + "]ɑ΂ Charactersǉ悤Ƃ܂B");
        }

        characters.setValue(new String(ch, start, length));
    }

    public void ignorableWhitespace(final char[] ch, final int start,
            final int length) throws SAXException {
        final BlancoXmlIgnorableWhitespace ignorableWhitespace = new BlancoXmlIgnorableWhitespace();

        // ݏ̃IuWFNg擾܂B
        final Object objCurrent = fDocumentElementStack.peek();
        if (objCurrent instanceof BlancoXmlElement) {
            ((BlancoXmlElement) objCurrent).getChildNodes().add(
                    ignorableWhitespace);
        } else if (objCurrent instanceof BlancoXmlCdata) {
            ((BlancoXmlDocument) objCurrent).getChildNodes().add(
                    ignorableWhitespace);
        } else if (objCurrent instanceof BlancoXmlDocument) {
            ((BlancoXmlDocument) objCurrent).getChildNodes().add(
                    ignorableWhitespace);
        } else {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshallerContentHandler: z肳Ȃ^["
                            + objCurrent.getClass().getName()
                            + "]ɑ΂ BlancoXmlIgnorableWhitespaceǉ悤Ƃ܂B");
        }

        ignorableWhitespace.setValue(new String(ch, start, length));
    }

    public void processingInstruction(final String target, final String data)
            throws SAXException {
        // ̃Cxg͌_ł̎dlł͖܂B
    }

    public void skippedEntity(final String name) throws SAXException {
        // ̃Cxg͌_ł̎dlł͖܂B
    }

    // ------------------------------------------------
    //  LexicalHandler ̂߂̃\bhB
    // ------------------------------------------------

    public void startDTD(final String name, final String publicId,
            final String systemId) throws SAXException {
        final BlancoXmlDtd dtd = new BlancoXmlDtd();

        // ݏ̃IuWFNg擾܂B
        final Object objCurrent = fDocumentElementStack.peek();
        if (objCurrent instanceof BlancoXmlDocument) {
            ((BlancoXmlDocument) objCurrent).getChildNodes().add(dtd);
        } else {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshallerContentHandler: z肳Ȃ^["
                            + objCurrent.getClass().getName()
                            + "]ɑ΂ BlancoXmlDtdǉ悤Ƃ܂B");
        }
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(final String name) throws SAXException {
        // ݂̎dlł́AT|[gOłB
    }

    public void endEntity(final String name) throws SAXException {
        // ݂̎dlł́AT|[gOłB
    }

    @SuppressWarnings("unchecked")
    public void startCDATA() throws SAXException {
        final BlancoXmlCdata cdata = new BlancoXmlCdata();

        // ݏ̃IuWFNg擾܂B
        final Object objCurrent = fDocumentElementStack.peek();
        if (objCurrent instanceof BlancoXmlElement) {
            final BlancoXmlElement elementParent = ((BlancoXmlElement) objCurrent);
            elementParent.getChildNodes().add(cdata);
        } else if (objCurrent instanceof BlancoXmlDocument) {
            ((BlancoXmlDocument) objCurrent).getChildNodes().add(cdata);
        } else {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshallerContentHandler: z肳Ȃ^["
                            + objCurrent.getClass().getName()
                            + "]ɑ΂ CDATAǉ悤Ƃ܂B");
        }

        fDocumentElementStack.push(cdata);
    }

    public void endCDATA() throws SAXException {
        fDocumentElementStack.pop();
    }

    public void comment(final char[] ch, final int start, final int length)
            throws SAXException {
        final BlancoXmlComment comment = new BlancoXmlComment();

        // ݏ̃IuWFNg擾܂B
        final Object objCurrent = fDocumentElementStack.peek();
        if (objCurrent instanceof BlancoXmlElement) {
            ((BlancoXmlElement) objCurrent).getChildNodes().add(comment);
        } else if (objCurrent instanceof BlancoXmlDocument) {
            ((BlancoXmlDocument) objCurrent).getChildNodes().add(comment);
        } else {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshallerContentHandler: z肳Ȃ^["
                            + objCurrent.getClass().getName()
                            + "]ɑ΂ BlancoXmlCommentǉ悤Ƃ܂B");
        }

        comment.setValue(new String(ch, start, length));
    }
}
