/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.html.parser;

import java.io.BufferedReader;
import java.io.IOException;

/**
 * htmlp[X邽߂̃NX̃C^tF[XB
 * 
 * @author IGA Tosiki
 */
public interface BlancoHtmlParser {
    /**
     * p[X̍ۂɗp郊[_[B
     * 
     * @return [_[B
     */
    BufferedReader getReader();

    /**
     * HTMLnh[Zbg܂B
     * 
     * @param handler
     *            HTMLnh[IuWFNgB
     */
    void setHandler(BlancoHtmlHandler handler);

    /**
     * HTMLnh[擾܂B
     * 
     * @return HTMLnh[IuWFNgB
     */
    BlancoHtmlHandler getHandler();

    /**
     * p[X̍ۂɗp镶GR[fBOݒ肵܂B
     * 
     * @param encoding
     *            GR[fBOB
     */
    void setEncoding(String encoding);

    /**
     * p[X̍ۂɗp镶GR[fBO擾܂B
     * 
     * @return GR[fBOB
     */
    String getEncoding();

    /**
     * ^ꂽhtmlp[X܂B
     * 
     * @param argInputHtml
     *            htmlB
     * @return p[XʏB(p[X킷o[IuWFNgENX)
     */
    void parse(byte[] argInputHtml) throws IOException;
}
