package blanco.html.parser;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;

class BlancoHtmlSerializerImpl implements BlancoHtmlSerializer {
    protected BufferedWriter fWriter;

    /**
     * vf̊JñN[YyfBOꂽ܂܂ǂB
     */
    protected boolean fIsStartElementClosePending = false;

    public BufferedWriter getWriter() {
        return fWriter;
    }

    public void setWriter(final BufferedWriter writer) {
        fWriter = writer;
    }

    /**
     * Gg̊JnB
     * 
     * HTMLƂ̂߁Astart  end ƂK΂ɔ܂B
     * 
     * @param name
     * @param attributes
     * @throws IOException
     */
    public void startElement(final String name,
            final List<BlancoHtmlAttribute> attrs) throws IOException {
        if (fWriter == null) {
            throw new IllegalArgumentException("܂O: C^[nullłB");
        }

        // JAB
        if (fIsStartElementClosePending) {
            fIsStartElementClosePending = false;
            fWriter.write('>');
        }

        fWriter.write('<');
        fWriter.write(name);

        for (BlancoHtmlAttribute attr : attrs) {
            fWriter.write(' ');
            fWriter.write(attr.getName());

            if (attr.getValue() != null) {
                fWriter.write('=');

                switch (attr.getQuote()) {
                case 0:
                    break;
                case 1:
                    fWriter.write('\'');
                    break;
                case 2:
                default:
                    fWriter.write('"');
                    break;
                }

                fWriter.write(attr.getValue());

                switch (attr.getQuote()) {
                case 0:
                    break;
                case 1:
                    fWriter.write('\'');
                    break;
                case 2:
                default:
                    fWriter.write('"');
                    break;
                }
            } else {
                // l̖B
            }
        }

        fIsStartElementClosePending = true;
    }

    /**
     * Gg̏IB
     * 
     * HTMLƂ̂߁Astart  end ƂK΂ɔ܂B
     * 
     * @param name
     * @throws IOException
     */
    public void endElement(final String name) throws IOException {
        if (fWriter == null) {
            throw new IllegalArgumentException("܂O: C^[nullłB");
        }

        if (fIsStartElementClosePending) {
            // ȃN[YB
            fIsStartElementClosePending = false;
            fWriter.write("/>");
        } else {
            fWriter.write("</");
            fWriter.write(name);
            fWriter.write('>');
        }
    }

    /**
     * B̎QƂȂǂ̏ĂȂ񂪁û܂܁v߂܂B
     * 
     * @param argCharacters
     * @throws IOException
     */
    public void characters(final String argCharacters) throws IOException {
        if (fWriter == null) {
            throw new IllegalArgumentException("܂O: C^[nullłB");
        }

        if (fIsStartElementClosePending) {
            // ȃN[YB
            fIsStartElementClosePending = false;
            fWriter.write('>');
        }

        fWriter.write(argCharacters);
    }

    /**
     * RgB̂܂܂̕񂪖߂܂B
     * 
     * @param argComments
     * @param argType
     * @throws IOException
     */
    public void comments(final String argComments, final int argType)
            throws IOException {
        if (fWriter == null) {
            throw new IllegalArgumentException("܂O: C^[nullłB");
        }

        if (fIsStartElementClosePending) {
            fIsStartElementClosePending = false;
            fWriter.write('>');
        }

        switch (argType) {
        case 0:
        default:
            fWriter.write("<!--");
            break;
        case 1:
            fWriter.write("<%--");
            break;
        }

        fWriter.write(argComments);

        switch (argType) {
        case 0:
        default:
            fWriter.write("-->");
            break;
        case 1:
            fWriter.write("-->");
            break;
        }
    }

    public void close() throws IOException {
        if (fIsStartElementClosePending) {
            fIsStartElementClosePending = false;
            fWriter.write('>');
        }

        if (fWriter != null) {
            fWriter.close();
        }
    }
}
