package blanco.html.parser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;

import junit.framework.TestCase;
import blanco.commons.util.BlancoFileUtil;

public class BlancoHtmlParserTest extends TestCase {
    public void testParser() throws Exception {
        final BlancoHtmlParser parser = BlancoHtmlParserFactory.getInstance();
        final BlancoHtmlSerializer serializer = BlancoHtmlSerializerFactory
                .getInstance();
        parser.setHandler(serializer);

        new File("tmp").mkdirs();
        serializer.setWriter(new BufferedWriter(new FileWriter(
                "./tmp/test001.html")));

        final byte[] fileData = BlancoFileUtil.file2Bytes(new File(
                "./test/data/test001.html"));

        parser.parse(fileData);

        serializer.close();
    }
}
