/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.html.parser.helper;

import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;

import blanco.commons.util.BlancoStringUtil;
import blanco.html.parser.BlancoHtmlContentHandler;
import blanco.html.parser.valueobject.BlancoHtmlAttribute;

/**
 *GR[fBO𔻒f HTMLRecnh[B
 * 
 * @author IGA Tosiki
 */
public class BlancoHtmlDecideEncodingContentHandler implements
        BlancoHtmlContentHandler {
    protected String fEncoding = null;

    /**
     * HTML 𒲂ׂʂ̕GR[fBO߂܂B
     * 
     * @return GR[fBOBȂꍇɂ nullB
     */
    public String getEncoding() {
        return fEncoding;
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
    }

    public void startElement(final String name,
            final List<BlancoHtmlAttribute> attrs) {
        if (BlancoStringUtil.null2Blank(name).toLowerCase().equals("meta")) {
            boolean isContentType = false;
            String content = null;
            for (BlancoHtmlAttribute attr : attrs) {
                if (attr.getName().toLowerCase().equals("http-equiv")) {
                    if ("content-type".equals(BlancoStringUtil.null2Blank(
                            attr.getValue()).toLowerCase())) {
                        // RecE^CvmetaƔB
                        isContentType = true;
                    }
                }

                if (attr.getName().toLowerCase().equals("content")) {
                    content = attr.getValue();
                }
            }

            if (isContentType) {
                final StringTokenizer token = new StringTokenizer(
                        BlancoStringUtil.null2Blank(content), "; ");
                for (; token.hasMoreTokens();) {
                    final String next = token.nextToken();

                    if (next.startsWith("charset=")) {
                        if (fEncoding == null) {
                            fEncoding = next.substring("charset=".length());
                        }
                    }
                }
            }
        }
    }

    public void endElement(final String name) {
    }

    public void characters(final String argCharacters) {
    }

    public void comments(final String argComments, final int argType) {
    }
}
