package blanco.html.parser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

import junit.framework.TestCase;
import blanco.commons.util.BlancoFileUtil;
import blanco.html.parser.helper.BlancoHtmlNullContentHandler;
import blanco.html.parser.valueobject.BlancoHtmlAttribute;

/**
 * attribute ̃p[X܂B
 * 
 * @author iga
 */
public class BlancoHtmlParserAttributeTest extends TestCase {
    class MyHandler extends BlancoHtmlNullContentHandler {
        public void startDocument() throws IOException {
            System.out.println("startDocument()");
        }

        public void endDocument() throws IOException {
            System.out.println("endDocument()");
        }

        public void startElement(final String name,
                final List<BlancoHtmlAttribute> attrs) {
            System.out.println("startElement(" + name + ", " + attrs.toString()
                    + ")");
        }

        public void endElement(final String name) {
            System.out.println("endElement(" + name + ")");
        }

        public void characters(final String argCharacters) {
            System.out.println("characters(" + argCharacters + ")");
        }

        public void comments(final String argComments, final int argType) {
            System.out.println("comments(" + argComments + ")");
        }
    }

    public void testParserAttr1() throws Exception {
        final BlancoHtmlParser parser = BlancoHtmlParserFactory.getInstance();

        final BlancoHtmlContentSerializer serializer = new BlancoHtmlContentSerializer();
        parser.setHandler(serializer);

        /**
         * NI[gỸAgr[g
         */
        final String htmlTestData = "<html><head><title>eXgf[^E^Cg</title></head><body><a href=http://sourceforge.jp/projects/blancofw/></a></body></html>";

        new File("tmp").mkdirs();
        serializer.setWriter(new BufferedWriter(new FileWriter(
                "./tmp/test001.html")));

        final byte[] fileData = htmlTestData.getBytes("Windows-31J");

        parser.parse(fileData);

        serializer.getWriter().close();

        final byte[] targetData = BlancoFileUtil.file2Bytes(new File(
                "./tmp/test001.html"));

        assertEquals(new String(fileData, "Windows-31J"), new String(
                targetData, "Windows-31J"));
    }

    public void testParserAttr2() throws Exception {
        final BlancoHtmlParser parser = BlancoHtmlParserFactory.getInstance();

        final BlancoHtmlContentSerializer serializer = new BlancoHtmlContentSerializer();
        parser.setHandler(serializer);

        /**
         * NI[gỸAgr[g
         */
        final String htmlTestData = "<tr height=10 style='uso-height-source:height:10.50pt'></tr>";

        new File("tmp").mkdirs();
        serializer.setWriter(new BufferedWriter(new FileWriter(
                "./tmp/test002.html")));

        final byte[] fileData = htmlTestData.getBytes("Windows-31J");

        parser.parse(fileData);

        serializer.getWriter().close();

        final byte[] targetData = BlancoFileUtil.file2Bytes(new File(
                "./tmp/test002.html"));

        assertEquals(
                "<tr height=10 style='uso-height-source:height:10.50pt'></tr>",
                new String(targetData, "Windows-31J"));
    }

    public void testParserAttr3() throws Exception {
        final BlancoHtmlParser parser = BlancoHtmlParserFactory.getInstance();

        final BlancoHtmlContentSerializer serializer = new BlancoHtmlContentSerializer();
        parser.setHandler(serializer);
        // parser.setHandler(new MyHandler());

        /**
         * Agr[g̏уAgr[g̉s邱Ƃ̊mFB
         */
        final String htmlTestData = "<html xmlns:a=\"urn:schemas-uso-com:vml\"\nxmlns:b=\"urn:schemas-uso-com:blanco\"\nxmlns=\"http://www.w3.org/TR/REC-html40\">";

        new File("tmp").mkdirs();
        serializer.setWriter(new BufferedWriter(new FileWriter(
                "./tmp/test003.html")));

        final byte[] fileData = htmlTestData.getBytes("Windows-31J");

        parser.parse(fileData);

        serializer.getWriter().close();

        final byte[] targetData = BlancoFileUtil.file2Bytes(new File(
                "./tmp/test003.html"));

        assertEquals(
                "<html xmlns:a=\"urn:schemas-uso-com:vml\" xmlns:b=\"urn:schemas-uso-com:blanco\" xmlns=\"http://www.w3.org/TR/REC-html40\">",
                new String(targetData, "Windows-31J"));
    }
}
