package blanco.html.parser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

import junit.framework.TestCase;
import blanco.commons.util.BlancoFileUtil;
import blanco.html.parser.helper.BlancoHtmlNullContentHandler;
import blanco.html.parser.valueobject.BlancoHtmlAttribute;

public class BlancoHtmlParserTest extends TestCase {
    class MyHandler extends BlancoHtmlNullContentHandler {
        public void startDocument() throws IOException {
            System.out.println("startDocument()");
        }

        public void endDocument() throws IOException {
            System.out.println("endDocument()");
        }

        public void startElement(final String name,
                final List<BlancoHtmlAttribute> attrs) {
            System.out.println("startElement(" + name + ", " + attrs.toString()
                    + ")");
        }

        public void endElement(final String name) {
            System.out.println("endElement(" + name + ")");
        }

        public void characters(final String argCharacters) {
            System.out.println("characters(" + argCharacters + ")");
        }

        public void comments(final String argComments, final int argType) {
            System.out.println("comments(" + argComments + ")");
        }
    }

    public void testParser() throws Exception {
        final BlancoHtmlParser parser = BlancoHtmlParserFactory.getInstance();
        // parser.setHandler(new MyHandler());

        final BlancoHtmlContentSerializer serializer = new BlancoHtmlContentSerializer();
        parser.setHandler(serializer);

        new File("tmp").mkdirs();
        serializer.setWriter(new BufferedWriter(new FileWriter(
                "./tmp/test001.html")));

        final byte[] fileData = BlancoFileUtil.file2Bytes(new File(
                "./test/data/test001.html"));

        parser.parse(fileData);

        serializer.getWriter().close();

        final byte[] targetData = BlancoFileUtil.file2Bytes(new File(
                "./tmp/test001.html"));

        assertEquals(new String(fileData, "Windows-31J"), new String(
                targetData, "Windows-31J"));
    }

    public void testParser01() throws Exception {
        final BlancoHtmlParser parser = BlancoHtmlParserFactory.getInstance();
        parser.setHandler(new MyHandler());

        final byte[] fileData = BlancoFileUtil.file2Bytes(new File(
                "./test/data/test001.html"));

        parser.parse(fileData);

        System.out.println("pGR[fBO:[" + parser.getEncoding() + "]");
    }
}
