/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.batchprocess;

import java.io.File;
import java.io.IOException;

import blanco.batchprocess.message.BlancoBatchProcessMessage;
import blanco.batchprocess.stringgroup.BlancoBatchProcessSupportedLangStringGroup;
import blanco.batchprocess.valueobject.BlancoBatchProcessStructure;

/**
 * uob``vExcellob`钊ېeNXE\[XR[h𐶐B
 * 
 * ̃NX́AXMLt@C\[XR[h@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoBatchProcessXml2SourceFile {
    /**
     * bZ[WNXB
     */
    protected final BlancoBatchProcessMessage fMsg = new BlancoBatchProcessMessage();

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * XMLt@C\[XR[h܂B
     * 
     * @param argMetaXmlSourceFile
     *            ^񂪊܂܂ĂXMLt@CB
     * @param argRuntimePackage
     *            ^CpbP[WBnullђ0̏̕ꍇ͒`ƂɃ^CNX𐶐B
     * @param argTargetLang
     *            o͑ΏۃvO~OB
     * @param argDirectoryTarget
     *            \[XR[hfBNg (/mainw肵܂)B
     * @throws IOException
     *             o͗OꍇB
     */
    public void process(final File argMetaXmlSourceFile,
            final String argRuntimePackage, final String argTargetLang,
            final File argDirectoryTarget) throws IOException {

        final BlancoBatchProcessStructure[] structures = new BlancoBatchProcessXmlParser()
                .parse(argMetaXmlSourceFile);
        if (structures == null || structures.length == 0) {
            // ȂB
            return;
        }

        for (int index = 0; index < structures.length; index++) {
            // ^̉͌ʂƂɃ\[XR[hs܂B
            structure2Source(structures[index], argRuntimePackage,
                    argTargetLang, argDirectoryTarget);
        }
    }

    /**
     * ^ꂽNXo[IuWFNgAJava\[XR[h܂B
     * 
     * @param argStructure
     *            B
     * @param argDirectoryTarget
     *            \[XR[h̏o͐fBNg
     * @throws IOException
     *             o͗OꍇB
     */
    public void structure2Source(
            final BlancoBatchProcessStructure argStructure,
            final String argRuntimePackage, final String argTargetLang,
            final File argDirectoryTarget) throws IOException {
        final int targetLang = new BlancoBatchProcessSupportedLangStringGroup()
                .convertToInt(argTargetLang);
        if (targetLang == BlancoBatchProcessSupportedLangStringGroup.NOT_DEFINED) {
            throw new IllegalArgumentException(fMsg.getMbbpi002(argTargetLang));
        }

        final BlancoBatchProcessExpandBatchProcess expandBatchProcess = new BlancoBatchProcessExpandBatchProcess();
        expandBatchProcess.setEncoding(fEncoding);
        expandBatchProcess.expandSourceFile(argStructure, argRuntimePackage,
                targetLang, argDirectoryTarget);

        final BlancoBatchProcessExpandProcess expandProcess = new BlancoBatchProcessExpandProcess();
        expandProcess.setEncoding(fEncoding);
        expandProcess.expandSourceFile(argStructure, argRuntimePackage,
                targetLang, argDirectoryTarget);
    }
}
