/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoHtmlFormatter]̃NX
 */
package blanco.html.formatter.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.html.formatter.task.valueobject.BlancoHtmlFormatterProcessInput;

/**
 * Apache Ant^XN [BlancoHtmlFormatter]̃NXB
 *
 * blancoHtmlFormatter  Ant ^XNB<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.html.formatter.task]BlancoHtmlFormatterBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancohtmlformatter&quot; classname=&quot;blanco.html.formatter.task.BlancoHtmlFormatterTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoHtmlFormatterTask extends Task {
    /**
     * blancoHtmlFormatter  Ant ^XNB
     */
    protected BlancoHtmlFormatterProcessInput fInput = new BlancoHtmlFormatterProcessInput();

    /**
     * blancoHtmlFormatter  Ant ^XNB
     */
    protected boolean fIsFieldSourcedirProcessed = false;

    /**
     * blancoHtmlFormatter  Ant ^XNB
     */
    protected boolean fIsFieldTargetdirProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[sourcedir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * HTMLt@Ci[Ă̓fBNgB<br>
     *
     * @param arg Zbgl
     */
    public void setSourcedir(final String arg) {
        fInput.setSourcedir(arg);
        fIsFieldSourcedirProcessed = true;
    }

    /**
     * Ant^XN[sourcedir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * HTMLt@Ci[Ă̓fBNgB<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getSourcedir() {
        return fInput.getSourcedir();
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * `ꂽHTMLt@Ci[o̓fBNgB<br>
     *
     * @param arg Zbgl
     */
    public void setTargetdir(final String arg) {
        fInput.setTargetdir(arg);
        fIsFieldTargetdirProcessed = true;
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * `ꂽHTMLt@Ci[o̓fBNgB<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetdir() {
        return fInput.getTargetdir();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    public final void execute() throws BuildException {
        System.out.println("BlancoHtmlFormatterTask begin.");

        // ڔԍ[1]AAgr[g[sourcedir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldSourcedirProcessed == false) {
            throw new BuildException("K{Agr[g[sourcedir]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[2]AAgr[g[targetdir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldTargetdirProcessed == false) {
            throw new BuildException("K{Agr[g[targetdir]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- sourcedir:[" + getSourcedir() + "]");
            System.out.println("- targetdir:[" + getTargetdir() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            // ̉ӏŃRpCG[ꍇABlancoHtmlFormatterProcessC^tF[X blanco.html.formatter.taskpbP[W BlancoHtmlFormatterProcessImplNX쐬邱Ƃɂłꍇ܂B
            final BlancoHtmlFormatterProcess proc = new BlancoHtmlFormatterProcessImpl();
            if (proc.execute(fInput) != BlancoHtmlFormatterBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
