/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.html.parser.util;

import java.util.ArrayList;
import java.util.List;

import blanco.html.parser.stringgroup.BlancoHtmlElementSpecTypeStringGroup;
import blanco.html.parser.valueobject.BlancoHtmlElementSpec;

/**
 * HTML vf̎dl̂߂̃[eBeBNXB
 * 
 * <P>
 * W3C̈ȉ̎dlɏĂ܂B
 * </P>
 * <code>
 * http://www.w3.org/TR/1999/REC-html401-19991224/index/elements.html
 * </code>
 */
public class BlancoHtmlElementSpecUtil {
    public static List<BlancoHtmlElementSpec> getSpecListInstance() {
        final List<BlancoHtmlElementSpec> list = new ArrayList<BlancoHtmlElementSpec>();
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("A");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("ABBR");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("ACRONYM");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("ADDRESS");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("APPLET");
            spec.setDepr(BlancoHtmlElementSpecTypeStringGroup.DEPRECATED);
            spec.setDtd(BlancoHtmlElementSpecTypeStringGroup.LOOSE_DTD);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("AREA");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.FORBIDDEN);
            spec.setEmpty(BlancoHtmlElementSpecTypeStringGroup.EMPTY);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("B");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("BASE");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.FORBIDDEN);
            spec.setEmpty(BlancoHtmlElementSpecTypeStringGroup.EMPTY);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("BASEFONT");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.FORBIDDEN);
            spec.setEmpty(BlancoHtmlElementSpecTypeStringGroup.EMPTY);
            spec.setDepr(BlancoHtmlElementSpecTypeStringGroup.DEPRECATED);
            spec.setDtd(BlancoHtmlElementSpecTypeStringGroup.LOOSE_DTD);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("BDO");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("BIG");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("BLOCKQUOTE");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("BODY");
            spec.setStartTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("BR");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.FORBIDDEN);
            spec.setEmpty(BlancoHtmlElementSpecTypeStringGroup.EMPTY);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("BUTTON");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("CAPTION");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("CENTER");
            spec.setDepr(BlancoHtmlElementSpecTypeStringGroup.DEPRECATED);
            spec.setDtd(BlancoHtmlElementSpecTypeStringGroup.LOOSE_DTD);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("CITE");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("CODE");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("COL");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.FORBIDDEN);
            spec.setEmpty(BlancoHtmlElementSpecTypeStringGroup.EMPTY);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("COLGROUP");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("DD");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("DEL");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("DFN");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("DIR");
            spec.setDepr(BlancoHtmlElementSpecTypeStringGroup.DEPRECATED);
            spec.setDtd(BlancoHtmlElementSpecTypeStringGroup.LOOSE_DTD);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("DIV");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("DL");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("DT");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("EM");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("FIELDSET");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("FONT");
            spec.setDepr(BlancoHtmlElementSpecTypeStringGroup.DEPRECATED);
            spec.setDtd(BlancoHtmlElementSpecTypeStringGroup.LOOSE_DTD);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("FORM");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("FRAME");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.FORBIDDEN);
            spec.setEmpty(BlancoHtmlElementSpecTypeStringGroup.EMPTY);
            spec.setDtd(BlancoHtmlElementSpecTypeStringGroup.FRAMESET_DTD);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("FRAMESET");
            spec.setDtd(BlancoHtmlElementSpecTypeStringGroup.FRAMESET_DTD);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("H1");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("H2");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("H3");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("H4");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("H5");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("H6");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("HEAD");
            spec.setStartTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("HR");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.FORBIDDEN);
            spec.setEmpty(BlancoHtmlElementSpecTypeStringGroup.EMPTY);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("HTML");
            spec.setStartTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("I");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("IFRAME");
            spec.setDtd(BlancoHtmlElementSpecTypeStringGroup.LOOSE_DTD);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("IMG");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.FORBIDDEN);
            spec.setEmpty(BlancoHtmlElementSpecTypeStringGroup.EMPTY);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("INPUT");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.FORBIDDEN);
            spec.setEmpty(BlancoHtmlElementSpecTypeStringGroup.EMPTY);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("INS");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("ISINDEX");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.FORBIDDEN);
            spec.setEmpty(BlancoHtmlElementSpecTypeStringGroup.EMPTY);
            spec.setDepr(BlancoHtmlElementSpecTypeStringGroup.DEPRECATED);
            spec.setDtd(BlancoHtmlElementSpecTypeStringGroup.LOOSE_DTD);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("KBD");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("LABEL");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("LEGEND");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("LI");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("LINK");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.FORBIDDEN);
            spec.setEmpty(BlancoHtmlElementSpecTypeStringGroup.EMPTY);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("MAP");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("MENU");
            spec.setDepr(BlancoHtmlElementSpecTypeStringGroup.DEPRECATED);
            spec.setDtd(BlancoHtmlElementSpecTypeStringGroup.LOOSE_DTD);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("META");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.FORBIDDEN);
            spec.setEmpty(BlancoHtmlElementSpecTypeStringGroup.EMPTY);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("NOFRAMES");
            spec.setDtd(BlancoHtmlElementSpecTypeStringGroup.FRAMESET_DTD);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("NOSCRIPT");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("OBJECT");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("OL");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("OPTGROUP");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("OPTION");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("P");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("PARAM");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.FORBIDDEN);
            spec.setEmpty(BlancoHtmlElementSpecTypeStringGroup.EMPTY);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("PRE");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("Q");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("S");
            spec.setDepr(BlancoHtmlElementSpecTypeStringGroup.DEPRECATED);
            spec.setDtd(BlancoHtmlElementSpecTypeStringGroup.LOOSE_DTD);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("SAMP");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("SCRIPT");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("SELECT");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("SMALL");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("SPAN");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("STRIKE");
            spec.setDepr(BlancoHtmlElementSpecTypeStringGroup.DEPRECATED);
            spec.setDtd(BlancoHtmlElementSpecTypeStringGroup.LOOSE_DTD);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("STRONG");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("STYLE");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("SUB");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("SUP");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("TABLE");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("TBODY");
            spec.setStartTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("TD");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("TEXTAREA");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("TFOOT");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("TH");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("THEAD");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("TITLE");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("TR");
            spec.setEndTag(BlancoHtmlElementSpecTypeStringGroup.OPTIONAL);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("TT");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("U");
            spec.setDepr(BlancoHtmlElementSpecTypeStringGroup.DEPRECATED);
            spec.setDtd(BlancoHtmlElementSpecTypeStringGroup.LOOSE_DTD);
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("UL");
        }
        {
            final BlancoHtmlElementSpec spec = new BlancoHtmlElementSpec();
            list.add(spec);
            spec.setName("VAR");
        }

        validateSpecList(list);

        return list;
    }

    public static void validateSpecList(final List<BlancoHtmlElementSpec> list) {
        for (BlancoHtmlElementSpec spec : list) {
            switch (spec.getStartTag()) {
            case BlancoHtmlElementSpecTypeStringGroup.DEFAULT:
            case BlancoHtmlElementSpecTypeStringGroup.OPTIONAL:
                break;
            default:
                throw new IllegalArgumentException("StartTag ɎwłȂl("
                        + spec.getStartTag() + ")ݒ肳Ă܂");
            }

            switch (spec.getEndTag()) {
            case BlancoHtmlElementSpecTypeStringGroup.DEFAULT:
            case BlancoHtmlElementSpecTypeStringGroup.OPTIONAL:
            case BlancoHtmlElementSpecTypeStringGroup.FORBIDDEN:
                break;
            default:
                throw new IllegalArgumentException("EndTag ɎwłȂl("
                        + spec.getEndTag() + ")ݒ肳Ă܂");
            }

            switch (spec.getEmpty()) {
            case BlancoHtmlElementSpecTypeStringGroup.DEFAULT:
            case BlancoHtmlElementSpecTypeStringGroup.EMPTY:
                break;
            default:
                throw new IllegalArgumentException("Empty ɎwłȂl("
                        + spec.getEmpty() + ")ݒ肳Ă܂");
            }

            switch (spec.getDepr()) {
            case BlancoHtmlElementSpecTypeStringGroup.DEFAULT:
            case BlancoHtmlElementSpecTypeStringGroup.DEPRECATED:
                break;
            default:
                throw new IllegalArgumentException("Depr ɎwłȂl("
                        + spec.getDepr() + ")ݒ肳Ă܂");
            }

            switch (spec.getDtd()) {
            case BlancoHtmlElementSpecTypeStringGroup.DEFAULT:
            case BlancoHtmlElementSpecTypeStringGroup.LOOSE_DTD:
            case BlancoHtmlElementSpecTypeStringGroup.FRAMESET_DTD:
                break;
            default:
                throw new IllegalArgumentException("Dtd ɎwłȂl("
                        + spec.getDtd() + ")ݒ肳Ă܂");
            }
        }
    }

    /**
     * eXgp̃Gg|CgB
     * 
     * @param args
     */
    public static void main(final String[] args) {
        final List<BlancoHtmlElementSpec> list = getSpecListInstance();
        for (BlancoHtmlElementSpec spec : list) {
            final BlancoHtmlElementSpecTypeStringGroup specTypeGroup = new BlancoHtmlElementSpecTypeStringGroup();
            System.out.println(spec.getName() + "\t"
                    + specTypeGroup.convertToString(spec.getStartTag()) + "\t"
                    + specTypeGroup.convertToString(spec.getEndTag()) + "\t"
                    + specTypeGroup.convertToString(spec.getEmpty()) + "\t"
                    + specTypeGroup.convertToString(spec.getDepr()) + "\t"
                    + specTypeGroup.convertToString(spec.getDtd()));
        }
    }
}
