/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.html.parser.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

import blanco.html.parser.BlancoHtmlParser;
import blanco.html.parser.BlancoHtmlParserFactory;
import blanco.html.parser.helper.BlancoHtmlDecideEncodingContentHandler;

public class BlancoHtmlParserUtil {
    /**
     * vf̂Ȃ̑ɂẴzCgXy[X𔻒肵܂B
     * 
     * @param cRead
     *            肵B
     * @return zCgXy[XȂtrueB
     */
    public static boolean isWhiteSpace(final char cRead) {
        switch (cRead) {
        case ' ':// 0x20: SPACE
        case '\t': // 0x09: TAB
        case '\f':// 0x0c: FF
        case '\r':// 0x0d (line break)
        case '\n': // 0x0a (line break)
            return true;
        default:
            return false;
        }
    }

    /**
     * HTML̕R[hȂ܂B
     * 
     * @param argInputHtml
     * @return 茋ʂ̕GR[fBOB
     * @throws IOException
     */
    public static String decideEncoding(final byte[] argInputHtml)
            throws IOException {
        final BlancoHtmlParser encodingParser = BlancoHtmlParserFactory
                .getInstance();
        final BlancoHtmlDecideEncodingContentHandler encodingHandler = new BlancoHtmlDecideEncodingContentHandler();
        encodingParser.setHandler(encodingHandler);

        encodingParser.parse(new BufferedReader(new InputStreamReader(
                new ByteArrayInputStream(argInputHtml), "ISO8859_1")));
        if (encodingHandler.getEncoding() != null) {
            // TODO JavaT|[gȂR[h^ꂽꍇ̗OB
            // TODO Shift_JIS Ɨ Windows-31J ɓǂݑւAȂǂ̂ŽKvB
            // TODO {_IɁAHTML̃GR[fBO ۂ
            // JavavO~Oňۂ̃GR[fBOƂ͕člKv悤ɎvB
            return encodingHandler.getEncoding();
        } else {
            // Ȃ̂Ō߂B
            // TODO zIɂ́A̕GR[fBOœĂĂ݂āAƂ ?
            // Ȃ̗̂pAȂǂ̏ʓr̂ǂƍlB
            return "Windows-31J";
        }
    }
}
