/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.html.normalizer.parser.helper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.List;

import junit.framework.TestCase;
import blanco.commons.util.BlancoFileUtil;
import blanco.html.normalizer.parser.BlancoHtmlEventListSerializer;
import blanco.html.normalizer.parser.valueobject.BlancoHtmlEvent;
import blanco.html.normalizer.util.BlancoHtmlNormalizerUtil;
import blanco.html.parser.BlancoHtmlParser;
import blanco.html.parser.BlancoHtmlParserFactory;

public class BlancoHtmlEventParserContentHandlerTest extends TestCase {
    public void test001() throws Exception {
        final BlancoHtmlEventParserContentHandler handler = new BlancoHtmlEventParserContentHandler();

        new File("tmp").mkdirs();

        // ̓f[^B
        final byte[] inputData = BlancoFileUtil.file2Bytes(new File(
                "./test/data/test001.html"));

        // HTML̃GR[fBO擾B
        final BlancoHtmlParser encodingParser = BlancoHtmlParserFactory
                .getInstance();
        encodingParser.parse(inputData);

        final BlancoHtmlParser parser = BlancoHtmlParserFactory.getInstance();
        parser.setHandler(handler);

        parser.parse(BlancoHtmlNormalizerUtil.normalize(inputData));

        final List<BlancoHtmlEvent> eventList = handler.getEventList();

        new File("./tmp").mkdirs();
        new BlancoHtmlEventListSerializer().serialize(eventList,
                new BufferedWriter(new OutputStreamWriter(new FileOutputStream(
                        "./tmp/aaa.html"), encodingParser.getEncoding())));
    }
}
