package blanco.html.parser;

import java.io.File;

import junit.framework.TestCase;
import blanco.commons.util.BlancoFileUtil;

/**
 * attribute ̃p[X܂B
 * 
 * @author iga
 */
public class BlancoHtmlParserAttributeTest extends TestCase {
    public void testParserAttr001() throws Exception {
        new File("tmp").mkdirs();

        /**
         * NI[gỸAgr[g
         */
        final String htmlTestData = "<html><head><title>eXgf[^E^Cg</title></head><body><a href=http://sourceforge.jp/projects/blancofw/></a></body></html>";
        final byte[] inputData = htmlTestData.getBytes("Windows-31J");

        // HTML̃GR[fBO擾B
        final BlancoHtmlParser encodingParser = BlancoHtmlParserFactory
                .getInstance();
        encodingParser.parse(inputData);

        final BlancoHtmlContentSerializer serializer = new BlancoHtmlContentSerializer();
        serializer.setWriter(BlancoHtmlParserTestUtil.getWriter(new File(
                "./tmp/testAttr001.html"), encodingParser.getEncoding()));

        final BlancoHtmlParser parser = BlancoHtmlParserFactory.getInstance();
        parser.setHandler(serializer);
        parser.setLexicalHandler(serializer);
        parser.setDTDHandler(serializer);

        parser.parse(inputData);
        serializer.getWriter().close();

        final byte[] outputData = BlancoFileUtil.file2Bytes(new File(
                "./tmp/testAttr001.html"));
        assertEquals(new String(inputData, "Windows-31J"), new String(
                outputData, "Windows-31J"));
    }

    public void testParserAttr002() throws Exception {
        new File("tmp").mkdirs();

        /**
         * NI[gỸAgr[g
         */
        final String htmlTestData = "<tr height=10 style='uso-height-source:height:10.50pt'></tr>";
        final byte[] inputData = htmlTestData.getBytes("Windows-31J");

        // HTML̃GR[fBO擾B
        final BlancoHtmlParser encodingParser = BlancoHtmlParserFactory
                .getInstance();
        encodingParser.parse(inputData);

        final BlancoHtmlContentSerializer serializer = new BlancoHtmlContentSerializer();
        serializer.setWriter(BlancoHtmlParserTestUtil.getWriter(new File(
                "./tmp/testAttr002.html"), encodingParser.getEncoding()));

        final BlancoHtmlParser parser = BlancoHtmlParserFactory.getInstance();
        parser.setHandler(serializer);
        parser.setLexicalHandler(serializer);
        parser.setDTDHandler(serializer);

        parser.parse(inputData);
        serializer.getWriter().close();

        final byte[] outputData = BlancoFileUtil.file2Bytes(new File(
                "./tmp/testAttr002.html"));
        assertEquals(
                "<tr height=10 style='uso-height-source:height:10.50pt'></tr>",
                new String(outputData, "Windows-31J"));
    }

    public void testParserAttr003() throws Exception {
        new File("tmp").mkdirs();

        /**
         * Agr[g̏уAgr[g̉s邱Ƃ̊mFB
         */
        final String htmlTestData = "<html xmlns:a=\"urn:schemas-uso-com:vml\"\nxmlns:b=\"urn:schemas-uso-com:blanco\"\nxmlns=\"http://www.w3.org/TR/REC-html40\">";
        final byte[] inputData = htmlTestData.getBytes("Windows-31J");

        // HTML̃GR[fBO擾B
        final BlancoHtmlParser encodingParser = BlancoHtmlParserFactory
                .getInstance();
        encodingParser.parse(inputData);

        final BlancoHtmlContentSerializer serializer = new BlancoHtmlContentSerializer();
        serializer.setWriter(BlancoHtmlParserTestUtil.getWriter(new File(
                "./tmp/testAttr003.html"), encodingParser.getEncoding()));

        final BlancoHtmlParser parser = BlancoHtmlParserFactory.getInstance();
        parser.setHandler(serializer);
        parser.setLexicalHandler(serializer);
        parser.setDTDHandler(serializer);

        parser.parse(inputData);
        serializer.getWriter().close();

        final byte[] outputData = BlancoFileUtil.file2Bytes(new File(
                "./tmp/testAttr003.html"));
        assertEquals(
                "<html xmlns:a=\"urn:schemas-uso-com:vml\" xmlns:b=\"urn:schemas-uso-com:blanco\" xmlns=\"http://www.w3.org/TR/REC-html40\">",
                new String(outputData, "Windows-31J"));
    }
}
