/*
 * blanco Framework
 * Copyright (C) 2004-2008 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.svnconf;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;

import blanco.commons.util.BlancoFileUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.svnconf.message.BlancoSvnConfMessage;
import blanco.svnconf.valueobject.BlancoSvnConfStructure;

/**
 * uSubversion|Wg`vExcellApachep conft@C𐶐B
 * 
 * ̃NX́AXMLt@Cݒt@C@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoSvnConfXml2ApacheConfFile {
    public static final String CMDLINE_PREFIX = "svnconf: ";

    /**
     * bZ[W`B
     */
    protected final BlancoSvnConfMessage fMsg = new BlancoSvnConfMessage();

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * w̃V[g̋LqeWJ܂B
     * 
     * @param argStructures
     *            ^XN̍\̔zB
     * @param argDirectoryTarget
     *            o͐fBNg
     */
    public void structures2File(final BlancoSvnConfStructure[] argStructures,
            final File argDirectoryTarget) {
        final File dirBlancoApacheConf = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/apache.conf/extra");
        dirBlancoApacheConf.mkdirs();
        final File fileApacheConf = new File(dirBlancoApacheConf
                .getAbsolutePath()
                + "/httpd-svn.conf");
        expandApacheConf(argStructures, fileApacheConf);
    }

    /**
     * Apache HTTP Serverp̐ݒt@C𐶐܂B
     * 
     * @param argStructures
     *            \̏̔zB
     * @param argTarget
     *            o͐t@CB
     */
    private void expandApacheConf(final BlancoSvnConfStructure[] argStructures,
            final File argTarget) {
        if (argStructures.length == 0) {
            // ꌏ܂B
            return;
        }

        final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            BufferedWriter writer = null;
            if (BlancoStringUtil.null2Blank(fEncoding).length() == 0) {
                writer = new BufferedWriter(new OutputStreamWriter(outStream));
            } else {
                writer = new BufferedWriter(new OutputStreamWriter(outStream,
                        fEncoding));
            }

            writeHead(argStructures, writer);
            writer.newLine();

            writeBody(argStructures, writer);

            writeEndOfFile(writer);

            writer.close();
        } catch (IOException ex) {
            // 
            ex.printStackTrace();
        }

        try {
            switch (BlancoFileUtil.bytes2FileIfNecessary(outStream
                    .toByteArray(), argTarget)) {
            case 1:
                System.out.println(CMDLINE_PREFIX + "create: "
                        + argTarget.getAbsolutePath());
                break;
            case 2:
                System.out.println(CMDLINE_PREFIX + "update: "
                        + argTarget.getAbsolutePath());
                break;
            }
        } catch (IOException e) {
            // TODO ꂽ catch ubN
            e.printStackTrace();
        }
    }

    /**
     * ݒt@Cwbḧ̏oB
     * 
     * @param argStructures
     *            \̏̔zB
     * @param writer
     *            o͐惉C^[B
     * @throws IOException
     *             o͗OꍇB
     */
    private void writeHead(final BlancoSvnConfStructure[] argStructures,
            final BufferedWriter writer) throws IOException {
        writer
                .write("############################################################");
        writer.newLine();
        writer.write("# <<apache>/conf/extra/httpd-svn.conf>");
        writer.newLine();
        writer.write("#");
        writer.newLine();
        writer.write("# Subversion|Wg`B");
        writer.newLine();
        writer.write("#");
        writer.newLine();
        writer.write("# zXg: " + argStructures[0].getHostname());
        writer.newLine();
        writer.write("#");
        writer.newLine();
        writer.write("# ̃t@CL邽߂ɂ́AApache  httpd.conf t@CɈȉ̍sǉ܂B");
        writer.newLine();
        writer.write("# Include conf/extra/httpd-svn.conf");
        writer.newLine();
        writer
                .write("############################################################");
        writer.newLine();
    }

    /**
     * ݒt@C{̗̈̏oB
     * 
     * @param argStructures
     *            \̏̔zB
     * @param writer
     *            o͐惉C^[B
     * @throws IOException
     *             o͗OꍇB
     */
    private void writeBody(final BlancoSvnConfStructure[] argStructures,
            final BufferedWriter writer) throws IOException {
        BlancoSvnConfStructure pastStructure = null;
        for (int index = 0; index < argStructures.length; index++) {
            if (pastStructure == null) {
                pastStructure = argStructures[index];
            }
            if (pastStructure.getHostname().equals(
                    argStructures[index].getHostname()) == false) {
                // zXgႢ𔭌B
                throw new IllegalArgumentException(fMsg.getMbsvnc07(
                        pastStructure.getName(), pastStructure.getHostname(),
                        argStructures[index].getName(), argStructures[index]
                                .getHostname()));
            }

            writer.write("########################################");
            writer.newLine();
            writer.write("# |Wg`ID: " + argStructures[index].getName());
            writer.newLine();
            writer.write("# zURL: http://"
                    + argStructures[index].getHostname() + "/svn/"
                    + argStructures[index].getName() + "/");
            writer.newLine();
            if (BlancoStringUtil.null2Blank(
                    argStructures[index].getDescription()).length() > 0) {
                writer.write("# : " + argStructures[index].getDescription());
                writer.newLine();
            }

            writer.write("<Location /svn/" + argStructures[index].getName()
                    + ">");
            writer.newLine();

            writer.write("    DAV                svn");
            writer.newLine();
            writer.write("    SVNPath            \""
                    + argStructures[index].getBaseDirectory() + "/"
                    + argStructures[index].getName() + "\"");
            writer.newLine();
            writer.write("    AuthzSVNAccessFile \""
                    + argStructures[index].getBaseDirectory() + ".conf/"
                    + argStructures[index].getName() + ".svnauthz\"");
            writer.newLine();
            writer.write("</Location>");
            writer.newLine();
            writer.newLine();
        }
    }

    /**
     * end of file ̈̏oB
     * 
     * @param writer
     *            o͐惉C^[B
     * @throws IOException
     *             o͗OꍇB
     */
    private void writeEndOfFile(final BufferedWriter writer) throws IOException {
        writer.write("####################");
        writer.newLine();
        writer.write("# end of file");
        writer.newLine();
        writer.write("####################");
        writer.newLine();
    }
}
