/*
 * blanco Framework
 * Copyright (C) 2004-2008 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xml.bind;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;

import org.xml.sax.SAXException;

import blanco.commons.util.BlancoStringUtil;
import blanco.xml.bind.valueobject.BlancoXmlDocument;

/**
 * blancoXmlBinding ̃o[IuWFNg\ XML 𐶐邽߂̃NXłB
 * 
 * ̃NX XML/o[IuWFNg}bsO (X/O}bsO) blancoXmlBinding ̈ꕔłB
 * 
 * @author IGA Tosiki
 */
public class BlancoXmlMarshaller {
    /**
     * Iɗpo͗pSAXnh
     * 
     * ÃXg[͊OcloseȂǂ̏{Kv܂B
     */
    private TransformerHandler fSaxHandler;

    /**
     * JavaIuWFNgXML𐶐܂B
     * 
     * @param document
     *            blancoXmlƂẴIuWFNgB
     * @param outFile
     *            XMLo͐t@CB
     */
    public void marshal(final BlancoXmlDocument document, final File outFile) {
        if (document == null) {
            throw new IllegalArgumentException(
                    "BlancoXmlMarshaller: XMLhLgnulln܂B");
        }
        if (outFile == null) {
            throw new IllegalArgumentException(
                    "BlancoXmlMarshaller: o͐XMLt@Cnulln܂B");
        }
        if (outFile.exists()) {
            if (outFile.canWrite() == false) {
                throw new IllegalArgumentException(
                        "BlancoXmlMarshaller: o͐XMLt@C͏݂ł܂B");
            }
        }

        try {
            final OutputStream outStream = new BufferedOutputStream(
                    new FileOutputStream(outFile));
            try {
                marshal(document, outStream);

                outStream.flush();
            } finally {
                outStream.close();
            }
        } catch (IOException ex) {
            throw new IllegalArgumentException(
                    "BlancoXmlMarshaller: t@Co͂Ɏs܂B" + ex.toString());
        }
    }

    /**
     * JavaIuWFNgXML𐶐܂B
     * 
     * Ql:
     * http://java.sun.com/webservices/docs/1.6/api/javax/xml/bind/Marshaller
     * .html
     * 
     * @param document
     *            blancoXmlƂẴIuWFNgB
     * @param outStream
     *            XMLo͐Xg[B
     */
    public void marshal(final BlancoXmlDocument document,
            final OutputStream outStream) {
        final TransformerFactory tf = TransformerFactory.newInstance();
        final SAXTransformerFactory saxTf = (SAXTransformerFactory) tf;
        try {
            fSaxHandler = saxTf.newTransformerHandler();
            if (BlancoStringUtil.null2Blank(document.getVersion()).length() > 0) {
                fSaxHandler.getTransformer().setOutputProperty("version",
                        document.getVersion());
            }
            if (BlancoStringUtil.null2Blank(document.getEncoding()).length() > 0) {
                fSaxHandler.getTransformer().setOutputProperty("encoding",
                        document.getEncoding());
            }
        } catch (TransformerConfigurationException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(
                    "BlancoXmlMarshaller: gXtH[}[nhɎs܂B"
                            + e.toString());
        }

        fSaxHandler.setResult(new StreamResult(outStream));

        try {
            new BlancoXmlMarshallerSerializer(fSaxHandler).serialize(document);
        } catch (SAXException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(
                    "BlancoXmlMarshaller: IuWFNgXML̕ϊ̉ߒŗO܂B"
                            + e.toString());
        }

        // ŌɃnhJ܂B
        fSaxHandler = null;
    }
}
