/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.html.parser;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

import blanco.commons.util.BlancoStringUtil;
import blanco.html.parser.util.BlancoHtmlCharacterEntitySetUtil;
import blanco.html.parser.valueobject.BlancoHtmlAttribute;
import blanco.xml.bind.BlancoXmlAttributesImpl;
import blanco.xml.bind.valueobject.BlancoXmlAttribute;

/**
 * HTML   XML  SAX ̂悤Ƀp[XʓꂽCxgVACY邽߂̃VACU[B
 * 
 * ̃RecEnh[pƁACxgēx HTML ɏ߂Ƃł܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoHtmlContentSerializer implements ContentHandler,
        LexicalHandler, DTDHandler {
    protected static final Map<String, String> fMapValue2Name = BlancoHtmlCharacterEntitySetUtil
            .getValue2NameMap();

    /**
     * o͐ƂȂ郉C^[B
     */
    protected BufferedWriter fWriter;

    /**
     * vf̊JñN[YyfBOꂽ܂܂ǂB
     */
    protected boolean fIsStartElementClosePending = false;

    /**
     * C^[擾܂B
     * 
     * @return VACYΏۂƂȂ郉C^[B
     */
    public BufferedWriter getWriter() {
        return fWriter;
    }

    /**
     * C^[ݒ肵܂B
     * 
     * @param writer
     *            VACYΏۂƂȂ郉C^[B
     */
    public void setWriter(final BufferedWriter writer) {
        fWriter = writer;
    }

    //
    // ContentHandler
    //

    public void setDocumentLocator(final Locator locator) {
        if (fWriter == null) {
            throw new IllegalArgumentException("܂O: C^[nullłB");
        }
    }

    /**
     * hLg̊JnB
     */
    public void startDocument() throws SAXException {
        if (fWriter == null) {
            throw new IllegalArgumentException("܂O: C^[nullłB");
        }
    }

    /**
     * hLg̏IB
     * 
     * C^[ flush Ȃ܂Bclose ͂ȂȂ̂ŁAOŎ{ĂB
     * 
     * @throws IOException
     *             o͗OꍇB
     */
    public void endDocument() throws SAXException {
        flushElementClosePending();

        try {
            if (fWriter != null) {
                // ̃^C~O flush Ȃ܂B
                fWriter.flush();
                //  close ͂Ȃ܂B
                // close ͊OŎ{ĂB
            }
        } catch (IOException e) {
            throw new SAXException(e);
        }
    }

    /**
     * Gg̊JnB
     * 
     * HTMLƂ̂߁Astart  end ƂK΂ɔ܂B
     * 
     * @param name
     *            vfB
     * @param attrs
     *            XgB
     * @throws IOException
     *             o͗OꍇB
     */
    public void startElement(final String uri, final String localName,
            final String name, final Attributes atts) throws SAXException {
        if (fWriter == null) {
            throw new IllegalArgumentException("܂O: C^[nullłB");
        }

        // JAB
        flushElementClosePending();

        try {
            fWriter.write('<');
            fWriter.write(name);

            if (atts instanceof BlancoXmlAttributesImpl) {
                final List<BlancoXmlAttribute> list = ((BlancoXmlAttributesImpl) atts)
                        .getList();
                for (int index = 0; index < list.size(); index++) {
                    final BlancoHtmlAttribute attr = (BlancoHtmlAttribute) list
                            .get(index);

                    fWriter.write(' ');
                    fWriter.write(attr.getQName());

                    if (attr.getValue() != null) {
                        fWriter.write('=');

                        switch (attr.getQuote()) {
                        case 0:
                            break;
                        case 1:
                            fWriter.write('\'');
                            break;
                        case 2:
                        default:
                            fWriter.write('"');
                            break;
                        }

                        fWriter.write(encodeCharReference(attr.getValue()));

                        switch (attr.getQuote()) {
                        case 0:
                            break;
                        case 1:
                            fWriter.write('\'');
                            break;
                        case 2:
                        default:
                            fWriter.write('"');
                            break;
                        }
                    } else {
                        // l̖B
                    }
                }
            } else
                for (int index = 0; index < atts.getLength(); index++) {
                    final String attrQName = atts.getQName(index);
                    final String attrValue = atts.getValue(index);

                    fWriter.write(' ');
                    fWriter.write(attrQName);

                    if (attrValue != null) {
                        fWriter.write('=');

                        // TODO NI[gɂǂ̂f邱

                        fWriter.write('"');

                        fWriter.write(attrValue);

                        fWriter.write('"');
                    } else {
                        // l̖B
                    }
                }
        } catch (IOException e) {
            throw new SAXException(e);
        }

        fIsStartElementClosePending = true;
    }

    /**
     * Gg̏IB
     * 
     * HTMLƂ̂߁Astart  end ƂK΂ɔ܂B
     * 
     * @param name
     *            vfB
     * @throws SAXException
     *             o͗OꍇB
     */
    public void endElement(final String uri, final String localName,
            final String name) throws SAXException {
        if (fWriter == null) {
            throw new IllegalArgumentException("܂O: C^[nullłB");
        }

        try {
            if (fIsStartElementClosePending) {
                // ȃN[YB
                fIsStartElementClosePending = false;
                fWriter.write(" />");
            } else {
                fWriter.write("</");
                fWriter.write(name);
                fWriter.write('>');
            }
        } catch (IOException e) {
            throw new SAXException(e);
        }
    }

    /**
     * BQƂȂǂ͏ Unicode Ƀ}bsO܂B
     * 
     * @param argCharacters
     *            BQƂȂǂ͏ Unicode Ƀ}bsO܂B
     */
    public void characters(char[] ch, int start, int length)
            throws SAXException {
        if (fWriter == null) {
            throw new IllegalArgumentException("܂O: C^[nullłB");
        }

        flushElementClosePending();

        try {
            fWriter.write(encodeCharReference(new String(ch, start, length)));
        } catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length)
            throws SAXException {
    }

    public void startPrefixMapping(final String prefix, final String uri)
            throws SAXException {
    }

    public void endPrefixMapping(final String prefix) throws SAXException {
    }

    public void processingInstruction(final String target, final String data)
            throws SAXException {
        // JAB
        flushElementClosePending();

        try {
            fWriter.write("<?");
            fWriter.write(target);
            fWriter.write(" ");
            fWriter.write(data);
            fWriter.write("?>");

        } catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void skippedEntity(final String name) throws SAXException {
    }

    /**
     * J̗vf΁A܂B
     * 
     * @throws IOException
     */
    protected void flushElementClosePending() throws SAXException {
        if (fIsStartElementClosePending) {
            fIsStartElementClosePending = false;
            try {
                fWriter.write('>');
            } catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    //
    // LexicalHandler
    //

    /**
     * RgB̂܂܂̕񂪖߂܂B
     * 
     * @param argComments
     *            RgBû܂܁vi[܂B
     * @param argType
     *            Rǧ`B0:!A1:%
     */
    public void comment(final char[] ch, final int start, final int length)
            throws SAXException {
        if (fWriter == null) {
            throw new IllegalArgumentException("܂O: C^[nullłB");
        }

        flushElementClosePending();

        try {
            // TODO JSP  <% Rg͕ʓrlĂB

            fWriter.write("<!--");

            fWriter.write(new String(ch, start, length));

            fWriter.write("-->");
        } catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startEntity(final String name) throws SAXException {
    }

    public void endEntity(final String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void startDTD(final String name, final String publicId,
            final String systemId) throws SAXException {
        // JAB
        flushElementClosePending();

        try {
            fWriter.write("<!DOCTYPE ");
            fWriter.write(name);
            fWriter.write(" PUBLIC \"");
            fWriter.write(publicId);
            fWriter.write("\"");
            if (BlancoStringUtil.null2Blank(systemId).length() > 0) {
                fWriter.write(" \"");
                fWriter.write(systemId);
                fWriter.write("\"");
            }
            fWriter.write(">");
        } catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endDTD() throws SAXException {
    }

    //
    // DTDHandler
    //

    public void notationDecl(final String name, final String publicId,
            final String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(final String name, final String publicId,
            final String systemId, final String notationName)
            throws SAXException {
    }

    /**
     * QƂGR[h܂B
     * 
     * @param argInput
     * @return
     */
    protected String encodeCharReference(final String argInput) {
        final StringWriter writer = new StringWriter();
        for (int index = 0; index < argInput.length(); index++) {
            final char look = argInput.charAt(index);
            if (fMapValue2Name.get(String.valueOf((int) look)) != null) {
                writer.write("&"
                        + fMapValue2Name.get(String.valueOf((int) look)) + ";");
            } else {
                writer.write(look);
            }
        }
        writer.flush();
        return writer.toString();
    }
}
