/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.html.parser.helper;

import java.util.StringTokenizer;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

import blanco.commons.util.BlancoStringUtil;

/**
 * GR[fBO𔻒f HTMLRecnh[B
 * 
 * @author IGA Tosiki
 */
public class BlancoHtmlDecideEncodingContentHandler extends XMLFilterImpl {
    /**
     * GR[fBOB
     */
    protected String fEncoding = null;

    /**
     * HTML 𒲂ׂʂ̕GR[fBO߂܂B
     * 
     * @return GR[fBOBȂꍇɂ nullB
     */
    public String getEncoding() {
        return fEncoding;
    }

    /**
     * vf̊JnB
     * 
     * HTMLƂ̂߁Astart  end ƂK΂ɔ܂B
     * 
     * @param name
     *            vfB
     * @param attrs
     *            ̃XgB
     * @throws o͗Oꍇ
     */

    public void startElement(final String uri, final String localName,
            final String name, final Attributes atts) throws SAXException {
        if (BlancoStringUtil.null2Blank(name).toLowerCase().equals("meta")) {
            boolean isInContentType = false;
            String content = null;

            for (int index = 0; index < atts.getLength(); index++) {
                final String attrQName = atts.getQName(index);
                final String attrValue = atts.getValue(index);
                if (attrQName.toLowerCase().equals("http-equiv")) {
                    if ("content-type".equals(BlancoStringUtil.null2Blank(
                            attrValue).toLowerCase())) {
                        // RecE^CvmetaƔB
                        isInContentType = true;
                    }
                }

                if (attrQName.toLowerCase().equals("content")) {
                    content = attrValue;
                }
            }

            if (isInContentType && content != null) {
                parseMetaContentTypeEncoding(content);
            }
        }
    }

    /**
     * meta  Content-Type  content 當GR[fBOǂݎ܂B
     * 
     * @param argContent
     */
    protected void parseMetaContentTypeEncoding(final String argContent) {
        final StringTokenizer contentParams = new StringTokenizer(
                BlancoStringUtil.null2Blank(argContent), ";");
        for (; contentParams.hasMoreTokens();) {
            final String nextParam = contentParams.nextToken();

            final StringTokenizer contentParam = new StringTokenizer(
                    BlancoStringUtil.null2Blank(nextParam), "=");
            if (contentParam.hasMoreTokens()) {
                final String paramKey = contentParam.nextToken();
                if (paramKey.trim().toLowerCase().equals("charset")) {
                    if (contentParam.hasMoreTokens()) {
                        final String paramValue = contentParam.nextToken();
                        if (fEncoding == null) {
                            fEncoding = paramValue.trim();
                            // System.out.println("encoding["
                            // + fEncoding + "]");
                            break;
                        }
                    }
                }
            }
        }
    }
}
