/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import jp.sourceforge.mergedoc.pleiades.aspect.Analyses;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationEditor
extends ExprEditor {
    private static final Logger log = Logger.getLogger(TranslationEditor.class);
    private final CtClass ctClass;
    private boolean isEdited;

    public TranslationEditor(CtClass ctClass) {
        this.ctClass = ctClass;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void edit(MethodCall methodCall) throws CannotCompileException {
        long start = System.nanoTime();
        try {
            String targetClassName = methodCall.getClassName();
            String targetMethodName = methodCall.getMethodName();
            AspectMapping mapping = AspectMapping.getInstance();
            if (!mapping.containsCall(targetClassName, targetMethodName)) {
                return;
            }
            JointPoint targetJP = new JointPoint();
            targetJP.setEditPoint(JointPoint.EditPoint.CALL);
            targetJP.setClassName(targetClassName);
            targetJP.setMethodName(targetMethodName);
            PointCut pointCut = mapping.getPointCut(targetJP);
            if (pointCut == null) {
                try {
                    CtMethod targetMethod = methodCall.getMethod();
                    targetJP.setDescriptor(targetMethod.getMethodInfo().getDescriptor());
                }
                catch (NotFoundException e) {
                    log.warn("\u30af\u30e9\u30b9\u30d1\u30b9\u306a\u3057\u3002" + targetClassName + " \u2190 " + this.ctClass.getName(), new Object[0]);
                    return;
                }
                pointCut = mapping.getPointCut(targetJP);
            }
            if (pointCut == null) {
                return;
            }
            if (!this.isEnabledLevel(pointCut.getLevel())) {
                return;
            }
            CtBehavior whereMethod = methodCall.where();
            String whereClassName = whereMethod.getDeclaringClass().getName();
            String whereMethodName = whereMethod.getName();
            if (this.containsWhere(pointCut.getExcludeWheres(), whereClassName, whereMethodName)) {
                return;
            }
            List<JointPoint> includeWheres = pointCut.getIncludeWheres();
            if (includeWheres.size() > 0 && !this.containsWhere(includeWheres, whereClassName, whereMethodName)) {
                return;
            }
            String advice = pointCut.getAdvice();
            if (advice.contains("?{")) {
                JointPoint whereJP = new JointPoint();
                whereJP.setEditPoint(JointPoint.EditPoint.CALL);
                whereJP.setClassName(whereMethod.getDeclaringClass().getName());
                whereJP.setMethodName(whereMethod.getName());
                whereJP.setDescriptor(whereMethod.getMethodInfo().getDescriptor());
                advice = this.bindArguments(advice, whereJP, targetJP);
            }
            methodCall.replace(advice);
            this.isEdited = true;
            return;
        }
        finally {
            Analyses.end(TranslationEditor.class, "edit", start);
        }
    }

    private boolean isEnabledLevel(String level) {
        if (level == null) {
            return true;
        }
        return log.isEnabled(Logger.Level.valueOf(level.toUpperCase()));
    }

    private boolean containsWhere(List<JointPoint> jointPointList, String whereClassName, String whereMethodName) {
        long start = System.nanoTime();
        try {
            for (JointPoint jointPoint : jointPointList) {
                String mName;
                if (!whereClassName.startsWith(jointPoint.getClassName()) || (mName = jointPoint.getMethodName()) != null && !whereMethodName.equals(mName)) continue;
                return true;
            }
            return false;
        }
        finally {
            Analyses.end(TranslationEditor.class, "containsWhere", start);
        }
    }

    private String bindArguments(String advice, JointPoint whereJP, JointPoint targetJP) {
        long start = System.nanoTime();
        if (advice.contains("?{JOINT_POINT}")) {
            advice = advice.replaceAll("\\?\\{JOINT_POINT\\}", Matcher.quoteReplacement("new " + JointPoint.class.getName() + "(" + JointPoint.EditPoint.class.getName() + "." + whereJP.getEditPoint().name() + ",\"" + whereJP.getClassName() + "\"" + ",\"" + whereJP.getMethodName() + "\"" + ",\"" + whereJP.getDescriptor() + "\"" + ")"));
        }
        if (advice.contains("?{TARGET_STRING}")) {
            advice = advice.replaceAll("\\?\\{TARGET_STRING\\}", Matcher.quoteReplacement("\"" + targetJP.getClassName() + "#" + targetJP.getMethodName() + StringUtils.trimToEmpty((String)targetJP.getDescriptor()) + "\""));
        }
        Analyses.end(TranslationEditor.class, "bindArguments", start);
        return advice;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void editBehavior(CtBehavior ctBehavior) throws CannotCompileException {
        long start = System.nanoTime();
        try {
            String className = this.ctClass.getName();
            String methodName = ctBehavior.getName();
            JointPoint jointPoint = new JointPoint();
            jointPoint.setEditPoint(JointPoint.EditPoint.EXECUTION);
            jointPoint.setClassName(className);
            jointPoint.setMethodName(methodName);
            jointPoint.setDescriptor(ctBehavior.getMethodInfo().getDescriptor());
            AspectMapping mapping = AspectMapping.getInstance();
            PointCut pointCut = mapping.getPointCut(jointPoint);
            if (pointCut == null) {
                return;
            }
            if (!this.isEnabledLevel(pointCut.getLevel())) {
                return;
            }
            PointCut.Timing timing = pointCut.getTiming();
            String advice = this.bindArguments(pointCut.getAdvice(), jointPoint, jointPoint);
            if (timing == PointCut.Timing.BEFORE) {
                ctBehavior.insertBefore(advice);
            } else {
                if (timing != PointCut.Timing.AFTER) throw new IllegalStateException("\u7de8\u96c6\u30dd\u30a4\u30f3\u30c8\u304c execution \u306e\u5834\u5408\u3001timing \u306f before \u307e\u305f\u306f after \u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002" + jointPoint);
                ctBehavior.insertAfter(advice);
            }
            this.isEdited = true;
            return;
        }
        finally {
            Analyses.end(TranslationEditor.class, "editBehavior", start);
        }
    }

    public byte[] toBytecode() throws IOException, CannotCompileException {
        long start = System.nanoTime();
        try {
            byte[] byArray = this.isEdited ? this.ctClass.toBytecode() : null;
            return byArray;
        }
        finally {
            Analyses.end(TranslationEditor.class, "toBytecode", start);
        }
    }
}

