/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.IOException;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import jp.sourceforge.mergedoc.pleiades.aspect.AbstractTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.Analyses;
import jp.sourceforge.mergedoc.pleiades.aspect.TranslationEditor;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.ExcludesClassNameCache;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TransformedClassCache;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

public class TranslationTransformer
extends AbstractTransformer {
    private static final Logger log = Logger.getLogger(TranslationTransformer.class);

    protected byte[] transform(ClassLoader loader, String className, ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        long start = System.nanoTime();
        try {
            ExcludesClassNameCache excludeList = ExcludesClassNameCache.getInstance();
            if (excludeList.contains(className)) {
                return null;
            }
            TransformedClassCache classCache = TransformedClassCache.getInstance();
            byte[] cachedBytecode = classCache.get(className);
            if (cachedBytecode != null) {
                byte[] byArray = cachedBytecode;
                return byArray;
            }
            CtClass ctClass = this.createCtClass(bytecode, protectionDomain);
            byte[] transformedBytecode = this.transformClass(ctClass);
            if (transformedBytecode == null) {
                excludeList.addNextLaunch(className);
            } else {
                classCache.putNextLaunch(className, transformedBytecode);
            }
            byte[] byArray = transformedBytecode;
            return byArray;
        }
        finally {
            Analyses.end(TranslationTransformer.class, "transform", start);
        }
    }

    protected byte[] transformClass(CtClass ctClass) throws CannotCompileException, NotFoundException, IOException {
        long start = System.nanoTime();
        TranslationEditor editor = new TranslationEditor(ctClass);
        CtBehavior[] ctBehaviorArray = ctClass.getDeclaredBehaviors();
        int n = ctBehaviorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtBehavior ctBehavior = ctBehaviorArray[n2];
            ctBehavior.instrument((ExprEditor)editor);
            editor.editBehavior(ctBehavior);
            ++n2;
        }
        CtConstructor ctInitializer = ctClass.getClassInitializer();
        if (ctInitializer != null) {
            ctInitializer.instrument((ExprEditor)editor);
        }
        Analyses.end(TranslationTransformer.class, "transformClass", start);
        return editor.toBytecode();
    }
}

