/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.Analyses;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.CacheFileNames;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcludesClassNameCache
implements CacheFileNames {
    private static final Logger log = Logger.getLogger(ExcludesClassNameCache.class);
    public static final File cacheFile = Pleiades.getResourceFile("excludes-class.list");
    private static final ExcludesClassNameCache singleton = new ExcludesClassNameCache();
    private Set<String> loadSet = new HashSet<String>();
    private Set<String> storeSet = new HashSet<String>();

    public static ExcludesClassNameCache getInstance() {
        return singleton;
    }

    private ExcludesClassNameCache() {
        this.loadSet = this.load();
    }

    private Set<String> load() {
        long start = System.nanoTime();
        HashSet<String> set = new HashSet<String>();
        if (Pleiades.getPleiadesOption().isClean()) {
            log.info("-clean \u306b\u3088\u308a " + cacheFile.getName() + " \u306f\u30ed\u30fc\u30c9\u3055\u308c\u307e\u305b\u3093\u3002", new Object[0]);
        } else if (!cacheFile.exists()) {
            log.info(String.valueOf(cacheFile.getName()) + " \u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002", new Object[0]);
        } else {
            try {
                set.addAll(FileUtils.readLines((File)cacheFile, null));
                log.info("load  %6d \u30a8\u30f3\u30c8\u30ea\u30fc %s", set.size(), cacheFile.getName());
            }
            catch (IOException e) {
                String msg = String.valueOf(cacheFile.getName()) + " \u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
                log.fatal(msg, new Object[0]);
                throw new IllegalStateException(msg, e);
            }
        }
        Analyses.end(ExcludesClassNameCache.class, "<init>", start);
        return set;
    }

    public void shutdown() {
        if (this.storeSet == null || this.storeSet.size() == 0) {
            return;
        }
        Set<String> set = this.load();
        try {
            Set<String> sSet = this.storeSet;
            this.storeSet = null;
            set.addAll(sSet);
            FileUtils.writeLines((File)cacheFile, null, set);
            log.info("store %6d \u30a8\u30f3\u30c8\u30ea\u30fc %s", set.size(), cacheFile.getName());
        }
        catch (IOException e) {
            log.error(e, String.valueOf(cacheFile.getName()) + " \u306e\u4fdd\u7ba1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", new Object[0]);
        }
    }

    public void addNextLaunch(String className) {
        if (this.storeSet == null) {
            return;
        }
        if (this.storeSet.contains(className)) {
            log.warn("\u3059\u306b\u3067\u30ad\u30e3\u30c3\u30b7\u30e5\u306b\u5b58\u5728\u3057\u307e\u3059\u3002" + className, new Object[0]);
            return;
        }
        this.storeSet.add(className);
    }

    public boolean contains(String className) {
        return this.loadSet.remove(className);
    }
}

