/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.RegexDictionary;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.FileNames;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.Mnemonics;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationNotFoundProperties;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationString;

public abstract class AbstractTranslationDictionary
implements FileNames {
    private static final Logger log = Logger.getLogger(AbstractTranslationDictionary.class);
    protected final PropertySet transProp = new PropertySet();
    protected volatile boolean isLoadedDefault;
    private volatile boolean isLoadedHelp;
    private final TranslationNotFoundProperties notFoundLog = TranslationNotFoundProperties.getInstance();

    protected AbstractTranslationDictionary() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean load() {
        if (this.isLoadedDefault) {
            return false;
        }
        Class<AbstractTranslationDictionary> clazz = AbstractTranslationDictionary.class;
        synchronized (AbstractTranslationDictionary.class) {
            File convFile;
            block9: {
                if (!this.isLoadedDefault) break block9;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            this.transProp.load(AbstractTranslationDictionary.validateExists("translation.properties"));
            this.transProp.load(AbstractTranslationDictionary.validateExists("translation-multibytes-key.properties"));
            File addDir = Files.getResourceFile("additions");
            if (addDir.exists()) {
                PropertySet addProp = new PropertySet(new File[]{addDir}){

                    public String put(String en, String ja) {
                        en = TranslationString.trim(Mnemonics.removeEnMnemonic(en));
                        ja = TranslationString.trim(Mnemonics.removeJaMnemonic(ja));
                        return super.put(en, ja);
                    }
                };
                this.transProp.putAll(addProp);
            }
            if ((convFile = Files.getResourceFile("translation-converter.properties")).exists()) {
                PropertySet convMap = new PropertySet(convFile);
                for (Property p : this.transProp) {
                    String resultValue = p.value;
                    for (Property conv : convMap) {
                        resultValue = resultValue.replaceAll(conv.key, conv.value);
                    }
                    if (p.value.equals(resultValue)) continue;
                    this.transProp.put(p.key, resultValue);
                }
            }
            this.isLoadedDefault = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadHelp() {
        if (this.isLoadedHelp) {
            return false;
        }
        Class<AbstractTranslationDictionary> clazz = AbstractTranslationDictionary.class;
        synchronized (AbstractTranslationDictionary.class) {
            block6: {
                if (!this.isLoadedHelp) break block6;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            for (Property p : new PropertySet(AbstractTranslationDictionary.validateExists("translation-help-html.properties"))) {
                if (this.transProp.containsKey(p.key)) continue;
                this.transProp.put(p);
            }
            this.isLoadedHelp = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    public static File validateExists(String fileName) {
        File propFile = Files.getResourceFile(fileName);
        if (!propFile.exists()) {
            String msg = String.valueOf(propFile.getName()) + " \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002";
            log.fatal(msg, new Object[0]);
            FileNotFoundException e = new FileNotFoundException(propFile.getPath());
            throw new IllegalStateException(msg, e);
        }
        return propFile;
    }

    protected String getValue(String en) {
        if (en.equals("")) {
            return en;
        }
        String ja = (String)this.transProp.get(en);
        if (ja != null) {
            return ja;
        }
        TranslationString enTs = new TranslationString(en);
        ja = this.getValueByRegex(enTs);
        if (ja != null) {
            this.transProp.put(en, ja);
            return ja;
        }
        ja = this.getValueToTrim(enTs);
        if (ja != null) {
            this.transProp.put(en, ja);
            return ja;
        }
        List<TranslationString> enPartTsList = enTs.split();
        if (enPartTsList != null) {
            StringBuilder sb = new StringBuilder();
            for (TranslationString enPartTs : enPartTsList) {
                String enPartTrim = enPartTs.trim();
                String jaPart = this.getValueToTrim(enPartTs);
                if (jaPart == null) {
                    this.notFoundLog.println(enPartTrim);
                    jaPart = enPartTs.toString();
                }
                sb.append(jaPart);
            }
            ja = enTs.revert(sb.toString());
            if (!ja.equals(en)) {
                this.transProp.put(en, ja);
                return ja;
            }
        }
        this.notFoundLog.println(enTs.trim());
        this.transProp.put(en, en);
        return en;
    }

    protected String getValueToTrim(TranslationString enTs) {
        String enTrim = enTs.trim();
        if (enTrim.equals("")) {
            return enTs.toString();
        }
        String ja = (String)this.transProp.get(enTrim);
        if (ja != null) {
            return enTs.revert(ja);
        }
        ja = (String)this.transProp.get(enTrim = TranslationString.removeS(enTrim));
        if (ja != null) {
            return enTs.revert(ja);
        }
        String enTrimForce = enTs.trimForce();
        ja = (String)this.transProp.get(enTrimForce);
        if (ja != null) {
            return enTs.revert(ja);
        }
        return null;
    }

    protected String getValueByRegex(TranslationString enTs) {
        String ja = RegexDictionary.getInstance().lookup(enTs.trim());
        if (ja != null) {
            return enTs.revert(ja);
        }
        return null;
    }
}

