/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpHtmlParser
implements Iterable<HtmlFragment> {
    private static final Logger log = Logger.getLogger(HelpHtmlParser.class);
    private static final String JA_CHARSET = "Windows-31J";
    private byte[] inputBytes;
    private String inputString;
    private Matcher blockTagMatcher;
    private int blockTagMatcherStart;
    private Matcher tagMatcher;
    private StringBuffer outputBuffer;

    public HelpHtmlParser(InputStream is) {
        String EN_CHARSET = "ISO-8859-1";
        String UNI_CHARSET = "UTF-8";
        try {
            this.inputBytes = IOUtils.toByteArray((InputStream)is);
            this.inputString = new String(this.inputBytes, "ISO-8859-1").trim();
            if (this.inputString.startsWith("<!DOCTYPE")) {
                String charset = this.inputString.replaceFirst("(?i)(?s).+?text/html; charset=([^\"]+).+", "$1");
                if (charset.matches("(?i)(shift_jis|Windows-31J)")) {
                    this.inputString = new String(this.inputBytes, JA_CHARSET);
                } else if (charset.equalsIgnoreCase("UTF-8")) {
                    this.inputString = new String(this.inputBytes, "UTF-8");
                } else if (!charset.equalsIgnoreCase("ISO-8859-1")) {
                    log.warn("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u306a\u3044\u6587\u5b57\u30bb\u30c3\u30c8\uff1a" + charset, new Object[0]);
                    return;
                }
                String html4StrictBlockElements = "p|div|table|dl|ul|ol|form|address|blockquote|h[1-6]|fieldset|hr|pre";
                String blockElementsEx = "li|title|th|td|" + html4StrictBlockElements;
                String blockTags = "(?i)(?s)<(|/)(" + blockElementsEx + ")(>|\\s+[^>]*>)";
                Pattern blockTagPattern = Pattern.compile(String.valueOf(blockTags) + "(.+?)" + blockTags);
                this.blockTagMatcher = blockTagPattern.matcher(this.inputString);
                this.outputBuffer = new StringBuffer();
            }
        }
        catch (Exception e) {
            log.error(e, "\u30d8\u30eb\u30d7 HTML \u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", new Object[0]);
        }
    }

    @Override
    public Iterator<HtmlFragment> iterator() {
        return new Iterator<HtmlFragment>(){
            private int id;
            private HtmlFragment f;
            private boolean debug = false;

            private boolean isNoText(String group123, String group2) {
                if (group123.matches("(?i)(?s)<pre>.+</pre>") || group2.trim().equals("") || group2.matches("(?i)(?s)(.+<body.+|<font[^>]*>|<[\\w/]+>|</tr>.*<tr.*>)\\s*")) {
                    return true;
                }
                return group2.matches("(?i)(?s)(<[^>]+>\\s*)+") && !group2.matches("(?i)(?s).*?\\salt=.*");
            }

            @Override
            public boolean hasNext() {
                if (HelpHtmlParser.this.blockTagMatcher == null || !HelpHtmlParser.this.blockTagMatcher.find(HelpHtmlParser.this.blockTagMatcherStart)) {
                    return false;
                }
                HelpHtmlParser.this.outputBuffer.append(HelpHtmlParser.this.inputString.substring(HelpHtmlParser.this.blockTagMatcherStart, HelpHtmlParser.this.blockTagMatcher.start()));
                String group123 = HelpHtmlParser.this.blockTagMatcher.group();
                Pattern pat = Pattern.compile("(?i)(?s)^(<.+?>\\s*)(.+)(\\s*<.+>)$");
                HelpHtmlParser.this.tagMatcher = pat.matcher(group123);
                if (!HelpHtmlParser.this.tagMatcher.find()) {
                    throw new IllegalArgumentException("HTML \u30d5\u30e9\u30b0\u30e1\u30f3\u30c8\u4e0d\u6b63\uff1a" + group123);
                }
                HelpHtmlParser.this.blockTagMatcherStart = HelpHtmlParser.this.blockTagMatcher.end() - (HelpHtmlParser.this.tagMatcher.end() - HelpHtmlParser.this.tagMatcher.end(2));
                String group2 = HelpHtmlParser.this.tagMatcher.group(2);
                String group12 = String.valueOf(HelpHtmlParser.this.tagMatcher.group(1)) + HelpHtmlParser.this.tagMatcher.group(2);
                if (this.isNoText(group123, group2)) {
                    if (this.debug && HelpHtmlParser.this.outputBuffer.length() < 10000) {
                        System.out.println("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                        System.out.println("\u00d71|" + HelpHtmlParser.this.tagMatcher.group(1));
                        System.out.println("\u00d72|" + HelpHtmlParser.this.tagMatcher.group(2));
                        System.out.println("\u00d73|" + HelpHtmlParser.this.tagMatcher.group(3));
                    }
                    HelpHtmlParser.this.outputBuffer.append(group12);
                    return this.hasNext();
                }
                this.f = new HtmlFragment(this.id++);
                this.f.starts = HelpHtmlParser.this.tagMatcher.group(1);
                this.f.text = HelpHtmlParser.this.tagMatcher.group(2);
                String p = "(?i)(?s)^(.+)(\\s*<font.*>)$";
                Matcher m = Pattern.compile(p).matcher(this.f.text);
                if (m.find()) {
                    this.f.text = m.group(1);
                    this.f.ends = String.valueOf(m.group(2)) + this.f.ends;
                }
                if ((m = Pattern.compile(p = "(?i)(?s)^(<(p|/font)>\\s*)(.+)$").matcher(this.f.text)).find()) {
                    HtmlFragment htmlFragment = this.f;
                    htmlFragment.starts = String.valueOf(htmlFragment.starts) + m.group(1);
                    this.f.text = m.group(3);
                }
                if ((m = Pattern.compile(p = "(?i)(?s)^((|\u300c)<a\\s+.+>\\p{ASCII}+?</a>[\\s-\u300d]*)(.+)$").matcher(this.f.text)).find()) {
                    HtmlFragment htmlFragment = this.f;
                    htmlFragment.starts = String.valueOf(htmlFragment.starts) + m.group(1);
                    this.f.text = m.group(3);
                }
                if ((m = Pattern.compile(p = "(?i)(?s)^(.+?)(\\s*(|\\()\\s*<a\\s+.+>\\p{ASCII}+?</a>\\s*(|\\)))$").matcher(this.f.text)).find()) {
                    this.f.text = m.group(1);
                    this.f.ends = String.valueOf(m.group(2)) + this.f.ends;
                }
                while ((m = Pattern.compile(p = "(?i)(?s)^(<[^>]+>\\s*)(.+?)(\\s*</[^>]+>)$").matcher(this.f.text)).find()) {
                    HtmlFragment htmlFragment = this.f;
                    htmlFragment.starts = String.valueOf(htmlFragment.starts) + m.group(1);
                    this.f.text = m.group(2);
                    this.f.ends = String.valueOf(m.group(3)) + this.f.ends;
                }
                p = "(?i)(?s)^(<[^>]+\\salt=\")(.+?)(\"[^>]*>\\s*)$";
                m = Pattern.compile(p).matcher(this.f.text);
                if (m.find()) {
                    HtmlFragment htmlFragment = this.f;
                    htmlFragment.starts = String.valueOf(htmlFragment.starts) + m.group(1);
                    this.f.text = m.group(2);
                    this.f.ends = String.valueOf(m.group(3)) + this.f.ends;
                }
                if (this.debug && HelpHtmlParser.this.outputBuffer.length() < 10000) {
                    System.out.println("\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                    System.out.println("\u25cb1|" + this.f.starts);
                    System.out.println("\u25cb2|" + this.f.text);
                    System.out.println("\u25cb3|" + this.f.ends);
                }
                if (this.f.text.matches("(?s)^(|\")[A-Z1-9_]+(|\")$")) {
                    HelpHtmlParser.this.outputBuffer.append(group12);
                    return this.hasNext();
                }
                return true;
            }

            @Override
            public HtmlFragment next() {
                return this.f;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public InputStream getInputStream() {
        if (this.blockTagMatcher == null) {
            return new ByteArrayInputStream(this.inputBytes);
        }
        try {
            this.outputBuffer.append(this.inputString.substring(this.blockTagMatcherStart));
            String s = this.outputBuffer.toString().replaceFirst("(text/html; charset=)[^\"]+", "$1shift_jis");
            return new ByteArrayInputStream(s.getBytes(JA_CHARSET));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public class HtmlFragment {
        public final int id;
        private String starts = "";
        private String text = "";
        private String textBackup = "";
        private String ends = "";

        HtmlFragment(int id) {
            this.id = id;
        }

        public String getText() {
            this.textBackup = this.text.replaceAll("[\\r|\\n]", " ").replaceAll("\\s+", " ");
            return this.textBackup;
        }

        public void setText(String text) {
            if (text.equals(this.textBackup)) {
                text = this.text;
            }
            String s = String.valueOf(this.starts) + text + this.ends;
            HelpHtmlParser.this.outputBuffer.append(s);
        }

        public String toString() {
            String p = "id" + this.id + ":group";
            return String.valueOf(p) + "1| " + this.starts.trim() + "\n" + p + "2| " + this.getText() + "\n" + p + "3| " + this.ends.trim() + HelpHtmlParser.this.tagMatcher.group(3);
        }
    }
}

