/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import org.apache.commons.io.FileUtils;

public class MetadataDefaultInitializer {
    private static Logger log = Logger.getLogger(MetadataDefaultInitializer.class);
    private static final List<String> EXCLUDES = Collections.unmodifiableList(new LinkedList<String>(){
        {
            this.add(".*~");
            this.add("#.*#");
            this.add(".#.*");
            this.add("%.*%");
            this.add("\\._.*");
            this.add("CVS");
            this.add("\\.cvsignore");
            this.add("SCCS");
            this.add("vssver\\.scc");
            this.add("\\.svn");
            this.add("\\.DS_Store");
            this.add("\\.bzr");
            this.add("\\.cdv");
            this.add("\\.git");
            this.add("\\.hg");
            this.add("\\.pc");
            this.add("RCS");
            this.add("_darcs");
            this.add("_sgbak");
            this.add("vssver2\\.scc");
            this.add("_svn");
        }

        @Override
        public boolean contains(Object name) {
            for (String pattern : this) {
                if (!((String)name).matches(pattern)) continue;
                return true;
            }
            return false;
        }
    });
    private final String ECLIPSE_HOME_PARENT;
    private File metadataDefaultDir;
    private File srcRootDir;
    private File dstRootDir;
    private int copyCount;

    public static void init() {
        try {
            new MetadataDefaultInitializer();
        }
        catch (Exception e) {
            log.error(e, "metadata \u30c7\u30d5\u30a9\u30eb\u30c8\u8a2d\u5b9a\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", new Object[0]);
        }
    }

    private MetadataDefaultInitializer() throws URISyntaxException, IOException {
        File eclipseHomeParent = Pleiades.getEclipseHome().getParentFile();
        String string = this.ECLIPSE_HOME_PARENT = eclipseHomeParent != null ? eclipseHomeParent.getPath().replace("\\", "/") : null;
        if (this.ECLIPSE_HOME_PARENT == null) {
            return;
        }
        this.metadataDefaultDir = new File(this.ECLIPSE_HOME_PARENT, ".metadata.default");
        if (!this.metadataDefaultDir.exists()) {
            return;
        }
        this.srcRootDir = new File(this.metadataDefaultDir, ".plugins");
        this.dstRootDir = new File(new File(this.getWorkspace(), ".metadata"), ".plugins");
        this.copyMetadata(this.srcRootDir);
        if (this.copyCount > 0) {
            log.info(".metadata.default \u304b\u3089 " + this.copyCount + " \u500b\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f\u3002" + this.dstRootDir.getParentFile(), new Object[0]);
        }
    }

    private void copyMetadata(File srcDir) throws IOException {
        File[] fileArray = srcDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File src = fileArray[n2];
            if (!EXCLUDES.contains(src.getName())) {
                if (src.isDirectory()) {
                    this.copyMetadata(src);
                } else {
                    File dst = new File(this.dstRootDir, Files.relativePath(this.srcRootDir, src));
                    if (!dst.exists()) {
                        String s = FileUtils.readFileToString((File)src);
                        s = s.replace("%ECLIPSE_HOME_PARENT%", this.ECLIPSE_HOME_PARENT);
                        FileUtils.writeStringToFile((File)dst, (String)s);
                        ++this.copyCount;
                    }
                }
            }
            ++n2;
        }
    }

    private File getWorkspace() throws URISyntaxException {
        String workspacePath = System.getProperty("osgi.instance.area");
        if (workspacePath != null) {
            return new File(new URI(workspacePath));
        }
        File idePrefs = Pleiades.getResourceFile("../.settings/org.eclipse.ui.ide.prefs");
        String value = (String)new PropertySet(idePrefs).get("RECENT_WORKSPACES");
        workspacePath = value.replaceFirst("\n.*", "");
        return new File(workspacePath);
    }
}

